/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.ServicePrincipalsClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfAppRoleAssignment0;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfAppRoleAssignment1;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfClaimsMappingPolicy;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDelegatedPermissionClassification;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject0;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject1;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject2;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject3;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject4;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfEndpoint;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfHomeRealmDiscoveryPolicy0;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfClaimsMappingPolicy;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject0;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject1;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject2;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject3;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject4;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfHomeRealmDiscoveryPolicy0;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfOAuth2PermissionGrant;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfTokenIssuancePolicy0;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfTokenLifetimePolicy0;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfOAuth2PermissionGrant;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfTokenIssuancePolicy0;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfTokenLifetimePolicy0;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphAppRoleAssignmentInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphClaimsMappingPolicyInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDelegatedPermissionClassificationInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEndpointInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionPropertyInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphHomeRealmDiscoveryPolicyInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphKeyCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOAuth2PermissionGrantInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPasswordCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphServicePrincipalInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTokenIssuancePolicyInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTokenLifetimePolicyInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsAddKeyRequestBodyInner;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsAddPasswordRequestBodyInner;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsCheckMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsCheckMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsExpand;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsGetAvailableExtensionPropertiesRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsGetByIdsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsGetMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsGetMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsOrderby;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsRemoveKeyRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsRemovePasswordRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsSelect;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsValidatePropertiesRequestBody;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class ServicePrincipalsClientImpl
implements ServicePrincipalsClient {
    private final ClientLogger logger = new ClientLogger(ServicePrincipalsClientImpl.class);
    private final ServicePrincipalsService service;
    private final MicrosoftGraphClientImpl client;

    ServicePrincipalsClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (ServicePrincipalsService)RestProxy.create(ServicePrincipalsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphAppRoleAssignmentInner>> listAppRoleAssignedToSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listAppRoleAssignedTo(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfAppRoleAssignment0)res.getValue()).value(), ((CollectionOfAppRoleAssignment0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphAppRoleAssignmentInner>> listAppRoleAssignedToSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listAppRoleAssignedTo(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfAppRoleAssignment0)res.getValue()).value(), ((CollectionOfAppRoleAssignment0)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignedToAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listAppRoleAssignedToSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignedToAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listAppRoleAssignedToSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignedToAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listAppRoleAssignedToSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignedTo(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        List<ServicePrincipalsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listAppRoleAssignedToAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignedTo(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listAppRoleAssignedToAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> createAppRoleAssignedToWithResponseAsync(String servicePrincipalId, MicrosoftGraphAppRoleAssignmentInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createAppRoleAssignedTo(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> createAppRoleAssignedToWithResponseAsync(String servicePrincipalId, MicrosoftGraphAppRoleAssignmentInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createAppRoleAssignedTo(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphAppRoleAssignmentInner> createAppRoleAssignedToAsync(String servicePrincipalId, MicrosoftGraphAppRoleAssignmentInner body) {
        return this.createAppRoleAssignedToWithResponseAsync(servicePrincipalId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphAppRoleAssignmentInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphAppRoleAssignmentInner createAppRoleAssignedTo(String servicePrincipalId, MicrosoftGraphAppRoleAssignmentInner body) {
        return (MicrosoftGraphAppRoleAssignmentInner)this.createAppRoleAssignedToAsync(servicePrincipalId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphAppRoleAssignmentInner> createAppRoleAssignedToWithResponse(String servicePrincipalId, MicrosoftGraphAppRoleAssignmentInner body, Context context) {
        return (Response)this.createAppRoleAssignedToWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> getAppRoleAssignedToWithResponseAsync(String servicePrincipalId, String appRoleAssignmentId, List<ServicePrincipalsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getAppRoleAssignedTo(this.client.getEndpoint(), servicePrincipalId, appRoleAssignmentId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> getAppRoleAssignedToWithResponseAsync(String servicePrincipalId, String appRoleAssignmentId, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getAppRoleAssignedTo(this.client.getEndpoint(), servicePrincipalId, appRoleAssignmentId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphAppRoleAssignmentInner> getAppRoleAssignedToAsync(String servicePrincipalId, String appRoleAssignmentId, List<ServicePrincipalsSelect> select, List<String> expand) {
        return this.getAppRoleAssignedToWithResponseAsync(servicePrincipalId, appRoleAssignmentId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphAppRoleAssignmentInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphAppRoleAssignmentInner> getAppRoleAssignedToAsync(String servicePrincipalId, String appRoleAssignmentId) {
        List<ServicePrincipalsSelect> select = null;
        List<String> expand = null;
        return this.getAppRoleAssignedToWithResponseAsync(servicePrincipalId, appRoleAssignmentId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphAppRoleAssignmentInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphAppRoleAssignmentInner getAppRoleAssignedTo(String servicePrincipalId, String appRoleAssignmentId) {
        List<ServicePrincipalsSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphAppRoleAssignmentInner)this.getAppRoleAssignedToAsync(servicePrincipalId, appRoleAssignmentId, select, expand).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphAppRoleAssignmentInner> getAppRoleAssignedToWithResponse(String servicePrincipalId, String appRoleAssignmentId, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return (Response)this.getAppRoleAssignedToWithResponseAsync(servicePrincipalId, appRoleAssignmentId, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateAppRoleAssignedToWithResponseAsync(String servicePrincipalId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateAppRoleAssignedTo(this.client.getEndpoint(), servicePrincipalId, appRoleAssignmentId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateAppRoleAssignedToWithResponseAsync(String servicePrincipalId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateAppRoleAssignedTo(this.client.getEndpoint(), servicePrincipalId, appRoleAssignmentId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateAppRoleAssignedToAsync(String servicePrincipalId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body) {
        return this.updateAppRoleAssignedToWithResponseAsync(servicePrincipalId, appRoleAssignmentId, body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateAppRoleAssignedTo(String servicePrincipalId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body) {
        this.updateAppRoleAssignedToAsync(servicePrincipalId, appRoleAssignmentId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateAppRoleAssignedToWithResponse(String servicePrincipalId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body, Context context) {
        return (Response)this.updateAppRoleAssignedToWithResponseAsync(servicePrincipalId, appRoleAssignmentId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAppRoleAssignedToWithResponseAsync(String servicePrincipalId, String appRoleAssignmentId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteAppRoleAssignedTo(this.client.getEndpoint(), servicePrincipalId, appRoleAssignmentId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteAppRoleAssignedToWithResponseAsync(String servicePrincipalId, String appRoleAssignmentId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteAppRoleAssignedTo(this.client.getEndpoint(), servicePrincipalId, appRoleAssignmentId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAppRoleAssignedToAsync(String servicePrincipalId, String appRoleAssignmentId, String ifMatch) {
        return this.deleteAppRoleAssignedToWithResponseAsync(servicePrincipalId, appRoleAssignmentId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAppRoleAssignedToAsync(String servicePrincipalId, String appRoleAssignmentId) {
        String ifMatch = null;
        return this.deleteAppRoleAssignedToWithResponseAsync(servicePrincipalId, appRoleAssignmentId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAppRoleAssignedTo(String servicePrincipalId, String appRoleAssignmentId) {
        String ifMatch = null;
        this.deleteAppRoleAssignedToAsync(servicePrincipalId, appRoleAssignmentId, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteAppRoleAssignedToWithResponse(String servicePrincipalId, String appRoleAssignmentId, String ifMatch, Context context) {
        return (Response)this.deleteAppRoleAssignedToWithResponseAsync(servicePrincipalId, appRoleAssignmentId, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphAppRoleAssignmentInner>> listAppRoleAssignmentsSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listAppRoleAssignments(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfAppRoleAssignment1)res.getValue()).value(), ((CollectionOfAppRoleAssignment1)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphAppRoleAssignmentInner>> listAppRoleAssignmentsSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listAppRoleAssignments(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfAppRoleAssignment1)res.getValue()).value(), ((CollectionOfAppRoleAssignment1)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignmentsAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listAppRoleAssignmentsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listAppRoleAssignmentsNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignmentsAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listAppRoleAssignmentsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listAppRoleAssignmentsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignmentsAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listAppRoleAssignmentsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listAppRoleAssignmentsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignments(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        List<ServicePrincipalsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listAppRoleAssignmentsAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignments(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listAppRoleAssignmentsAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> createAppRoleAssignmentsWithResponseAsync(String servicePrincipalId, MicrosoftGraphAppRoleAssignmentInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createAppRoleAssignments(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> createAppRoleAssignmentsWithResponseAsync(String servicePrincipalId, MicrosoftGraphAppRoleAssignmentInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createAppRoleAssignments(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphAppRoleAssignmentInner> createAppRoleAssignmentsAsync(String servicePrincipalId, MicrosoftGraphAppRoleAssignmentInner body) {
        return this.createAppRoleAssignmentsWithResponseAsync(servicePrincipalId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphAppRoleAssignmentInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphAppRoleAssignmentInner createAppRoleAssignments(String servicePrincipalId, MicrosoftGraphAppRoleAssignmentInner body) {
        return (MicrosoftGraphAppRoleAssignmentInner)this.createAppRoleAssignmentsAsync(servicePrincipalId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphAppRoleAssignmentInner> createAppRoleAssignmentsWithResponse(String servicePrincipalId, MicrosoftGraphAppRoleAssignmentInner body, Context context) {
        return (Response)this.createAppRoleAssignmentsWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> getAppRoleAssignmentsWithResponseAsync(String servicePrincipalId, String appRoleAssignmentId, List<ServicePrincipalsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getAppRoleAssignments(this.client.getEndpoint(), servicePrincipalId, appRoleAssignmentId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> getAppRoleAssignmentsWithResponseAsync(String servicePrincipalId, String appRoleAssignmentId, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getAppRoleAssignments(this.client.getEndpoint(), servicePrincipalId, appRoleAssignmentId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphAppRoleAssignmentInner> getAppRoleAssignmentsAsync(String servicePrincipalId, String appRoleAssignmentId, List<ServicePrincipalsSelect> select, List<String> expand) {
        return this.getAppRoleAssignmentsWithResponseAsync(servicePrincipalId, appRoleAssignmentId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphAppRoleAssignmentInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphAppRoleAssignmentInner> getAppRoleAssignmentsAsync(String servicePrincipalId, String appRoleAssignmentId) {
        List<ServicePrincipalsSelect> select = null;
        List<String> expand = null;
        return this.getAppRoleAssignmentsWithResponseAsync(servicePrincipalId, appRoleAssignmentId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphAppRoleAssignmentInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphAppRoleAssignmentInner getAppRoleAssignments(String servicePrincipalId, String appRoleAssignmentId) {
        List<ServicePrincipalsSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphAppRoleAssignmentInner)this.getAppRoleAssignmentsAsync(servicePrincipalId, appRoleAssignmentId, select, expand).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphAppRoleAssignmentInner> getAppRoleAssignmentsWithResponse(String servicePrincipalId, String appRoleAssignmentId, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return (Response)this.getAppRoleAssignmentsWithResponseAsync(servicePrincipalId, appRoleAssignmentId, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateAppRoleAssignmentsWithResponseAsync(String servicePrincipalId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateAppRoleAssignments(this.client.getEndpoint(), servicePrincipalId, appRoleAssignmentId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateAppRoleAssignmentsWithResponseAsync(String servicePrincipalId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateAppRoleAssignments(this.client.getEndpoint(), servicePrincipalId, appRoleAssignmentId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateAppRoleAssignmentsAsync(String servicePrincipalId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body) {
        return this.updateAppRoleAssignmentsWithResponseAsync(servicePrincipalId, appRoleAssignmentId, body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateAppRoleAssignments(String servicePrincipalId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body) {
        this.updateAppRoleAssignmentsAsync(servicePrincipalId, appRoleAssignmentId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateAppRoleAssignmentsWithResponse(String servicePrincipalId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body, Context context) {
        return (Response)this.updateAppRoleAssignmentsWithResponseAsync(servicePrincipalId, appRoleAssignmentId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAppRoleAssignmentsWithResponseAsync(String servicePrincipalId, String appRoleAssignmentId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteAppRoleAssignments(this.client.getEndpoint(), servicePrincipalId, appRoleAssignmentId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteAppRoleAssignmentsWithResponseAsync(String servicePrincipalId, String appRoleAssignmentId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteAppRoleAssignments(this.client.getEndpoint(), servicePrincipalId, appRoleAssignmentId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAppRoleAssignmentsAsync(String servicePrincipalId, String appRoleAssignmentId, String ifMatch) {
        return this.deleteAppRoleAssignmentsWithResponseAsync(servicePrincipalId, appRoleAssignmentId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAppRoleAssignmentsAsync(String servicePrincipalId, String appRoleAssignmentId) {
        String ifMatch = null;
        return this.deleteAppRoleAssignmentsWithResponseAsync(servicePrincipalId, appRoleAssignmentId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAppRoleAssignments(String servicePrincipalId, String appRoleAssignmentId) {
        String ifMatch = null;
        this.deleteAppRoleAssignmentsAsync(servicePrincipalId, appRoleAssignmentId, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteAppRoleAssignmentsWithResponse(String servicePrincipalId, String appRoleAssignmentId, String ifMatch, Context context) {
        return (Response)this.deleteAppRoleAssignmentsWithResponseAsync(servicePrincipalId, appRoleAssignmentId, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphClaimsMappingPolicyInner>> listClaimsMappingPoliciesSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<ServicePrincipalsExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listClaimsMappingPolicies(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfClaimsMappingPolicy)res.getValue()).value(), ((CollectionOfClaimsMappingPolicy)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphClaimsMappingPolicyInner>> listClaimsMappingPoliciesSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<ServicePrincipalsExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listClaimsMappingPolicies(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfClaimsMappingPolicy)res.getValue()).value(), ((CollectionOfClaimsMappingPolicy)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphClaimsMappingPolicyInner> listClaimsMappingPoliciesAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<ServicePrincipalsExpand> expand) {
        return new PagedFlux(() -> this.listClaimsMappingPoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listClaimsMappingPoliciesNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphClaimsMappingPolicyInner> listClaimsMappingPoliciesAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listClaimsMappingPoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listClaimsMappingPoliciesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphClaimsMappingPolicyInner> listClaimsMappingPoliciesAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<ServicePrincipalsExpand> expand, Context context) {
        return new PagedFlux(() -> this.listClaimsMappingPoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listClaimsMappingPoliciesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphClaimsMappingPolicyInner> listClaimsMappingPolicies(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        List<ServicePrincipalsSelect> select = null;
        List<ServicePrincipalsExpand> expand = null;
        return new PagedIterable(this.listClaimsMappingPoliciesAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphClaimsMappingPolicyInner> listClaimsMappingPolicies(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<ServicePrincipalsExpand> expand, Context context) {
        return new PagedIterable(this.listClaimsMappingPoliciesAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefClaimsMappingPoliciesSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefClaimsMappingPolicies(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfClaimsMappingPolicy)res.getValue()).value(), ((CollectionOfLinksOfClaimsMappingPolicy)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefClaimsMappingPoliciesSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefClaimsMappingPolicies(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfClaimsMappingPolicy)res.getValue()).value(), ((CollectionOfLinksOfClaimsMappingPolicy)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefClaimsMappingPoliciesAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby) {
        return new PagedFlux(() -> this.listRefClaimsMappingPoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby), nextLink -> this.listRefClaimsMappingPoliciesNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefClaimsMappingPoliciesAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefClaimsMappingPoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby), nextLink -> this.listRefClaimsMappingPoliciesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<String> listRefClaimsMappingPoliciesAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefClaimsMappingPoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefClaimsMappingPoliciesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefClaimsMappingPolicies(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        return new PagedIterable(this.listRefClaimsMappingPoliciesAsync(servicePrincipalId, top, skip, search, filter, count, orderby));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefClaimsMappingPolicies(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefClaimsMappingPoliciesAsync(servicePrincipalId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefClaimsMappingPoliciesWithResponseAsync(String servicePrincipalId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefClaimsMappingPolicies(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefClaimsMappingPoliciesWithResponseAsync(String servicePrincipalId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefClaimsMappingPolicies(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefClaimsMappingPoliciesAsync(String servicePrincipalId, Map<String, Object> body) {
        return this.createRefClaimsMappingPoliciesWithResponseAsync(servicePrincipalId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> createRefClaimsMappingPolicies(String servicePrincipalId, Map<String, Object> body) {
        return (Map)this.createRefClaimsMappingPoliciesAsync(servicePrincipalId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefClaimsMappingPoliciesWithResponse(String servicePrincipalId, Map<String, Object> body, Context context) {
        return (Response)this.createRefClaimsMappingPoliciesWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listCreatedObjectsSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listCreatedObjects(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject0)res.getValue()).value(), ((CollectionOfDirectoryObject0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listCreatedObjectsSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listCreatedObjects(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject0)res.getValue()).value(), ((CollectionOfDirectoryObject0)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listCreatedObjectsAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listCreatedObjectsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listCreatedObjectsNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listCreatedObjectsAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listCreatedObjectsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listCreatedObjectsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listCreatedObjectsAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listCreatedObjectsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listCreatedObjectsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listCreatedObjects(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        List<ServicePrincipalsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listCreatedObjectsAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listCreatedObjects(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listCreatedObjectsAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefCreatedObjectsSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefCreatedObjects(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject0)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefCreatedObjectsSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefCreatedObjects(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject0)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject0)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefCreatedObjectsAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby) {
        return new PagedFlux(() -> this.listRefCreatedObjectsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby), nextLink -> this.listRefCreatedObjectsNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefCreatedObjectsAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefCreatedObjectsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby), nextLink -> this.listRefCreatedObjectsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<String> listRefCreatedObjectsAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefCreatedObjectsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefCreatedObjectsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefCreatedObjects(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        return new PagedIterable(this.listRefCreatedObjectsAsync(servicePrincipalId, top, skip, search, filter, count, orderby));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefCreatedObjects(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefCreatedObjectsAsync(servicePrincipalId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefCreatedObjectsWithResponseAsync(String servicePrincipalId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefCreatedObjects(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefCreatedObjectsWithResponseAsync(String servicePrincipalId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefCreatedObjects(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefCreatedObjectsAsync(String servicePrincipalId, Map<String, Object> body) {
        return this.createRefCreatedObjectsWithResponseAsync(servicePrincipalId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> createRefCreatedObjects(String servicePrincipalId, Map<String, Object> body) {
        return (Map)this.createRefCreatedObjectsAsync(servicePrincipalId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefCreatedObjectsWithResponse(String servicePrincipalId, Map<String, Object> body, Context context) {
        return (Response)this.createRefCreatedObjectsWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDelegatedPermissionClassificationInner>> listDelegatedPermissionClassificationsSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listDelegatedPermissionClassifications(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDelegatedPermissionClassification)res.getValue()).value(), ((CollectionOfDelegatedPermissionClassification)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDelegatedPermissionClassificationInner>> listDelegatedPermissionClassificationsSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listDelegatedPermissionClassifications(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDelegatedPermissionClassification)res.getValue()).value(), ((CollectionOfDelegatedPermissionClassification)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDelegatedPermissionClassificationInner> listDelegatedPermissionClassificationsAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listDelegatedPermissionClassificationsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listDelegatedPermissionClassificationsNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDelegatedPermissionClassificationInner> listDelegatedPermissionClassificationsAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listDelegatedPermissionClassificationsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listDelegatedPermissionClassificationsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDelegatedPermissionClassificationInner> listDelegatedPermissionClassificationsAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listDelegatedPermissionClassificationsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listDelegatedPermissionClassificationsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDelegatedPermissionClassificationInner> listDelegatedPermissionClassifications(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        List<ServicePrincipalsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listDelegatedPermissionClassificationsAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDelegatedPermissionClassificationInner> listDelegatedPermissionClassifications(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listDelegatedPermissionClassificationsAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDelegatedPermissionClassificationInner>> createDelegatedPermissionClassificationsWithResponseAsync(String servicePrincipalId, MicrosoftGraphDelegatedPermissionClassificationInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createDelegatedPermissionClassifications(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDelegatedPermissionClassificationInner>> createDelegatedPermissionClassificationsWithResponseAsync(String servicePrincipalId, MicrosoftGraphDelegatedPermissionClassificationInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createDelegatedPermissionClassifications(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDelegatedPermissionClassificationInner> createDelegatedPermissionClassificationsAsync(String servicePrincipalId, MicrosoftGraphDelegatedPermissionClassificationInner body) {
        return this.createDelegatedPermissionClassificationsWithResponseAsync(servicePrincipalId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDelegatedPermissionClassificationInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphDelegatedPermissionClassificationInner createDelegatedPermissionClassifications(String servicePrincipalId, MicrosoftGraphDelegatedPermissionClassificationInner body) {
        return (MicrosoftGraphDelegatedPermissionClassificationInner)this.createDelegatedPermissionClassificationsAsync(servicePrincipalId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphDelegatedPermissionClassificationInner> createDelegatedPermissionClassificationsWithResponse(String servicePrincipalId, MicrosoftGraphDelegatedPermissionClassificationInner body, Context context) {
        return (Response)this.createDelegatedPermissionClassificationsWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDelegatedPermissionClassificationInner>> getDelegatedPermissionClassificationsWithResponseAsync(String servicePrincipalId, String delegatedPermissionClassificationId, List<ServicePrincipalsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (delegatedPermissionClassificationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter delegatedPermissionClassificationId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getDelegatedPermissionClassifications(this.client.getEndpoint(), servicePrincipalId, delegatedPermissionClassificationId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDelegatedPermissionClassificationInner>> getDelegatedPermissionClassificationsWithResponseAsync(String servicePrincipalId, String delegatedPermissionClassificationId, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (delegatedPermissionClassificationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter delegatedPermissionClassificationId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getDelegatedPermissionClassifications(this.client.getEndpoint(), servicePrincipalId, delegatedPermissionClassificationId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDelegatedPermissionClassificationInner> getDelegatedPermissionClassificationsAsync(String servicePrincipalId, String delegatedPermissionClassificationId, List<ServicePrincipalsSelect> select, List<String> expand) {
        return this.getDelegatedPermissionClassificationsWithResponseAsync(servicePrincipalId, delegatedPermissionClassificationId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDelegatedPermissionClassificationInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDelegatedPermissionClassificationInner> getDelegatedPermissionClassificationsAsync(String servicePrincipalId, String delegatedPermissionClassificationId) {
        List<ServicePrincipalsSelect> select = null;
        List<String> expand = null;
        return this.getDelegatedPermissionClassificationsWithResponseAsync(servicePrincipalId, delegatedPermissionClassificationId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDelegatedPermissionClassificationInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphDelegatedPermissionClassificationInner getDelegatedPermissionClassifications(String servicePrincipalId, String delegatedPermissionClassificationId) {
        List<ServicePrincipalsSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphDelegatedPermissionClassificationInner)this.getDelegatedPermissionClassificationsAsync(servicePrincipalId, delegatedPermissionClassificationId, select, expand).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphDelegatedPermissionClassificationInner> getDelegatedPermissionClassificationsWithResponse(String servicePrincipalId, String delegatedPermissionClassificationId, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return (Response)this.getDelegatedPermissionClassificationsWithResponseAsync(servicePrincipalId, delegatedPermissionClassificationId, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateDelegatedPermissionClassificationsWithResponseAsync(String servicePrincipalId, String delegatedPermissionClassificationId, MicrosoftGraphDelegatedPermissionClassificationInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (delegatedPermissionClassificationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter delegatedPermissionClassificationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateDelegatedPermissionClassifications(this.client.getEndpoint(), servicePrincipalId, delegatedPermissionClassificationId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateDelegatedPermissionClassificationsWithResponseAsync(String servicePrincipalId, String delegatedPermissionClassificationId, MicrosoftGraphDelegatedPermissionClassificationInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (delegatedPermissionClassificationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter delegatedPermissionClassificationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateDelegatedPermissionClassifications(this.client.getEndpoint(), servicePrincipalId, delegatedPermissionClassificationId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateDelegatedPermissionClassificationsAsync(String servicePrincipalId, String delegatedPermissionClassificationId, MicrosoftGraphDelegatedPermissionClassificationInner body) {
        return this.updateDelegatedPermissionClassificationsWithResponseAsync(servicePrincipalId, delegatedPermissionClassificationId, body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateDelegatedPermissionClassifications(String servicePrincipalId, String delegatedPermissionClassificationId, MicrosoftGraphDelegatedPermissionClassificationInner body) {
        this.updateDelegatedPermissionClassificationsAsync(servicePrincipalId, delegatedPermissionClassificationId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateDelegatedPermissionClassificationsWithResponse(String servicePrincipalId, String delegatedPermissionClassificationId, MicrosoftGraphDelegatedPermissionClassificationInner body, Context context) {
        return (Response)this.updateDelegatedPermissionClassificationsWithResponseAsync(servicePrincipalId, delegatedPermissionClassificationId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDelegatedPermissionClassificationsWithResponseAsync(String servicePrincipalId, String delegatedPermissionClassificationId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (delegatedPermissionClassificationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter delegatedPermissionClassificationId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteDelegatedPermissionClassifications(this.client.getEndpoint(), servicePrincipalId, delegatedPermissionClassificationId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteDelegatedPermissionClassificationsWithResponseAsync(String servicePrincipalId, String delegatedPermissionClassificationId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (delegatedPermissionClassificationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter delegatedPermissionClassificationId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteDelegatedPermissionClassifications(this.client.getEndpoint(), servicePrincipalId, delegatedPermissionClassificationId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDelegatedPermissionClassificationsAsync(String servicePrincipalId, String delegatedPermissionClassificationId, String ifMatch) {
        return this.deleteDelegatedPermissionClassificationsWithResponseAsync(servicePrincipalId, delegatedPermissionClassificationId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDelegatedPermissionClassificationsAsync(String servicePrincipalId, String delegatedPermissionClassificationId) {
        String ifMatch = null;
        return this.deleteDelegatedPermissionClassificationsWithResponseAsync(servicePrincipalId, delegatedPermissionClassificationId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDelegatedPermissionClassifications(String servicePrincipalId, String delegatedPermissionClassificationId) {
        String ifMatch = null;
        this.deleteDelegatedPermissionClassificationsAsync(servicePrincipalId, delegatedPermissionClassificationId, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDelegatedPermissionClassificationsWithResponse(String servicePrincipalId, String delegatedPermissionClassificationId, String ifMatch, Context context) {
        return (Response)this.deleteDelegatedPermissionClassificationsWithResponseAsync(servicePrincipalId, delegatedPermissionClassificationId, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphEndpointInner>> listEndpointsSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listEndpoints(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfEndpoint)res.getValue()).value(), ((CollectionOfEndpoint)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphEndpointInner>> listEndpointsSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listEndpoints(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfEndpoint)res.getValue()).value(), ((CollectionOfEndpoint)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphEndpointInner> listEndpointsAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listEndpointsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listEndpointsNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphEndpointInner> listEndpointsAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listEndpointsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listEndpointsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphEndpointInner> listEndpointsAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listEndpointsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listEndpointsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphEndpointInner> listEndpoints(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        List<ServicePrincipalsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listEndpointsAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphEndpointInner> listEndpoints(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listEndpointsAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphEndpointInner>> createEndpointsWithResponseAsync(String servicePrincipalId, MicrosoftGraphEndpointInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createEndpoints(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphEndpointInner>> createEndpointsWithResponseAsync(String servicePrincipalId, MicrosoftGraphEndpointInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createEndpoints(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphEndpointInner> createEndpointsAsync(String servicePrincipalId, MicrosoftGraphEndpointInner body) {
        return this.createEndpointsWithResponseAsync(servicePrincipalId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphEndpointInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphEndpointInner createEndpoints(String servicePrincipalId, MicrosoftGraphEndpointInner body) {
        return (MicrosoftGraphEndpointInner)this.createEndpointsAsync(servicePrincipalId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphEndpointInner> createEndpointsWithResponse(String servicePrincipalId, MicrosoftGraphEndpointInner body, Context context) {
        return (Response)this.createEndpointsWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphEndpointInner>> getEndpointsWithResponseAsync(String servicePrincipalId, String endpointId, List<ServicePrincipalsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (endpointId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getEndpoints(this.client.getEndpoint(), servicePrincipalId, endpointId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphEndpointInner>> getEndpointsWithResponseAsync(String servicePrincipalId, String endpointId, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (endpointId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getEndpoints(this.client.getEndpoint(), servicePrincipalId, endpointId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphEndpointInner> getEndpointsAsync(String servicePrincipalId, String endpointId, List<ServicePrincipalsSelect> select, List<String> expand) {
        return this.getEndpointsWithResponseAsync(servicePrincipalId, endpointId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphEndpointInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphEndpointInner> getEndpointsAsync(String servicePrincipalId, String endpointId) {
        List<ServicePrincipalsSelect> select = null;
        List<String> expand = null;
        return this.getEndpointsWithResponseAsync(servicePrincipalId, endpointId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphEndpointInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphEndpointInner getEndpoints(String servicePrincipalId, String endpointId) {
        List<ServicePrincipalsSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphEndpointInner)this.getEndpointsAsync(servicePrincipalId, endpointId, select, expand).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphEndpointInner> getEndpointsWithResponse(String servicePrincipalId, String endpointId, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return (Response)this.getEndpointsWithResponseAsync(servicePrincipalId, endpointId, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateEndpointsWithResponseAsync(String servicePrincipalId, String endpointId, MicrosoftGraphEndpointInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (endpointId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateEndpoints(this.client.getEndpoint(), servicePrincipalId, endpointId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateEndpointsWithResponseAsync(String servicePrincipalId, String endpointId, MicrosoftGraphEndpointInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (endpointId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateEndpoints(this.client.getEndpoint(), servicePrincipalId, endpointId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateEndpointsAsync(String servicePrincipalId, String endpointId, MicrosoftGraphEndpointInner body) {
        return this.updateEndpointsWithResponseAsync(servicePrincipalId, endpointId, body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateEndpoints(String servicePrincipalId, String endpointId, MicrosoftGraphEndpointInner body) {
        this.updateEndpointsAsync(servicePrincipalId, endpointId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateEndpointsWithResponse(String servicePrincipalId, String endpointId, MicrosoftGraphEndpointInner body, Context context) {
        return (Response)this.updateEndpointsWithResponseAsync(servicePrincipalId, endpointId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteEndpointsWithResponseAsync(String servicePrincipalId, String endpointId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (endpointId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteEndpoints(this.client.getEndpoint(), servicePrincipalId, endpointId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteEndpointsWithResponseAsync(String servicePrincipalId, String endpointId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (endpointId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteEndpoints(this.client.getEndpoint(), servicePrincipalId, endpointId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteEndpointsAsync(String servicePrincipalId, String endpointId, String ifMatch) {
        return this.deleteEndpointsWithResponseAsync(servicePrincipalId, endpointId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteEndpointsAsync(String servicePrincipalId, String endpointId) {
        String ifMatch = null;
        return this.deleteEndpointsWithResponseAsync(servicePrincipalId, endpointId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteEndpoints(String servicePrincipalId, String endpointId) {
        String ifMatch = null;
        this.deleteEndpointsAsync(servicePrincipalId, endpointId, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteEndpointsWithResponse(String servicePrincipalId, String endpointId, String ifMatch, Context context) {
        return (Response)this.deleteEndpointsWithResponseAsync(servicePrincipalId, endpointId, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphHomeRealmDiscoveryPolicyInner>> listHomeRealmDiscoveryPoliciesSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<ServicePrincipalsExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listHomeRealmDiscoveryPolicies(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfHomeRealmDiscoveryPolicy0)res.getValue()).value(), ((CollectionOfHomeRealmDiscoveryPolicy0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphHomeRealmDiscoveryPolicyInner>> listHomeRealmDiscoveryPoliciesSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<ServicePrincipalsExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listHomeRealmDiscoveryPolicies(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfHomeRealmDiscoveryPolicy0)res.getValue()).value(), ((CollectionOfHomeRealmDiscoveryPolicy0)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphHomeRealmDiscoveryPolicyInner> listHomeRealmDiscoveryPoliciesAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<ServicePrincipalsExpand> expand) {
        return new PagedFlux(() -> this.listHomeRealmDiscoveryPoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listHomeRealmDiscoveryPoliciesNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphHomeRealmDiscoveryPolicyInner> listHomeRealmDiscoveryPoliciesAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listHomeRealmDiscoveryPoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listHomeRealmDiscoveryPoliciesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphHomeRealmDiscoveryPolicyInner> listHomeRealmDiscoveryPoliciesAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<ServicePrincipalsExpand> expand, Context context) {
        return new PagedFlux(() -> this.listHomeRealmDiscoveryPoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listHomeRealmDiscoveryPoliciesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphHomeRealmDiscoveryPolicyInner> listHomeRealmDiscoveryPolicies(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        List<ServicePrincipalsSelect> select = null;
        List<ServicePrincipalsExpand> expand = null;
        return new PagedIterable(this.listHomeRealmDiscoveryPoliciesAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphHomeRealmDiscoveryPolicyInner> listHomeRealmDiscoveryPolicies(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<ServicePrincipalsExpand> expand, Context context) {
        return new PagedIterable(this.listHomeRealmDiscoveryPoliciesAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefHomeRealmDiscoveryPoliciesSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefHomeRealmDiscoveryPolicies(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfHomeRealmDiscoveryPolicy0)res.getValue()).value(), ((CollectionOfLinksOfHomeRealmDiscoveryPolicy0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefHomeRealmDiscoveryPoliciesSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefHomeRealmDiscoveryPolicies(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfHomeRealmDiscoveryPolicy0)res.getValue()).value(), ((CollectionOfLinksOfHomeRealmDiscoveryPolicy0)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefHomeRealmDiscoveryPoliciesAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby) {
        return new PagedFlux(() -> this.listRefHomeRealmDiscoveryPoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby), nextLink -> this.listRefHomeRealmDiscoveryPoliciesNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefHomeRealmDiscoveryPoliciesAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefHomeRealmDiscoveryPoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby), nextLink -> this.listRefHomeRealmDiscoveryPoliciesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<String> listRefHomeRealmDiscoveryPoliciesAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefHomeRealmDiscoveryPoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefHomeRealmDiscoveryPoliciesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefHomeRealmDiscoveryPolicies(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        return new PagedIterable(this.listRefHomeRealmDiscoveryPoliciesAsync(servicePrincipalId, top, skip, search, filter, count, orderby));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefHomeRealmDiscoveryPolicies(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefHomeRealmDiscoveryPoliciesAsync(servicePrincipalId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefHomeRealmDiscoveryPoliciesWithResponseAsync(String servicePrincipalId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefHomeRealmDiscoveryPolicies(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefHomeRealmDiscoveryPoliciesWithResponseAsync(String servicePrincipalId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefHomeRealmDiscoveryPolicies(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefHomeRealmDiscoveryPoliciesAsync(String servicePrincipalId, Map<String, Object> body) {
        return this.createRefHomeRealmDiscoveryPoliciesWithResponseAsync(servicePrincipalId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> createRefHomeRealmDiscoveryPolicies(String servicePrincipalId, Map<String, Object> body) {
        return (Map)this.createRefHomeRealmDiscoveryPoliciesAsync(servicePrincipalId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefHomeRealmDiscoveryPoliciesWithResponse(String servicePrincipalId, Map<String, Object> body, Context context) {
        return (Response)this.createRefHomeRealmDiscoveryPoliciesWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listMemberOf(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject1)res.getValue()).value(), ((CollectionOfDirectoryObject1)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listMemberOf(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject1)res.getValue()).value(), ((CollectionOfDirectoryObject1)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMemberOfAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listMemberOfSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMemberOfNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMemberOfAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listMemberOfSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMemberOfNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listMemberOfAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listMemberOfSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMemberOfNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMemberOf(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        List<ServicePrincipalsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listMemberOfAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMemberOf(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listMemberOfAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMemberOfSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefMemberOf(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject1)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject1)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMemberOfSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefMemberOf(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject1)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject1)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefMemberOfAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby) {
        return new PagedFlux(() -> this.listRefMemberOfSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby), nextLink -> this.listRefMemberOfNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefMemberOfAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefMemberOfSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby), nextLink -> this.listRefMemberOfNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<String> listRefMemberOfAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefMemberOfSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefMemberOfNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefMemberOf(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        return new PagedIterable(this.listRefMemberOfAsync(servicePrincipalId, top, skip, search, filter, count, orderby));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefMemberOf(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefMemberOfAsync(servicePrincipalId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefMemberOfWithResponseAsync(String servicePrincipalId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefMemberOf(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefMemberOfWithResponseAsync(String servicePrincipalId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefMemberOf(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefMemberOfAsync(String servicePrincipalId, Map<String, Object> body) {
        return this.createRefMemberOfWithResponseAsync(servicePrincipalId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> createRefMemberOf(String servicePrincipalId, Map<String, Object> body) {
        return (Map)this.createRefMemberOfAsync(servicePrincipalId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefMemberOfWithResponse(String servicePrincipalId, Map<String, Object> body, Context context) {
        return (Response)this.createRefMemberOfWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphKeyCredentialInner>> addKeyWithResponseAsync(String servicePrincipalId, ServicePrincipalsAddKeyRequestBodyInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.addKey(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphKeyCredentialInner>> addKeyWithResponseAsync(String servicePrincipalId, ServicePrincipalsAddKeyRequestBodyInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.addKey(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphKeyCredentialInner> addKeyAsync(String servicePrincipalId, ServicePrincipalsAddKeyRequestBodyInner body) {
        return this.addKeyWithResponseAsync(servicePrincipalId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphKeyCredentialInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphKeyCredentialInner addKey(String servicePrincipalId, ServicePrincipalsAddKeyRequestBodyInner body) {
        return (MicrosoftGraphKeyCredentialInner)this.addKeyAsync(servicePrincipalId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphKeyCredentialInner> addKeyWithResponse(String servicePrincipalId, ServicePrincipalsAddKeyRequestBodyInner body, Context context) {
        return (Response)this.addKeyWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphPasswordCredentialInner>> addPasswordWithResponseAsync(String servicePrincipalId, ServicePrincipalsAddPasswordRequestBodyInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.addPassword(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphPasswordCredentialInner>> addPasswordWithResponseAsync(String servicePrincipalId, ServicePrincipalsAddPasswordRequestBodyInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.addPassword(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphPasswordCredentialInner> addPasswordAsync(String servicePrincipalId, ServicePrincipalsAddPasswordRequestBodyInner body) {
        return this.addPasswordWithResponseAsync(servicePrincipalId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphPasswordCredentialInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphPasswordCredentialInner addPassword(String servicePrincipalId, ServicePrincipalsAddPasswordRequestBodyInner body) {
        return (MicrosoftGraphPasswordCredentialInner)this.addPasswordAsync(servicePrincipalId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphPasswordCredentialInner> addPasswordWithResponse(String servicePrincipalId, ServicePrincipalsAddPasswordRequestBodyInner body, Context context) {
        return (Response)this.addPasswordWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(String servicePrincipalId, ServicePrincipalsCheckMemberGroupsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkMemberGroups(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(String servicePrincipalId, ServicePrincipalsCheckMemberGroupsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkMemberGroups(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<String>> checkMemberGroupsAsync(String servicePrincipalId, ServicePrincipalsCheckMemberGroupsRequestBody body) {
        return this.checkMemberGroupsWithResponseAsync(servicePrincipalId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<String> checkMemberGroups(String servicePrincipalId, ServicePrincipalsCheckMemberGroupsRequestBody body) {
        return (List)this.checkMemberGroupsAsync(servicePrincipalId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<String>> checkMemberGroupsWithResponse(String servicePrincipalId, ServicePrincipalsCheckMemberGroupsRequestBody body, Context context) {
        return (Response)this.checkMemberGroupsWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(String servicePrincipalId, ServicePrincipalsCheckMemberObjectsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkMemberObjects(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(String servicePrincipalId, ServicePrincipalsCheckMemberObjectsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkMemberObjects(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<String>> checkMemberObjectsAsync(String servicePrincipalId, ServicePrincipalsCheckMemberObjectsRequestBody body) {
        return this.checkMemberObjectsWithResponseAsync(servicePrincipalId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<String> checkMemberObjects(String servicePrincipalId, ServicePrincipalsCheckMemberObjectsRequestBody body) {
        return (List)this.checkMemberObjectsAsync(servicePrincipalId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<String>> checkMemberObjectsWithResponse(String servicePrincipalId, ServicePrincipalsCheckMemberObjectsRequestBody body, Context context) {
        return (Response)this.checkMemberObjectsWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(String servicePrincipalId, ServicePrincipalsGetMemberGroupsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMemberGroups(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(String servicePrincipalId, ServicePrincipalsGetMemberGroupsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getMemberGroups(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<String>> getMemberGroupsAsync(String servicePrincipalId, ServicePrincipalsGetMemberGroupsRequestBody body) {
        return this.getMemberGroupsWithResponseAsync(servicePrincipalId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<String> getMemberGroups(String servicePrincipalId, ServicePrincipalsGetMemberGroupsRequestBody body) {
        return (List)this.getMemberGroupsAsync(servicePrincipalId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<String>> getMemberGroupsWithResponse(String servicePrincipalId, ServicePrincipalsGetMemberGroupsRequestBody body, Context context) {
        return (Response)this.getMemberGroupsWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(String servicePrincipalId, ServicePrincipalsGetMemberObjectsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMemberObjects(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(String servicePrincipalId, ServicePrincipalsGetMemberObjectsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getMemberObjects(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<String>> getMemberObjectsAsync(String servicePrincipalId, ServicePrincipalsGetMemberObjectsRequestBody body) {
        return this.getMemberObjectsWithResponseAsync(servicePrincipalId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<String> getMemberObjects(String servicePrincipalId, ServicePrincipalsGetMemberObjectsRequestBody body) {
        return (List)this.getMemberObjectsAsync(servicePrincipalId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<String>> getMemberObjectsWithResponse(String servicePrincipalId, ServicePrincipalsGetMemberObjectsRequestBody body, Context context) {
        return (Response)this.getMemberObjectsWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeKeyWithResponseAsync(String servicePrincipalId, ServicePrincipalsRemoveKeyRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.removeKey(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> removeKeyWithResponseAsync(String servicePrincipalId, ServicePrincipalsRemoveKeyRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.removeKey(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removeKeyAsync(String servicePrincipalId, ServicePrincipalsRemoveKeyRequestBody body) {
        return this.removeKeyWithResponseAsync(servicePrincipalId, body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void removeKey(String servicePrincipalId, ServicePrincipalsRemoveKeyRequestBody body) {
        this.removeKeyAsync(servicePrincipalId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeKeyWithResponse(String servicePrincipalId, ServicePrincipalsRemoveKeyRequestBody body, Context context) {
        return (Response)this.removeKeyWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removePasswordWithResponseAsync(String servicePrincipalId, ServicePrincipalsRemovePasswordRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.removePassword(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> removePasswordWithResponseAsync(String servicePrincipalId, ServicePrincipalsRemovePasswordRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.removePassword(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removePasswordAsync(String servicePrincipalId, ServicePrincipalsRemovePasswordRequestBody body) {
        return this.removePasswordWithResponseAsync(servicePrincipalId, body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void removePassword(String servicePrincipalId, ServicePrincipalsRemovePasswordRequestBody body) {
        this.removePasswordAsync(servicePrincipalId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removePasswordWithResponse(String servicePrincipalId, ServicePrincipalsRemovePasswordRequestBody body, Context context) {
        return (Response)this.removePasswordWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(String servicePrincipalId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restore(this.client.getEndpoint(), servicePrincipalId, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(String servicePrincipalId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.restore(this.client.getEndpoint(), servicePrincipalId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> restoreAsync(String servicePrincipalId) {
        return this.restoreWithResponseAsync(servicePrincipalId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphDirectoryObjectInner restore(String servicePrincipalId) {
        return (MicrosoftGraphDirectoryObjectInner)this.restoreAsync(servicePrincipalId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryObjectInner> restoreWithResponse(String servicePrincipalId, Context context) {
        return (Response)this.restoreWithResponseAsync(servicePrincipalId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOAuth2PermissionGrantInner>> listOauth2PermissionGrantsSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listOauth2PermissionGrants(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfOAuth2PermissionGrant)res.getValue()).value(), ((CollectionOfOAuth2PermissionGrant)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOAuth2PermissionGrantInner>> listOauth2PermissionGrantsSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listOauth2PermissionGrants(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfOAuth2PermissionGrant)res.getValue()).value(), ((CollectionOfOAuth2PermissionGrant)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphOAuth2PermissionGrantInner> listOauth2PermissionGrantsAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listOauth2PermissionGrantsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listOauth2PermissionGrantsNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphOAuth2PermissionGrantInner> listOauth2PermissionGrantsAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listOauth2PermissionGrantsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listOauth2PermissionGrantsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphOAuth2PermissionGrantInner> listOauth2PermissionGrantsAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listOauth2PermissionGrantsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listOauth2PermissionGrantsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphOAuth2PermissionGrantInner> listOauth2PermissionGrants(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        List<ServicePrincipalsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listOauth2PermissionGrantsAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphOAuth2PermissionGrantInner> listOauth2PermissionGrants(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listOauth2PermissionGrantsAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefOauth2PermissionGrantsSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefOauth2PermissionGrants(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfOAuth2PermissionGrant)res.getValue()).value(), ((CollectionOfLinksOfOAuth2PermissionGrant)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefOauth2PermissionGrantsSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefOauth2PermissionGrants(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfOAuth2PermissionGrant)res.getValue()).value(), ((CollectionOfLinksOfOAuth2PermissionGrant)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefOauth2PermissionGrantsAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby) {
        return new PagedFlux(() -> this.listRefOauth2PermissionGrantsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby), nextLink -> this.listRefOauth2PermissionGrantsNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefOauth2PermissionGrantsAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefOauth2PermissionGrantsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby), nextLink -> this.listRefOauth2PermissionGrantsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<String> listRefOauth2PermissionGrantsAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefOauth2PermissionGrantsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefOauth2PermissionGrantsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefOauth2PermissionGrants(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        return new PagedIterable(this.listRefOauth2PermissionGrantsAsync(servicePrincipalId, top, skip, search, filter, count, orderby));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefOauth2PermissionGrants(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefOauth2PermissionGrantsAsync(servicePrincipalId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefOauth2PermissionGrantsWithResponseAsync(String servicePrincipalId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefOauth2PermissionGrants(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefOauth2PermissionGrantsWithResponseAsync(String servicePrincipalId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefOauth2PermissionGrants(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefOauth2PermissionGrantsAsync(String servicePrincipalId, Map<String, Object> body) {
        return this.createRefOauth2PermissionGrantsWithResponseAsync(servicePrincipalId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> createRefOauth2PermissionGrants(String servicePrincipalId, Map<String, Object> body) {
        return (Map)this.createRefOauth2PermissionGrantsAsync(servicePrincipalId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefOauth2PermissionGrantsWithResponse(String servicePrincipalId, Map<String, Object> body, Context context) {
        return (Response)this.createRefOauth2PermissionGrantsWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnedObjectsSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listOwnedObjects(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject2)res.getValue()).value(), ((CollectionOfDirectoryObject2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnedObjectsSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listOwnedObjects(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject2)res.getValue()).value(), ((CollectionOfDirectoryObject2)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listOwnedObjectsAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listOwnedObjectsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listOwnedObjectsNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listOwnedObjectsAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listOwnedObjectsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listOwnedObjectsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listOwnedObjectsAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listOwnedObjectsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listOwnedObjectsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listOwnedObjects(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        List<ServicePrincipalsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listOwnedObjectsAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listOwnedObjects(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listOwnedObjectsAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefOwnedObjectsSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefOwnedObjects(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefOwnedObjectsSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefOwnedObjects(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject2)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefOwnedObjectsAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby) {
        return new PagedFlux(() -> this.listRefOwnedObjectsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby), nextLink -> this.listRefOwnedObjectsNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefOwnedObjectsAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefOwnedObjectsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby), nextLink -> this.listRefOwnedObjectsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<String> listRefOwnedObjectsAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefOwnedObjectsSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefOwnedObjectsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefOwnedObjects(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        return new PagedIterable(this.listRefOwnedObjectsAsync(servicePrincipalId, top, skip, search, filter, count, orderby));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefOwnedObjects(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefOwnedObjectsAsync(servicePrincipalId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefOwnedObjectsWithResponseAsync(String servicePrincipalId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefOwnedObjects(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefOwnedObjectsWithResponseAsync(String servicePrincipalId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefOwnedObjects(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefOwnedObjectsAsync(String servicePrincipalId, Map<String, Object> body) {
        return this.createRefOwnedObjectsWithResponseAsync(servicePrincipalId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> createRefOwnedObjects(String servicePrincipalId, Map<String, Object> body) {
        return (Map)this.createRefOwnedObjectsAsync(servicePrincipalId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefOwnedObjectsWithResponse(String servicePrincipalId, Map<String, Object> body, Context context) {
        return (Response)this.createRefOwnedObjectsWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnersSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listOwners(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject3)res.getValue()).value(), ((CollectionOfDirectoryObject3)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnersSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listOwners(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject3)res.getValue()).value(), ((CollectionOfDirectoryObject3)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listOwnersAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listOwnersSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listOwnersNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listOwnersAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listOwnersSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listOwnersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listOwnersAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listOwnersSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listOwnersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listOwners(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        List<ServicePrincipalsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listOwnersAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listOwners(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listOwnersAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefOwnersSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefOwners(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject3)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject3)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefOwnersSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefOwners(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject3)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject3)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefOwnersAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby) {
        return new PagedFlux(() -> this.listRefOwnersSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby), nextLink -> this.listRefOwnersNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefOwnersAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefOwnersSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby), nextLink -> this.listRefOwnersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<String> listRefOwnersAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefOwnersSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefOwnersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefOwners(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        return new PagedIterable(this.listRefOwnersAsync(servicePrincipalId, top, skip, search, filter, count, orderby));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefOwners(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefOwnersAsync(servicePrincipalId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefOwnersWithResponseAsync(String servicePrincipalId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefOwners(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefOwnersWithResponseAsync(String servicePrincipalId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefOwners(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefOwnersAsync(String servicePrincipalId, Map<String, Object> body) {
        return this.createRefOwnersWithResponseAsync(servicePrincipalId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> createRefOwners(String servicePrincipalId, Map<String, Object> body) {
        return (Map)this.createRefOwnersAsync(servicePrincipalId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefOwnersWithResponse(String servicePrincipalId, Map<String, Object> body, Context context) {
        return (Response)this.createRefOwnersWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphTokenIssuancePolicyInner>> listTokenIssuancePoliciesSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<ServicePrincipalsExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listTokenIssuancePolicies(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfTokenIssuancePolicy0)res.getValue()).value(), ((CollectionOfTokenIssuancePolicy0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphTokenIssuancePolicyInner>> listTokenIssuancePoliciesSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<ServicePrincipalsExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listTokenIssuancePolicies(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfTokenIssuancePolicy0)res.getValue()).value(), ((CollectionOfTokenIssuancePolicy0)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphTokenIssuancePolicyInner> listTokenIssuancePoliciesAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<ServicePrincipalsExpand> expand) {
        return new PagedFlux(() -> this.listTokenIssuancePoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listTokenIssuancePoliciesNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphTokenIssuancePolicyInner> listTokenIssuancePoliciesAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listTokenIssuancePoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listTokenIssuancePoliciesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphTokenIssuancePolicyInner> listTokenIssuancePoliciesAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<ServicePrincipalsExpand> expand, Context context) {
        return new PagedFlux(() -> this.listTokenIssuancePoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listTokenIssuancePoliciesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphTokenIssuancePolicyInner> listTokenIssuancePolicies(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        List<ServicePrincipalsSelect> select = null;
        List<ServicePrincipalsExpand> expand = null;
        return new PagedIterable(this.listTokenIssuancePoliciesAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphTokenIssuancePolicyInner> listTokenIssuancePolicies(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<ServicePrincipalsExpand> expand, Context context) {
        return new PagedIterable(this.listTokenIssuancePoliciesAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTokenIssuancePoliciesSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefTokenIssuancePolicies(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfTokenIssuancePolicy0)res.getValue()).value(), ((CollectionOfLinksOfTokenIssuancePolicy0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTokenIssuancePoliciesSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefTokenIssuancePolicies(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfTokenIssuancePolicy0)res.getValue()).value(), ((CollectionOfLinksOfTokenIssuancePolicy0)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefTokenIssuancePoliciesAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby) {
        return new PagedFlux(() -> this.listRefTokenIssuancePoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby), nextLink -> this.listRefTokenIssuancePoliciesNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefTokenIssuancePoliciesAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefTokenIssuancePoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby), nextLink -> this.listRefTokenIssuancePoliciesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<String> listRefTokenIssuancePoliciesAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefTokenIssuancePoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefTokenIssuancePoliciesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefTokenIssuancePolicies(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        return new PagedIterable(this.listRefTokenIssuancePoliciesAsync(servicePrincipalId, top, skip, search, filter, count, orderby));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefTokenIssuancePolicies(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefTokenIssuancePoliciesAsync(servicePrincipalId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefTokenIssuancePoliciesWithResponseAsync(String servicePrincipalId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefTokenIssuancePolicies(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefTokenIssuancePoliciesWithResponseAsync(String servicePrincipalId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefTokenIssuancePolicies(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefTokenIssuancePoliciesAsync(String servicePrincipalId, Map<String, Object> body) {
        return this.createRefTokenIssuancePoliciesWithResponseAsync(servicePrincipalId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> createRefTokenIssuancePolicies(String servicePrincipalId, Map<String, Object> body) {
        return (Map)this.createRefTokenIssuancePoliciesAsync(servicePrincipalId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefTokenIssuancePoliciesWithResponse(String servicePrincipalId, Map<String, Object> body, Context context) {
        return (Response)this.createRefTokenIssuancePoliciesWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphTokenLifetimePolicyInner>> listTokenLifetimePoliciesSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<ServicePrincipalsExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listTokenLifetimePolicies(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfTokenLifetimePolicy0)res.getValue()).value(), ((CollectionOfTokenLifetimePolicy0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphTokenLifetimePolicyInner>> listTokenLifetimePoliciesSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<ServicePrincipalsExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listTokenLifetimePolicies(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfTokenLifetimePolicy0)res.getValue()).value(), ((CollectionOfTokenLifetimePolicy0)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphTokenLifetimePolicyInner> listTokenLifetimePoliciesAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<ServicePrincipalsExpand> expand) {
        return new PagedFlux(() -> this.listTokenLifetimePoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listTokenLifetimePoliciesNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphTokenLifetimePolicyInner> listTokenLifetimePoliciesAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listTokenLifetimePoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listTokenLifetimePoliciesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphTokenLifetimePolicyInner> listTokenLifetimePoliciesAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<ServicePrincipalsExpand> expand, Context context) {
        return new PagedFlux(() -> this.listTokenLifetimePoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listTokenLifetimePoliciesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphTokenLifetimePolicyInner> listTokenLifetimePolicies(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        List<ServicePrincipalsSelect> select = null;
        List<ServicePrincipalsExpand> expand = null;
        return new PagedIterable(this.listTokenLifetimePoliciesAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphTokenLifetimePolicyInner> listTokenLifetimePolicies(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<ServicePrincipalsExpand> expand, Context context) {
        return new PagedIterable(this.listTokenLifetimePoliciesAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTokenLifetimePoliciesSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefTokenLifetimePolicies(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfTokenLifetimePolicy0)res.getValue()).value(), ((CollectionOfLinksOfTokenLifetimePolicy0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTokenLifetimePoliciesSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefTokenLifetimePolicies(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfTokenLifetimePolicy0)res.getValue()).value(), ((CollectionOfLinksOfTokenLifetimePolicy0)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefTokenLifetimePoliciesAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby) {
        return new PagedFlux(() -> this.listRefTokenLifetimePoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby), nextLink -> this.listRefTokenLifetimePoliciesNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefTokenLifetimePoliciesAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefTokenLifetimePoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby), nextLink -> this.listRefTokenLifetimePoliciesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<String> listRefTokenLifetimePoliciesAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefTokenLifetimePoliciesSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefTokenLifetimePoliciesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefTokenLifetimePolicies(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        return new PagedIterable(this.listRefTokenLifetimePoliciesAsync(servicePrincipalId, top, skip, search, filter, count, orderby));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefTokenLifetimePolicies(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefTokenLifetimePoliciesAsync(servicePrincipalId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefTokenLifetimePoliciesWithResponseAsync(String servicePrincipalId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefTokenLifetimePolicies(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefTokenLifetimePoliciesWithResponseAsync(String servicePrincipalId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefTokenLifetimePolicies(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefTokenLifetimePoliciesAsync(String servicePrincipalId, Map<String, Object> body) {
        return this.createRefTokenLifetimePoliciesWithResponseAsync(servicePrincipalId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> createRefTokenLifetimePolicies(String servicePrincipalId, Map<String, Object> body) {
        return (Map)this.createRefTokenLifetimePoliciesAsync(servicePrincipalId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefTokenLifetimePoliciesWithResponse(String servicePrincipalId, Map<String, Object> body, Context context) {
        return (Response)this.createRefTokenLifetimePoliciesWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listTransitiveMemberOf(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject4)res.getValue()).value(), ((CollectionOfDirectoryObject4)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listTransitiveMemberOf(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject4)res.getValue()).value(), ((CollectionOfDirectoryObject4)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOfAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listTransitiveMemberOfSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listTransitiveMemberOfNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOfAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listTransitiveMemberOfSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listTransitiveMemberOfNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOfAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listTransitiveMemberOfSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listTransitiveMemberOfNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOf(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        List<ServicePrincipalsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listTransitiveMemberOfAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOf(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, List<ServicePrincipalsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listTransitiveMemberOfAsync(servicePrincipalId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMemberOfSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefTransitiveMemberOf(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject4)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject4)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMemberOfSinglePageAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefTransitiveMemberOf(this.client.getEndpoint(), servicePrincipalId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject4)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject4)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefTransitiveMemberOfAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby) {
        return new PagedFlux(() -> this.listRefTransitiveMemberOfSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby), nextLink -> this.listRefTransitiveMemberOfNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefTransitiveMemberOfAsync(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefTransitiveMemberOfSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby), nextLink -> this.listRefTransitiveMemberOfNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<String> listRefTransitiveMemberOfAsync(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefTransitiveMemberOfSinglePageAsync(servicePrincipalId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefTransitiveMemberOfNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefTransitiveMemberOf(String servicePrincipalId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsOrderby> orderby = null;
        return new PagedIterable(this.listRefTransitiveMemberOfAsync(servicePrincipalId, top, skip, search, filter, count, orderby));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefTransitiveMemberOf(String servicePrincipalId, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefTransitiveMemberOfAsync(servicePrincipalId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefTransitiveMemberOfWithResponseAsync(String servicePrincipalId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefTransitiveMemberOf(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefTransitiveMemberOfWithResponseAsync(String servicePrincipalId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefTransitiveMemberOf(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefTransitiveMemberOfAsync(String servicePrincipalId, Map<String, Object> body) {
        return this.createRefTransitiveMemberOfWithResponseAsync(servicePrincipalId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> createRefTransitiveMemberOf(String servicePrincipalId, Map<String, Object> body) {
        return (Map)this.createRefTransitiveMemberOfAsync(servicePrincipalId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefTransitiveMemberOfWithResponse(String servicePrincipalId, Map<String, Object> body, Context context) {
        return (Response)this.createRefTransitiveMemberOfWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<MicrosoftGraphServicePrincipalInner>>> deltaWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delta(this.client.getEndpoint(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<MicrosoftGraphServicePrincipalInner>>> deltaWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delta(this.client.getEndpoint(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<MicrosoftGraphServicePrincipalInner>> deltaAsync() {
        return this.deltaWithResponseAsync().flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<MicrosoftGraphServicePrincipalInner> delta() {
        return (List)this.deltaAsync().block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<MicrosoftGraphServicePrincipalInner>> deltaWithResponse(Context context) {
        return (Response)this.deltaWithResponseAsync(context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionPropertiesWithResponseAsync(ServicePrincipalsGetAvailableExtensionPropertiesRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAvailableExtensionProperties(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionPropertiesWithResponseAsync(ServicePrincipalsGetAvailableExtensionPropertiesRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAvailableExtensionProperties(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<MicrosoftGraphExtensionPropertyInner>> getAvailableExtensionPropertiesAsync(ServicePrincipalsGetAvailableExtensionPropertiesRequestBody body) {
        return this.getAvailableExtensionPropertiesWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<MicrosoftGraphExtensionPropertyInner> getAvailableExtensionProperties(ServicePrincipalsGetAvailableExtensionPropertiesRequestBody body) {
        return (List)this.getAvailableExtensionPropertiesAsync(body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<MicrosoftGraphExtensionPropertyInner>> getAvailableExtensionPropertiesWithResponse(ServicePrincipalsGetAvailableExtensionPropertiesRequestBody body, Context context) {
        return (Response)this.getAvailableExtensionPropertiesWithResponseAsync(body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIdsWithResponseAsync(ServicePrincipalsGetByIdsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByIds(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIdsWithResponseAsync(ServicePrincipalsGetByIdsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByIds(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<MicrosoftGraphDirectoryObjectInner>> getByIdsAsync(ServicePrincipalsGetByIdsRequestBody body) {
        return this.getByIdsWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<MicrosoftGraphDirectoryObjectInner> getByIds(ServicePrincipalsGetByIdsRequestBody body) {
        return (List)this.getByIdsAsync(body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<MicrosoftGraphDirectoryObjectInner>> getByIdsWithResponse(ServicePrincipalsGetByIdsRequestBody body, Context context) {
        return (Response)this.getByIdsWithResponseAsync(body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> validatePropertiesWithResponseAsync(ServicePrincipalsValidatePropertiesRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateProperties(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> validatePropertiesWithResponseAsync(ServicePrincipalsValidatePropertiesRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validateProperties(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> validatePropertiesAsync(ServicePrincipalsValidatePropertiesRequestBody body) {
        return this.validatePropertiesWithResponseAsync(body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void validateProperties(ServicePrincipalsValidatePropertiesRequestBody body) {
        this.validatePropertiesAsync(body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> validatePropertiesWithResponse(ServicePrincipalsValidatePropertiesRequestBody body, Context context) {
        return (Response)this.validatePropertiesWithResponseAsync(body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphAppRoleAssignmentInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfAppRoleAssignment0)res.getValue()).value(), ((CollectionOfAppRoleAssignment0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphAppRoleAssignmentInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfAppRoleAssignment0)res.getValue()).value(), ((CollectionOfAppRoleAssignment0)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphAppRoleAssignmentInner>> listAppRoleAssignmentsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listAppRoleAssignmentsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfAppRoleAssignment1)res.getValue()).value(), ((CollectionOfAppRoleAssignment1)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphAppRoleAssignmentInner>> listAppRoleAssignmentsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listAppRoleAssignmentsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfAppRoleAssignment1)res.getValue()).value(), ((CollectionOfAppRoleAssignment1)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphClaimsMappingPolicyInner>> listClaimsMappingPoliciesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listClaimsMappingPoliciesNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfClaimsMappingPolicy)res.getValue()).value(), ((CollectionOfClaimsMappingPolicy)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphClaimsMappingPolicyInner>> listClaimsMappingPoliciesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listClaimsMappingPoliciesNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfClaimsMappingPolicy)res.getValue()).value(), ((CollectionOfClaimsMappingPolicy)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefClaimsMappingPoliciesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefClaimsMappingPoliciesNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfClaimsMappingPolicy)res.getValue()).value(), ((CollectionOfLinksOfClaimsMappingPolicy)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefClaimsMappingPoliciesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefClaimsMappingPoliciesNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfClaimsMappingPolicy)res.getValue()).value(), ((CollectionOfLinksOfClaimsMappingPolicy)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listCreatedObjectsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listCreatedObjectsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject0)res.getValue()).value(), ((CollectionOfDirectoryObject0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listCreatedObjectsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listCreatedObjectsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject0)res.getValue()).value(), ((CollectionOfDirectoryObject0)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefCreatedObjectsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefCreatedObjectsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject0)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefCreatedObjectsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefCreatedObjectsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject0)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject0)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDelegatedPermissionClassificationInner>> listDelegatedPermissionClassificationsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listDelegatedPermissionClassificationsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDelegatedPermissionClassification)res.getValue()).value(), ((CollectionOfDelegatedPermissionClassification)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDelegatedPermissionClassificationInner>> listDelegatedPermissionClassificationsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listDelegatedPermissionClassificationsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDelegatedPermissionClassification)res.getValue()).value(), ((CollectionOfDelegatedPermissionClassification)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphEndpointInner>> listEndpointsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listEndpointsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfEndpoint)res.getValue()).value(), ((CollectionOfEndpoint)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphEndpointInner>> listEndpointsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listEndpointsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfEndpoint)res.getValue()).value(), ((CollectionOfEndpoint)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphHomeRealmDiscoveryPolicyInner>> listHomeRealmDiscoveryPoliciesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listHomeRealmDiscoveryPoliciesNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfHomeRealmDiscoveryPolicy0)res.getValue()).value(), ((CollectionOfHomeRealmDiscoveryPolicy0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphHomeRealmDiscoveryPolicyInner>> listHomeRealmDiscoveryPoliciesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listHomeRealmDiscoveryPoliciesNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfHomeRealmDiscoveryPolicy0)res.getValue()).value(), ((CollectionOfHomeRealmDiscoveryPolicy0)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefHomeRealmDiscoveryPoliciesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefHomeRealmDiscoveryPoliciesNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfHomeRealmDiscoveryPolicy0)res.getValue()).value(), ((CollectionOfLinksOfHomeRealmDiscoveryPolicy0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefHomeRealmDiscoveryPoliciesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefHomeRealmDiscoveryPoliciesNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfHomeRealmDiscoveryPolicy0)res.getValue()).value(), ((CollectionOfLinksOfHomeRealmDiscoveryPolicy0)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMemberOfNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject1)res.getValue()).value(), ((CollectionOfDirectoryObject1)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMemberOfNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject1)res.getValue()).value(), ((CollectionOfDirectoryObject1)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefMemberOfNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject1)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject1)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefMemberOfNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject1)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject1)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOAuth2PermissionGrantInner>> listOauth2PermissionGrantsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listOauth2PermissionGrantsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfOAuth2PermissionGrant)res.getValue()).value(), ((CollectionOfOAuth2PermissionGrant)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOAuth2PermissionGrantInner>> listOauth2PermissionGrantsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listOauth2PermissionGrantsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfOAuth2PermissionGrant)res.getValue()).value(), ((CollectionOfOAuth2PermissionGrant)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefOauth2PermissionGrantsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefOauth2PermissionGrantsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfOAuth2PermissionGrant)res.getValue()).value(), ((CollectionOfLinksOfOAuth2PermissionGrant)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefOauth2PermissionGrantsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefOauth2PermissionGrantsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfOAuth2PermissionGrant)res.getValue()).value(), ((CollectionOfLinksOfOAuth2PermissionGrant)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnedObjectsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listOwnedObjectsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject2)res.getValue()).value(), ((CollectionOfDirectoryObject2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnedObjectsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listOwnedObjectsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject2)res.getValue()).value(), ((CollectionOfDirectoryObject2)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefOwnedObjectsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefOwnedObjectsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefOwnedObjectsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefOwnedObjectsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject2)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listOwnersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject3)res.getValue()).value(), ((CollectionOfDirectoryObject3)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listOwnersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject3)res.getValue()).value(), ((CollectionOfDirectoryObject3)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefOwnersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefOwnersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject3)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject3)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefOwnersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefOwnersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject3)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject3)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphTokenIssuancePolicyInner>> listTokenIssuancePoliciesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listTokenIssuancePoliciesNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfTokenIssuancePolicy0)res.getValue()).value(), ((CollectionOfTokenIssuancePolicy0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphTokenIssuancePolicyInner>> listTokenIssuancePoliciesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listTokenIssuancePoliciesNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfTokenIssuancePolicy0)res.getValue()).value(), ((CollectionOfTokenIssuancePolicy0)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTokenIssuancePoliciesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefTokenIssuancePoliciesNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfTokenIssuancePolicy0)res.getValue()).value(), ((CollectionOfLinksOfTokenIssuancePolicy0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTokenIssuancePoliciesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefTokenIssuancePoliciesNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfTokenIssuancePolicy0)res.getValue()).value(), ((CollectionOfLinksOfTokenIssuancePolicy0)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphTokenLifetimePolicyInner>> listTokenLifetimePoliciesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listTokenLifetimePoliciesNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfTokenLifetimePolicy0)res.getValue()).value(), ((CollectionOfTokenLifetimePolicy0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphTokenLifetimePolicyInner>> listTokenLifetimePoliciesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listTokenLifetimePoliciesNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfTokenLifetimePolicy0)res.getValue()).value(), ((CollectionOfTokenLifetimePolicy0)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTokenLifetimePoliciesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefTokenLifetimePoliciesNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfTokenLifetimePolicy0)res.getValue()).value(), ((CollectionOfLinksOfTokenLifetimePolicy0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTokenLifetimePoliciesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefTokenLifetimePoliciesNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfTokenLifetimePolicy0)res.getValue()).value(), ((CollectionOfLinksOfTokenLifetimePolicy0)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listTransitiveMemberOfNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject4)res.getValue()).value(), ((CollectionOfDirectoryObject4)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listTransitiveMemberOfNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject4)res.getValue()).value(), ((CollectionOfDirectoryObject4)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefTransitiveMemberOfNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject4)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject4)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefTransitiveMemberOfNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject4)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject4)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface ServicePrincipalsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/appRoleAssignedTo")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfAppRoleAssignment0>> listAppRoleAssignedTo(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/appRoleAssignedTo")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> createAppRoleAssignedTo(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") MicrosoftGraphAppRoleAssignmentInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/appRoleAssignedTo/{appRoleAssignment-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> getAppRoleAssignedTo(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @PathParam(value="appRoleAssignment-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/servicePrincipals/{servicePrincipal-id}/appRoleAssignedTo/{appRoleAssignment-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateAppRoleAssignedTo(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @PathParam(value="appRoleAssignment-id") String var3, @BodyParam(value="application/json") MicrosoftGraphAppRoleAssignmentInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/servicePrincipals/{servicePrincipal-id}/appRoleAssignedTo/{appRoleAssignment-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteAppRoleAssignedTo(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @PathParam(value="appRoleAssignment-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/appRoleAssignments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfAppRoleAssignment1>> listAppRoleAssignments(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/appRoleAssignments")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> createAppRoleAssignments(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") MicrosoftGraphAppRoleAssignmentInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/appRoleAssignments/{appRoleAssignment-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> getAppRoleAssignments(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @PathParam(value="appRoleAssignment-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/servicePrincipals/{servicePrincipal-id}/appRoleAssignments/{appRoleAssignment-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateAppRoleAssignments(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @PathParam(value="appRoleAssignment-id") String var3, @BodyParam(value="application/json") MicrosoftGraphAppRoleAssignmentInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/servicePrincipals/{servicePrincipal-id}/appRoleAssignments/{appRoleAssignment-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteAppRoleAssignments(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @PathParam(value="appRoleAssignment-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/claimsMappingPolicies")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfClaimsMappingPolicy>> listClaimsMappingPolicies(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/claimsMappingPolicies/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfClaimsMappingPolicy>> listRefClaimsMappingPolicies(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/claimsMappingPolicies/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefClaimsMappingPolicies(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/createdObjects")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject0>> listCreatedObjects(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/createdObjects/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject0>> listRefCreatedObjects(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/createdObjects/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefCreatedObjects(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/delegatedPermissionClassifications")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDelegatedPermissionClassification>> listDelegatedPermissionClassifications(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/delegatedPermissionClassifications")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDelegatedPermissionClassificationInner>> createDelegatedPermissionClassifications(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") MicrosoftGraphDelegatedPermissionClassificationInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/delegatedPermissionClassifications/{delegatedPermissionClassification-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDelegatedPermissionClassificationInner>> getDelegatedPermissionClassifications(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @PathParam(value="delegatedPermissionClassification-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/servicePrincipals/{servicePrincipal-id}/delegatedPermissionClassifications/{delegatedPermissionClassification-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateDelegatedPermissionClassifications(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @PathParam(value="delegatedPermissionClassification-id") String var3, @BodyParam(value="application/json") MicrosoftGraphDelegatedPermissionClassificationInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/servicePrincipals/{servicePrincipal-id}/delegatedPermissionClassifications/{delegatedPermissionClassification-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteDelegatedPermissionClassifications(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @PathParam(value="delegatedPermissionClassification-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/endpoints")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfEndpoint>> listEndpoints(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/endpoints")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphEndpointInner>> createEndpoints(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") MicrosoftGraphEndpointInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/endpoints/{endpoint-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphEndpointInner>> getEndpoints(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @PathParam(value="endpoint-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/servicePrincipals/{servicePrincipal-id}/endpoints/{endpoint-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateEndpoints(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @PathParam(value="endpoint-id") String var3, @BodyParam(value="application/json") MicrosoftGraphEndpointInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/servicePrincipals/{servicePrincipal-id}/endpoints/{endpoint-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteEndpoints(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @PathParam(value="endpoint-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/homeRealmDiscoveryPolicies")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfHomeRealmDiscoveryPolicy0>> listHomeRealmDiscoveryPolicies(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/homeRealmDiscoveryPolicies/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfHomeRealmDiscoveryPolicy0>> listRefHomeRealmDiscoveryPolicies(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/homeRealmDiscoveryPolicies/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefHomeRealmDiscoveryPolicies(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/memberOf")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject1>> listMemberOf(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/memberOf/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject1>> listRefMemberOf(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/memberOf/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefMemberOf(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/microsoft.graph.addKey")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphKeyCredentialInner>> addKey(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") ServicePrincipalsAddKeyRequestBodyInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/microsoft.graph.addPassword")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphPasswordCredentialInner>> addPassword(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") ServicePrincipalsAddPasswordRequestBodyInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/microsoft.graph.checkMemberGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> checkMemberGroups(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") ServicePrincipalsCheckMemberGroupsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/microsoft.graph.checkMemberObjects")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> checkMemberObjects(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") ServicePrincipalsCheckMemberObjectsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/microsoft.graph.getMemberGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> getMemberGroups(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") ServicePrincipalsGetMemberGroupsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/microsoft.graph.getMemberObjects")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> getMemberObjects(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") ServicePrincipalsGetMemberObjectsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/microsoft.graph.removeKey")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> removeKey(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") ServicePrincipalsRemoveKeyRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/microsoft.graph.removePassword")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> removePassword(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") ServicePrincipalsRemovePasswordRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/microsoft.graph.restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDirectoryObjectInner>> restore(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/oauth2PermissionGrants")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfOAuth2PermissionGrant>> listOauth2PermissionGrants(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/oauth2PermissionGrants/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfOAuth2PermissionGrant>> listRefOauth2PermissionGrants(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/oauth2PermissionGrants/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefOauth2PermissionGrants(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/ownedObjects")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject2>> listOwnedObjects(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/ownedObjects/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject2>> listRefOwnedObjects(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/ownedObjects/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefOwnedObjects(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/owners")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject3>> listOwners(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/owners/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject3>> listRefOwners(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/owners/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefOwners(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/tokenIssuancePolicies")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfTokenIssuancePolicy0>> listTokenIssuancePolicies(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/tokenIssuancePolicies/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfTokenIssuancePolicy0>> listRefTokenIssuancePolicies(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/tokenIssuancePolicies/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefTokenIssuancePolicies(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/tokenLifetimePolicies")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfTokenLifetimePolicy0>> listTokenLifetimePolicies(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/tokenLifetimePolicies/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfTokenLifetimePolicy0>> listRefTokenLifetimePolicies(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/tokenLifetimePolicies/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefTokenLifetimePolicies(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/transitiveMemberOf")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject4>> listTransitiveMemberOf(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}/transitiveMemberOf/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject4>> listRefTransitiveMemberOf(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/transitiveMemberOf/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefTransitiveMemberOf(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/microsoft.graph.delta()")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<MicrosoftGraphServicePrincipalInner>>> delta(@HostParam(value="$host") String var1, @HeaderParam(value="Accept") String var2, Context var3);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/microsoft.graph.getAvailableExtensionProperties")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionProperties(@HostParam(value="$host") String var1, @BodyParam(value="application/json") ServicePrincipalsGetAvailableExtensionPropertiesRequestBody var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/microsoft.graph.getByIds")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIds(@HostParam(value="$host") String var1, @BodyParam(value="application/json") ServicePrincipalsGetByIdsRequestBody var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/microsoft.graph.validateProperties")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> validateProperties(@HostParam(value="$host") String var1, @BodyParam(value="application/json") ServicePrincipalsValidatePropertiesRequestBody var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfAppRoleAssignment0>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfAppRoleAssignment1>> listAppRoleAssignmentsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfClaimsMappingPolicy>> listClaimsMappingPoliciesNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfClaimsMappingPolicy>> listRefClaimsMappingPoliciesNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject0>> listCreatedObjectsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject0>> listRefCreatedObjectsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDelegatedPermissionClassification>> listDelegatedPermissionClassificationsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfEndpoint>> listEndpointsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfHomeRealmDiscoveryPolicy0>> listHomeRealmDiscoveryPoliciesNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfHomeRealmDiscoveryPolicy0>> listRefHomeRealmDiscoveryPoliciesNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject1>> listMemberOfNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject1>> listRefMemberOfNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfOAuth2PermissionGrant>> listOauth2PermissionGrantsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfOAuth2PermissionGrant>> listRefOauth2PermissionGrantsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject2>> listOwnedObjectsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject2>> listRefOwnedObjectsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject3>> listOwnersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject3>> listRefOwnersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfTokenIssuancePolicy0>> listTokenIssuancePoliciesNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfTokenIssuancePolicy0>> listRefTokenIssuancePoliciesNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfTokenLifetimePolicy0>> listTokenLifetimePoliciesNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfTokenLifetimePolicy0>> listRefTokenLifetimePoliciesNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject4>> listTransitiveMemberOfNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject4>> listRefTransitiveMemberOfNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

