/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.RoleAssignmentsClient;
import com.azure.resourcemanager.authorization.fluent.models.RoleAssignmentInner;
import com.azure.resourcemanager.authorization.fluent.models.ValidationResponseInner;
import com.azure.resourcemanager.authorization.implementation.AuthorizationManagementClientImpl;
import com.azure.resourcemanager.authorization.models.RoleAssignmentCreateParameters;
import com.azure.resourcemanager.authorization.models.RoleAssignmentListResult;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import reactor.core.publisher.Mono;

public final class RoleAssignmentsClientImpl
implements InnerSupportsListing<RoleAssignmentInner>,
InnerSupportsDelete<RoleAssignmentInner>,
RoleAssignmentsClient {
    private final ClientLogger logger = new ClientLogger(RoleAssignmentsClientImpl.class);
    private final RoleAssignmentsService service;
    private final AuthorizationManagementClientImpl client;

    RoleAssignmentsClientImpl(AuthorizationManagementClientImpl client) {
        this.service = (RoleAssignmentsService)RestProxy.create(RoleAssignmentsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listSinglePageAsync(String filter, String tenantId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), "2020-08-01-preview", filter, tenantId, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listSinglePageAsync(String filter, String tenantId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), "2020-08-01-preview", filter, tenantId, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RoleAssignmentInner> listAsync(String filter, String tenantId) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, tenantId), nextLink -> this.listForSubscriptionNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RoleAssignmentInner> listAsync() {
        String filter = null;
        String tenantId = null;
        return new PagedFlux(() -> this.listSinglePageAsync(filter, tenantId), nextLink -> this.listForSubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RoleAssignmentInner> listAsync(String filter, String tenantId, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, tenantId, context), nextLink -> this.listForSubscriptionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoleAssignmentInner> list() {
        String filter = null;
        String tenantId = null;
        return new PagedIterable(this.listAsync(filter, tenantId));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoleAssignmentInner> list(String filter, String tenantId, Context context) {
        return new PagedIterable(this.listAsync(filter, tenantId, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, String filter, String tenantId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2020-08-01-preview", filter, tenantId, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, String filter, String tenantId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2020-08-01-preview", filter, tenantId, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RoleAssignmentInner> listByResourceGroupAsync(String resourceGroupName, String filter, String tenantId) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, tenantId), nextLink -> this.listForResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RoleAssignmentInner> listByResourceGroupAsync(String resourceGroupName) {
        String filter = null;
        String tenantId = null;
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, tenantId), nextLink -> this.listForResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RoleAssignmentInner> listByResourceGroupAsync(String resourceGroupName, String filter, String tenantId, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, tenantId, context), nextLink -> this.listForResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoleAssignmentInner> listByResourceGroup(String resourceGroupName) {
        String filter = null;
        String tenantId = null;
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, filter, tenantId));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoleAssignmentInner> listByResourceGroup(String resourceGroupName, String filter, String tenantId, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, filter, tenantId, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listForResourceSinglePageAsync(String resourceGroupName, String resourceProviderNamespace, String resourceType, String resourceName, String filter, String tenantId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForResource(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceProviderNamespace, resourceType, resourceName, "2020-08-01-preview", filter, tenantId, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listForResourceSinglePageAsync(String resourceGroupName, String resourceProviderNamespace, String resourceType, String resourceName, String filter, String tenantId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForResource(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceProviderNamespace, resourceType, resourceName, "2020-08-01-preview", filter, tenantId, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RoleAssignmentInner> listForResourceAsync(String resourceGroupName, String resourceProviderNamespace, String resourceType, String resourceName, String filter, String tenantId) {
        return new PagedFlux(() -> this.listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, resourceType, resourceName, filter, tenantId), nextLink -> this.listForResourceNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RoleAssignmentInner> listForResourceAsync(String resourceGroupName, String resourceProviderNamespace, String resourceType, String resourceName) {
        String filter = null;
        String tenantId = null;
        return new PagedFlux(() -> this.listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, resourceType, resourceName, filter, tenantId), nextLink -> this.listForResourceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RoleAssignmentInner> listForResourceAsync(String resourceGroupName, String resourceProviderNamespace, String resourceType, String resourceName, String filter, String tenantId, Context context) {
        return new PagedFlux(() -> this.listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, resourceType, resourceName, filter, tenantId, context), nextLink -> this.listForResourceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoleAssignmentInner> listForResource(String resourceGroupName, String resourceProviderNamespace, String resourceType, String resourceName) {
        String filter = null;
        String tenantId = null;
        return new PagedIterable(this.listForResourceAsync(resourceGroupName, resourceProviderNamespace, resourceType, resourceName, filter, tenantId));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoleAssignmentInner> listForResource(String resourceGroupName, String resourceProviderNamespace, String resourceType, String resourceName, String filter, String tenantId, Context context) {
        return new PagedIterable(this.listForResourceAsync(resourceGroupName, resourceProviderNamespace, resourceType, resourceName, filter, tenantId, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleAssignmentInner>> getWithResponseAsync(String scope, String roleAssignmentName, String tenantId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null."));
        }
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), scope, roleAssignmentName, "2020-08-01-preview", tenantId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RoleAssignmentInner>> getWithResponseAsync(String scope, String roleAssignmentName, String tenantId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null."));
        }
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), scope, roleAssignmentName, "2020-08-01-preview", tenantId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleAssignmentInner> getAsync(String scope, String roleAssignmentName, String tenantId) {
        return this.getWithResponseAsync(scope, roleAssignmentName, tenantId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RoleAssignmentInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleAssignmentInner> getAsync(String scope, String roleAssignmentName) {
        String tenantId = null;
        return this.getWithResponseAsync(scope, roleAssignmentName, tenantId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RoleAssignmentInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoleAssignmentInner get(String scope, String roleAssignmentName) {
        String tenantId = null;
        return (RoleAssignmentInner)((Object)this.getAsync(scope, roleAssignmentName, tenantId).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoleAssignmentInner> getWithResponse(String scope, String roleAssignmentName, String tenantId, Context context) {
        return (Response)this.getWithResponseAsync(scope, roleAssignmentName, tenantId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleAssignmentInner>> createWithResponseAsync(String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), scope, roleAssignmentName, "2020-08-01-preview", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RoleAssignmentInner>> createWithResponseAsync(String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), scope, roleAssignmentName, "2020-08-01-preview", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleAssignmentInner> createAsync(String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters) {
        return this.createWithResponseAsync(scope, roleAssignmentName, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RoleAssignmentInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoleAssignmentInner create(String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters) {
        return (RoleAssignmentInner)((Object)this.createAsync(scope, roleAssignmentName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoleAssignmentInner> createWithResponse(String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters, Context context) {
        return (Response)this.createWithResponseAsync(scope, roleAssignmentName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleAssignmentInner>> deleteWithResponseAsync(String scope, String roleAssignmentName, String tenantId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null."));
        }
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), scope, roleAssignmentName, "2020-08-01-preview", tenantId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RoleAssignmentInner>> deleteWithResponseAsync(String scope, String roleAssignmentName, String tenantId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null."));
        }
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), scope, roleAssignmentName, "2020-08-01-preview", tenantId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleAssignmentInner> deleteAsync(String scope, String roleAssignmentName, String tenantId) {
        return this.deleteWithResponseAsync(scope, roleAssignmentName, tenantId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RoleAssignmentInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleAssignmentInner> deleteAsync(String scope, String roleAssignmentName) {
        String tenantId = null;
        return this.deleteWithResponseAsync(scope, roleAssignmentName, tenantId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RoleAssignmentInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoleAssignmentInner delete(String scope, String roleAssignmentName) {
        String tenantId = null;
        return (RoleAssignmentInner)((Object)this.deleteAsync(scope, roleAssignmentName, tenantId).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoleAssignmentInner> deleteWithResponse(String scope, String roleAssignmentName, String tenantId, Context context) {
        return (Response)this.deleteWithResponseAsync(scope, roleAssignmentName, tenantId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ValidationResponseInner>> validateWithResponseAsync(String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validate(this.client.getEndpoint(), scope, roleAssignmentName, "2020-08-01-preview", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ValidationResponseInner>> validateWithResponseAsync(String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validate(this.client.getEndpoint(), scope, roleAssignmentName, "2020-08-01-preview", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ValidationResponseInner> validateAsync(String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters) {
        return this.validateWithResponseAsync(scope, roleAssignmentName, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ValidationResponseInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ValidationResponseInner validate(String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters) {
        return (ValidationResponseInner)this.validateAsync(scope, roleAssignmentName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ValidationResponseInner> validateWithResponse(String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters, Context context) {
        return (Response)this.validateWithResponseAsync(scope, roleAssignmentName, parameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listForScopeSinglePageAsync(String scope, String filter, String tenantId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForScope(this.client.getEndpoint(), scope, filter, "2020-08-01-preview", tenantId, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listForScopeSinglePageAsync(String scope, String filter, String tenantId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForScope(this.client.getEndpoint(), scope, filter, "2020-08-01-preview", tenantId, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RoleAssignmentInner> listForScopeAsync(String scope, String filter, String tenantId) {
        return new PagedFlux(() -> this.listForScopeSinglePageAsync(scope, filter, tenantId), nextLink -> this.listForScopeNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RoleAssignmentInner> listForScopeAsync(String scope) {
        String filter = null;
        String tenantId = null;
        return new PagedFlux(() -> this.listForScopeSinglePageAsync(scope, filter, tenantId), nextLink -> this.listForScopeNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RoleAssignmentInner> listForScopeAsync(String scope, String filter, String tenantId, Context context) {
        return new PagedFlux(() -> this.listForScopeSinglePageAsync(scope, filter, tenantId, context), nextLink -> this.listForScopeNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoleAssignmentInner> listForScope(String scope) {
        String filter = null;
        String tenantId = null;
        return new PagedIterable(this.listForScopeAsync(scope, filter, tenantId));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoleAssignmentInner> listForScope(String scope, String filter, String tenantId, Context context) {
        return new PagedIterable(this.listForScopeAsync(scope, filter, tenantId, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleAssignmentInner>> getByIdWithResponseAsync(String roleAssignmentId, String tenantId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentId is required and cannot be null."));
        }
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getById(this.client.getEndpoint(), roleAssignmentId, "2020-08-01-preview", tenantId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RoleAssignmentInner>> getByIdWithResponseAsync(String roleAssignmentId, String tenantId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentId is required and cannot be null."));
        }
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getById(this.client.getEndpoint(), roleAssignmentId, "2020-08-01-preview", tenantId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleAssignmentInner> getByIdAsync(String roleAssignmentId, String tenantId) {
        return this.getByIdWithResponseAsync(roleAssignmentId, tenantId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RoleAssignmentInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleAssignmentInner> getByIdAsync(String roleAssignmentId) {
        String tenantId = null;
        return this.getByIdWithResponseAsync(roleAssignmentId, tenantId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RoleAssignmentInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoleAssignmentInner getById(String roleAssignmentId) {
        String tenantId = null;
        return (RoleAssignmentInner)((Object)this.getByIdAsync(roleAssignmentId, tenantId).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoleAssignmentInner> getByIdWithResponse(String roleAssignmentId, String tenantId, Context context) {
        return (Response)this.getByIdWithResponseAsync(roleAssignmentId, tenantId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleAssignmentInner>> createByIdWithResponseAsync(String roleAssignmentId, RoleAssignmentCreateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createById(this.client.getEndpoint(), roleAssignmentId, "2020-08-01-preview", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RoleAssignmentInner>> createByIdWithResponseAsync(String roleAssignmentId, RoleAssignmentCreateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createById(this.client.getEndpoint(), roleAssignmentId, "2020-08-01-preview", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleAssignmentInner> createByIdAsync(String roleAssignmentId, RoleAssignmentCreateParameters parameters) {
        return this.createByIdWithResponseAsync(roleAssignmentId, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RoleAssignmentInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoleAssignmentInner createById(String roleAssignmentId, RoleAssignmentCreateParameters parameters) {
        return (RoleAssignmentInner)((Object)this.createByIdAsync(roleAssignmentId, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoleAssignmentInner> createByIdWithResponse(String roleAssignmentId, RoleAssignmentCreateParameters parameters, Context context) {
        return (Response)this.createByIdWithResponseAsync(roleAssignmentId, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleAssignmentInner>> deleteByIdWithResponseAsync(String roleAssignmentId, String tenantId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentId is required and cannot be null."));
        }
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteById(this.client.getEndpoint(), roleAssignmentId, "2020-08-01-preview", tenantId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RoleAssignmentInner>> deleteByIdWithResponseAsync(String roleAssignmentId, String tenantId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentId is required and cannot be null."));
        }
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteById(this.client.getEndpoint(), roleAssignmentId, "2020-08-01-preview", tenantId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleAssignmentInner> deleteByIdAsync(String roleAssignmentId, String tenantId) {
        return this.deleteByIdWithResponseAsync(roleAssignmentId, tenantId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RoleAssignmentInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleAssignmentInner> deleteByIdAsync(String roleAssignmentId) {
        String tenantId = null;
        return this.deleteByIdWithResponseAsync(roleAssignmentId, tenantId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RoleAssignmentInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoleAssignmentInner deleteById(String roleAssignmentId) {
        String tenantId = null;
        return (RoleAssignmentInner)((Object)this.deleteByIdAsync(roleAssignmentId, tenantId).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoleAssignmentInner> deleteByIdWithResponse(String roleAssignmentId, String tenantId, Context context) {
        return (Response)this.deleteByIdWithResponseAsync(roleAssignmentId, tenantId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ValidationResponseInner>> validateByIdWithResponseAsync(String roleAssignmentId, RoleAssignmentCreateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateById(this.client.getEndpoint(), roleAssignmentId, "2020-08-01-preview", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ValidationResponseInner>> validateByIdWithResponseAsync(String roleAssignmentId, RoleAssignmentCreateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-08-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validateById(this.client.getEndpoint(), roleAssignmentId, "2020-08-01-preview", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ValidationResponseInner> validateByIdAsync(String roleAssignmentId, RoleAssignmentCreateParameters parameters) {
        return this.validateByIdWithResponseAsync(roleAssignmentId, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ValidationResponseInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ValidationResponseInner validateById(String roleAssignmentId, RoleAssignmentCreateParameters parameters) {
        return (ValidationResponseInner)this.validateByIdAsync(roleAssignmentId, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ValidationResponseInner> validateByIdWithResponse(String roleAssignmentId, RoleAssignmentCreateParameters parameters, Context context) {
        return (Response)this.validateByIdWithResponseAsync(roleAssignmentId, parameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listForSubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForSubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listForSubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForSubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listForResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listForResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listForResourceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForResourceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listForResourceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForResourceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listForScopeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForScopeNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listForScopeNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForScopeNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AuthorizationManagem")
    private static interface RoleAssignmentsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/roleAssignments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="$filter", encoded=true) String var4, @QueryParam(value="tenantId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/roleAssignments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$filter", encoded=true) String var5, @QueryParam(value="tenantId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/roleAssignments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentListResult>> listForResource(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceProviderNamespace", encoded=true) String var4, @PathParam(value="resourceType", encoded=true) String var5, @PathParam(value="resourceName", encoded=true) String var6, @QueryParam(value="api-version") String var7, @QueryParam(value="$filter", encoded=true) String var8, @QueryParam(value="tenantId") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentInner>> get(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleAssignmentName", encoded=true) String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="tenantId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentInner>> create(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleAssignmentName", encoded=true) String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") RoleAssignmentCreateParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentInner>> delete(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleAssignmentName", encoded=true) String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="tenantId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}/validate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ValidationResponseInner>> validate(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleAssignmentName", encoded=true) String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") RoleAssignmentCreateParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.Authorization/roleAssignments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentListResult>> listForScope(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @QueryParam(value="$filter", encoded=true) String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="tenantId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{roleAssignmentId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentInner>> getById(@HostParam(value="$host") String var1, @PathParam(value="roleAssignmentId", encoded=true) String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="tenantId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/{roleAssignmentId}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentInner>> createById(@HostParam(value="$host") String var1, @PathParam(value="roleAssignmentId", encoded=true) String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") RoleAssignmentCreateParameters var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/{roleAssignmentId}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentInner>> deleteById(@HostParam(value="$host") String var1, @PathParam(value="roleAssignmentId", encoded=true) String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="tenantId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{roleAssignmentId}/validate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ValidationResponseInner>> validateById(@HostParam(value="$host") String var1, @PathParam(value="roleAssignmentId", encoded=true) String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") RoleAssignmentCreateParameters var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentListResult>> listForSubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentListResult>> listForResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentListResult>> listForResourceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentListResult>> listForScopeNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

