/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.ProcessThreadInfoInner;
import java.io.IOException;
import java.util.List;

public final class ProcessThreadInfoCollection
implements JsonSerializable<ProcessThreadInfoCollection> {
    private List<ProcessThreadInfoInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ProcessThreadInfoCollection.class);

    public List<ProcessThreadInfoInner> value() {
        return this.value;
    }

    public ProcessThreadInfoCollection withValue(List<ProcessThreadInfoInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ProcessThreadInfoCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ProcessThreadInfoCollection fromJson(JsonReader jsonReader) throws IOException {
        return (ProcessThreadInfoCollection)jsonReader.readObject(reader -> {
            ProcessThreadInfoCollection deserializedProcessThreadInfoCollection = new ProcessThreadInfoCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedProcessThreadInfoCollection.value = value = reader.readArray(reader1 -> ProcessThreadInfoInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedProcessThreadInfoCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProcessThreadInfoCollection;
        });
    }
}

