/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.LogAnalyticsConfiguration;
import java.io.IOException;

public final class AppLogsConfiguration
implements JsonSerializable<AppLogsConfiguration> {
    private String destination;
    private LogAnalyticsConfiguration logAnalyticsConfiguration;

    public String destination() {
        return this.destination;
    }

    public AppLogsConfiguration withDestination(String destination) {
        this.destination = destination;
        return this;
    }

    public LogAnalyticsConfiguration logAnalyticsConfiguration() {
        return this.logAnalyticsConfiguration;
    }

    public AppLogsConfiguration withLogAnalyticsConfiguration(LogAnalyticsConfiguration logAnalyticsConfiguration) {
        this.logAnalyticsConfiguration = logAnalyticsConfiguration;
        return this;
    }

    public void validate() {
        if (this.logAnalyticsConfiguration() != null) {
            this.logAnalyticsConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("destination", this.destination);
        jsonWriter.writeJsonField("logAnalyticsConfiguration", (JsonSerializable)this.logAnalyticsConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static AppLogsConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (AppLogsConfiguration)jsonReader.readObject(reader -> {
            AppLogsConfiguration deserializedAppLogsConfiguration = new AppLogsConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("destination".equals(fieldName)) {
                    deserializedAppLogsConfiguration.destination = reader.getString();
                    continue;
                }
                if ("logAnalyticsConfiguration".equals(fieldName)) {
                    deserializedAppLogsConfiguration.logAnalyticsConfiguration = LogAnalyticsConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAppLogsConfiguration;
        });
    }
}

