/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.models.ConnectionStringDictionaryInner;
import com.azure.resourcemanager.appservice.fluent.models.HostnameBindingInner;
import com.azure.resourcemanager.appservice.fluent.models.MSDeployStatusInner;
import com.azure.resourcemanager.appservice.fluent.models.RemotePrivateEndpointConnectionArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteAuthSettingsInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteConfigInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteConfigResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteLogsConfigInner;
import com.azure.resourcemanager.appservice.fluent.models.SitePatchResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteSourceControlInner;
import com.azure.resourcemanager.appservice.fluent.models.SlotConfigNamesResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StringDictionaryInner;
import com.azure.resourcemanager.appservice.implementation.AppSettingImpl;
import com.azure.resourcemanager.appservice.implementation.ConnectionStringImpl;
import com.azure.resourcemanager.appservice.implementation.DeploymentSlotBaseImpl;
import com.azure.resourcemanager.appservice.implementation.HostnameBindingImpl;
import com.azure.resourcemanager.appservice.implementation.HostnameSslBindingImpl;
import com.azure.resourcemanager.appservice.implementation.KuduClient;
import com.azure.resourcemanager.appservice.implementation.WebAppAuthenticationImpl;
import com.azure.resourcemanager.appservice.implementation.WebAppDiagnosticLogsImpl;
import com.azure.resourcemanager.appservice.implementation.WebAppMsiHandler;
import com.azure.resourcemanager.appservice.implementation.WebAppSourceControlImpl;
import com.azure.resourcemanager.appservice.implementation.WebDeploymentImpl;
import com.azure.resourcemanager.appservice.implementation.WebSiteBaseImpl;
import com.azure.resourcemanager.appservice.models.AppServiceCertificate;
import com.azure.resourcemanager.appservice.models.AppServiceDomain;
import com.azure.resourcemanager.appservice.models.AppSetting;
import com.azure.resourcemanager.appservice.models.AzureResourceType;
import com.azure.resourcemanager.appservice.models.CloningInfo;
import com.azure.resourcemanager.appservice.models.ConnStringValueTypePair;
import com.azure.resourcemanager.appservice.models.ConnectionString;
import com.azure.resourcemanager.appservice.models.ConnectionStringType;
import com.azure.resourcemanager.appservice.models.CustomHostnameDnsRecordType;
import com.azure.resourcemanager.appservice.models.FtpsState;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentProfile;
import com.azure.resourcemanager.appservice.models.HostnameSslState;
import com.azure.resourcemanager.appservice.models.HostnameType;
import com.azure.resourcemanager.appservice.models.IpFilterTag;
import com.azure.resourcemanager.appservice.models.IpSecurityRestriction;
import com.azure.resourcemanager.appservice.models.JavaVersion;
import com.azure.resourcemanager.appservice.models.MSDeploy;
import com.azure.resourcemanager.appservice.models.ManagedPipelineMode;
import com.azure.resourcemanager.appservice.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appservice.models.NetFrameworkVersion;
import com.azure.resourcemanager.appservice.models.OperatingSystem;
import com.azure.resourcemanager.appservice.models.PhpVersion;
import com.azure.resourcemanager.appservice.models.PlatformArchitecture;
import com.azure.resourcemanager.appservice.models.PrivateLinkResource;
import com.azure.resourcemanager.appservice.models.PublicNetworkAccess;
import com.azure.resourcemanager.appservice.models.PythonVersion;
import com.azure.resourcemanager.appservice.models.RedundancyMode;
import com.azure.resourcemanager.appservice.models.RemoteVisualStudioVersion;
import com.azure.resourcemanager.appservice.models.ScmType;
import com.azure.resourcemanager.appservice.models.SiteAvailabilityState;
import com.azure.resourcemanager.appservice.models.SlotSwapStatus;
import com.azure.resourcemanager.appservice.models.SslState;
import com.azure.resourcemanager.appservice.models.SupportedTlsVersions;
import com.azure.resourcemanager.appservice.models.UsageState;
import com.azure.resourcemanager.appservice.models.VirtualApplication;
import com.azure.resourcemanager.appservice.models.WebAppAuthentication;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.appservice.models.WebContainer;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.azure.resourcemanager.authorization.models.BuiltInRole;
import com.azure.resourcemanager.authorization.utils.RoleAssignmentHelper;
import com.azure.resourcemanager.msi.models.Identity;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateEndpoint;
import com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateEndpointConnection;
import com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateEndpointConnectionProvisioningState;
import com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateEndpointServiceConnectionStatus;
import com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateLinkServiceConnectionState;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.dag.FunctionalTaskItem;
import com.azure.resourcemanager.resources.fluentcore.dag.IndexableTaskItem;
import com.azure.resourcemanager.resources.fluentcore.dag.TaskGroup;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

abstract class WebAppBaseImpl<FluentT extends WebAppBase, FluentImplT extends WebAppBaseImpl<FluentT, FluentImplT>>
extends GroupableResourceImpl<FluentT, SiteInner, FluentImplT, AppServiceManager>
implements WebAppBase,
WebAppBase.Definition<FluentT>,
WebAppBase.Update<FluentT>,
WebAppBase.UpdateStages.WithWebContainer<FluentT> {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    protected static final String SETTING_DOCKER_IMAGE = "DOCKER_CUSTOM_IMAGE_NAME";
    protected static final String SETTING_REGISTRY_SERVER = "DOCKER_REGISTRY_SERVER_URL";
    protected static final String SETTING_REGISTRY_USERNAME = "DOCKER_REGISTRY_SERVER_USERNAME";
    protected static final String SETTING_REGISTRY_PASSWORD = "DOCKER_REGISTRY_SERVER_PASSWORD";
    protected static final String SETTING_FUNCTIONS_WORKER_RUNTIME = "FUNCTIONS_WORKER_RUNTIME";
    protected static final String SETTING_FUNCTIONS_EXTENSION_VERSION = "FUNCTIONS_EXTENSION_VERSION";
    protected static final String IP_RESTRICTION_ACTION_ALLOW = "Allow";
    protected static final String IP_RESTRICTION_ACTION_DENY = "Deny";
    private static final Map<AzureEnvironment, String> DNS_MAP = new HashMap<AzureEnvironment, String>(){
        {
            this.put(AzureEnvironment.AZURE, "azurewebsites.net");
            this.put(AzureEnvironment.AZURE_CHINA, "chinacloudsites.cn");
            this.put(AzureEnvironment.AZURE_GERMANY, "azurewebsites.de");
            this.put(AzureEnvironment.AZURE_US_GOVERNMENT, "azurewebsites.us");
        }
    };
    SiteConfigResourceInner siteConfig;
    KuduClient kuduClient;
    WebSiteBase webSiteBase;
    private Map<String, HostnameSslState> hostNameSslStateMap;
    private TreeMap<String, HostnameBindingImpl<FluentT, FluentImplT>> hostNameBindingsToCreate;
    private List<String> hostNameBindingsToDelete;
    private TreeMap<String, HostnameSslBindingImpl<FluentT, FluentImplT>> sslBindingsToCreate;
    protected Map<String, String> appSettingsToAdd;
    protected List<String> appSettingsToRemove;
    private Map<String, Boolean> appSettingStickiness;
    private Map<String, ConnStringValueTypePair> connectionStringsToAdd;
    private List<String> connectionStringsToRemove;
    private Map<String, Boolean> connectionStringStickiness;
    private WebAppSourceControlImpl<FluentT, FluentImplT> sourceControl;
    private boolean sourceControlToDelete;
    private WebAppAuthenticationImpl<FluentT, FluentImplT> authentication;
    private boolean authenticationToUpdate;
    private WebAppDiagnosticLogsImpl<FluentT, FluentImplT> diagnosticLogs;
    private boolean diagnosticLogsToUpdate;
    private FunctionalTaskItem msiHandler;
    private boolean isInCreateMode;
    private WebAppMsiHandler<FluentT, FluentImplT> webAppMsiHandler;

    WebAppBaseImpl(String name, SiteInner innerObject, SiteConfigResourceInner siteConfig, SiteLogsConfigInner logConfig, AppServiceManager manager) {
        super(name, (Resource)innerObject, (Manager)manager);
        if (innerObject != null && innerObject.kind() != null) {
            innerObject.withKind(innerObject.kind().replace(";", ","));
        }
        this.siteConfig = siteConfig;
        if (logConfig != null) {
            this.diagnosticLogs = new WebAppDiagnosticLogsImpl(logConfig, this);
        }
        this.webAppMsiHandler = new WebAppMsiHandler(manager.authorizationManager(), this);
        this.normalizeProperties();
        boolean bl = this.isInCreateMode = this.innerModel() == null || ((SiteInner)((Object)this.innerModel())).id() == null;
        if (!this.isInCreateMode) {
            this.initializeKuduClient();
        }
    }

    public boolean isInCreateMode() {
        return this.isInCreateMode;
    }

    private void initializeKuduClient() {
        if (this.kuduClient == null) {
            this.kuduClient = new KuduClient(this);
        }
    }

    public void setInner(SiteInner innerObject) {
        if (innerObject.kind() != null) {
            innerObject.withKind(innerObject.kind().replace(";", ","));
        }
        super.setInner((Object)innerObject);
    }

    RoleAssignmentHelper.IdProvider idProvider() {
        return new RoleAssignmentHelper.IdProvider(){

            public String principalId() {
                if (WebAppBaseImpl.this.innerModel() != null && ((SiteInner)((Object)WebAppBaseImpl.this.innerModel())).identity() != null) {
                    return ((SiteInner)((Object)WebAppBaseImpl.this.innerModel())).identity().principalId();
                }
                return null;
            }

            public String resourceId() {
                if (WebAppBaseImpl.this.innerModel() != null) {
                    return ((SiteInner)((Object)WebAppBaseImpl.this.innerModel())).id();
                }
                return null;
            }
        };
    }

    private void normalizeProperties() {
        this.hostNameBindingsToCreate = new TreeMap();
        this.hostNameBindingsToDelete = new ArrayList<String>();
        this.appSettingsToAdd = new HashMap<String, String>();
        this.appSettingsToRemove = new ArrayList<String>();
        this.appSettingStickiness = new HashMap<String, Boolean>();
        this.connectionStringsToAdd = new HashMap<String, ConnStringValueTypePair>();
        this.connectionStringsToRemove = new ArrayList<String>();
        this.connectionStringStickiness = new HashMap<String, Boolean>();
        this.sourceControl = null;
        this.sourceControlToDelete = false;
        this.authenticationToUpdate = false;
        this.diagnosticLogsToUpdate = false;
        this.sslBindingsToCreate = new TreeMap();
        this.msiHandler = null;
        this.webSiteBase = new WebSiteBaseImpl((SiteInner)((Object)this.innerModel()));
        this.hostNameSslStateMap = new HashMap<String, HostnameSslState>(this.webSiteBase.hostnameSslStates());
        this.webAppMsiHandler.clear();
    }

    @Override
    public String state() {
        return this.webSiteBase.state();
    }

    @Override
    public Set<String> hostnames() {
        return this.webSiteBase.hostnames();
    }

    @Override
    public String repositorySiteName() {
        return this.webSiteBase.repositorySiteName();
    }

    @Override
    public UsageState usageState() {
        return this.webSiteBase.usageState();
    }

    @Override
    public boolean enabled() {
        return this.webSiteBase.enabled();
    }

    @Override
    public Set<String> enabledHostNames() {
        return this.webSiteBase.enabledHostNames();
    }

    @Override
    public SiteAvailabilityState availabilityState() {
        return this.webSiteBase.availabilityState();
    }

    @Override
    public Map<String, HostnameSslState> hostnameSslStates() {
        return Collections.unmodifiableMap(this.hostNameSslStateMap);
    }

    @Override
    public String appServicePlanId() {
        return this.webSiteBase.appServicePlanId();
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return this.webSiteBase.lastModifiedTime();
    }

    @Override
    public Set<String> trafficManagerHostNames() {
        return this.webSiteBase.trafficManagerHostNames();
    }

    @Override
    public boolean scmSiteAlsoStopped() {
        return this.webSiteBase.scmSiteAlsoStopped();
    }

    @Override
    public String targetSwapSlot() {
        return this.webSiteBase.targetSwapSlot();
    }

    @Override
    public boolean clientAffinityEnabled() {
        return this.webSiteBase.clientAffinityEnabled();
    }

    @Override
    public boolean clientCertEnabled() {
        return this.webSiteBase.clientCertEnabled();
    }

    @Override
    public boolean hostnamesDisabled() {
        return this.webSiteBase.hostnamesDisabled();
    }

    @Override
    public Set<String> outboundIPAddresses() {
        return this.webSiteBase.outboundIPAddresses();
    }

    @Override
    public int containerSize() {
        return this.webSiteBase.containerSize();
    }

    @Override
    public CloningInfo cloningInfo() {
        return this.webSiteBase.cloningInfo();
    }

    @Override
    public boolean isDefaultContainer() {
        return this.webSiteBase.isDefaultContainer();
    }

    @Override
    public String defaultHostname() {
        if (((SiteInner)((Object)this.innerModel())).defaultHostname() != null) {
            return ((SiteInner)((Object)this.innerModel())).defaultHostname();
        }
        AzureEnvironment environment = ((AppServiceManager)this.manager()).environment();
        String dns = DNS_MAP.get(environment);
        String leaf = this.name();
        if (this instanceof DeploymentSlotBaseImpl) {
            leaf = ((DeploymentSlotBaseImpl)this).parent().name() + "-" + leaf;
        }
        return leaf + "." + dns;
    }

    @Override
    public List<String> defaultDocuments() {
        if (this.siteConfig == null) {
            return null;
        }
        return Collections.unmodifiableList(this.siteConfig.defaultDocuments());
    }

    @Override
    public NetFrameworkVersion netFrameworkVersion() {
        if (this.siteConfig == null) {
            return null;
        }
        return NetFrameworkVersion.fromString(this.siteConfig.netFrameworkVersion());
    }

    @Override
    public PhpVersion phpVersion() {
        if (this.siteConfig == null || this.siteConfig.phpVersion() == null) {
            return PhpVersion.OFF;
        }
        return PhpVersion.fromString(this.siteConfig.phpVersion());
    }

    @Override
    public PythonVersion pythonVersion() {
        if (this.siteConfig == null || this.siteConfig.pythonVersion() == null) {
            return PythonVersion.OFF;
        }
        return PythonVersion.fromString(this.siteConfig.pythonVersion());
    }

    @Override
    public String nodeVersion() {
        if (this.siteConfig == null) {
            return null;
        }
        return this.siteConfig.nodeVersion();
    }

    @Override
    public boolean remoteDebuggingEnabled() {
        if (this.siteConfig == null) {
            return false;
        }
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)this.siteConfig.remoteDebuggingEnabled());
    }

    @Override
    public RemoteVisualStudioVersion remoteDebuggingVersion() {
        if (this.siteConfig == null) {
            return null;
        }
        return RemoteVisualStudioVersion.fromString(this.siteConfig.remoteDebuggingVersion());
    }

    @Override
    public boolean webSocketsEnabled() {
        if (this.siteConfig == null) {
            return false;
        }
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)this.siteConfig.webSocketsEnabled());
    }

    @Override
    public boolean alwaysOn() {
        if (this.siteConfig == null) {
            return false;
        }
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)this.siteConfig.alwaysOn());
    }

    @Override
    public JavaVersion javaVersion() {
        if (this.siteConfig == null || this.siteConfig.javaVersion() == null) {
            return JavaVersion.OFF;
        }
        return JavaVersion.fromString(this.siteConfig.javaVersion());
    }

    @Override
    public String javaContainer() {
        if (this.siteConfig == null) {
            return null;
        }
        return this.siteConfig.javaContainer();
    }

    @Override
    public String javaContainerVersion() {
        if (this.siteConfig == null) {
            return null;
        }
        return this.siteConfig.javaContainerVersion();
    }

    @Override
    public ManagedPipelineMode managedPipelineMode() {
        if (this.siteConfig == null) {
            return null;
        }
        return this.siteConfig.managedPipelineMode();
    }

    @Override
    public PlatformArchitecture platformArchitecture() {
        if (this.siteConfig.use32BitWorkerProcess().booleanValue()) {
            return PlatformArchitecture.X86;
        }
        return PlatformArchitecture.X64;
    }

    @Override
    public String linuxFxVersion() {
        if (this.siteConfig == null) {
            return null;
        }
        return this.siteConfig.linuxFxVersion();
    }

    @Override
    public String windowsFxVersion() {
        if (this.siteConfig == null) {
            return null;
        }
        return this.siteConfig.windowsFxVersion();
    }

    @Override
    public String autoSwapSlotName() {
        if (this.siteConfig == null) {
            return null;
        }
        return this.siteConfig.autoSwapSlotName();
    }

    @Override
    public boolean httpsOnly() {
        return this.webSiteBase.httpsOnly();
    }

    @Override
    public FtpsState ftpsState() {
        if (this.siteConfig == null) {
            return null;
        }
        return this.siteConfig.ftpsState();
    }

    @Override
    public List<VirtualApplication> virtualApplications() {
        if (this.siteConfig == null) {
            return null;
        }
        return this.siteConfig.virtualApplications();
    }

    @Override
    public boolean http20Enabled() {
        if (this.siteConfig == null) {
            return false;
        }
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)this.siteConfig.http20Enabled());
    }

    @Override
    public boolean localMySqlEnabled() {
        if (this.siteConfig == null) {
            return false;
        }
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)this.siteConfig.localMySqlEnabled());
    }

    @Override
    public ScmType scmType() {
        if (this.siteConfig == null) {
            return null;
        }
        return this.siteConfig.scmType();
    }

    @Override
    public String documentRoot() {
        if (this.siteConfig == null) {
            return null;
        }
        return this.siteConfig.documentRoot();
    }

    @Override
    public SupportedTlsVersions minTlsVersion() {
        if (this.siteConfig == null) {
            return null;
        }
        return this.siteConfig.minTlsVersion();
    }

    @Override
    public List<IpSecurityRestriction> ipSecurityRules() {
        if (this.siteConfig == null || this.siteConfig.ipSecurityRestrictions() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.siteConfig.ipSecurityRestrictions());
    }

    @Override
    public OperatingSystem operatingSystem() {
        if (((SiteInner)((Object)this.innerModel())).kind() != null && ((SiteInner)((Object)this.innerModel())).kind().toLowerCase(Locale.ROOT).contains("linux")) {
            return OperatingSystem.LINUX;
        }
        return OperatingSystem.WINDOWS;
    }

    @Override
    public String systemAssignedManagedServiceIdentityTenantId() {
        if (((SiteInner)((Object)this.innerModel())).identity() == null) {
            return null;
        }
        return ((SiteInner)((Object)this.innerModel())).identity().tenantId();
    }

    @Override
    public String systemAssignedManagedServiceIdentityPrincipalId() {
        if (((SiteInner)((Object)this.innerModel())).identity() == null) {
            return null;
        }
        return ((SiteInner)((Object)this.innerModel())).identity().principalId();
    }

    @Override
    public Set<String> userAssignedManagedServiceIdentityIds() {
        if (((SiteInner)((Object)this.innerModel())).identity() == null) {
            return null;
        }
        return ((SiteInner)((Object)this.innerModel())).identity().userAssignedIdentities().keySet();
    }

    @Override
    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> diagnosticLogsConfig() {
        return this.diagnosticLogs;
    }

    @Override
    public InputStream streamApplicationLogs() {
        return this.pipeObservableToInputStream(this.streamApplicationLogsAsync());
    }

    @Override
    public Flux<String> streamApplicationLogsAsync() {
        return this.kuduClient.streamApplicationLogsAsync();
    }

    @Override
    public InputStream streamHttpLogs() {
        return this.pipeObservableToInputStream(this.streamHttpLogsAsync());
    }

    @Override
    public Flux<String> streamHttpLogsAsync() {
        return this.kuduClient.streamHttpLogsAsync();
    }

    @Override
    public InputStream streamTraceLogs() {
        return this.pipeObservableToInputStream(this.streamTraceLogsAsync());
    }

    @Override
    public Flux<String> streamTraceLogsAsync() {
        return this.kuduClient.streamTraceLogsAsync();
    }

    @Override
    public InputStream streamDeploymentLogs() {
        return this.pipeObservableToInputStream(this.streamDeploymentLogsAsync());
    }

    @Override
    public Flux<String> streamDeploymentLogsAsync() {
        return this.kuduClient.streamDeploymentLogsAsync();
    }

    @Override
    public InputStream streamAllLogs() {
        return this.pipeObservableToInputStream(this.streamAllLogsAsync());
    }

    @Override
    public Flux<String> streamAllLogsAsync() {
        return this.kuduClient.streamAllLogsAsync();
    }

    private InputStream pipeObservableToInputStream(Flux<String> observable) {
        PipedInputStreamWithCallback in = new PipedInputStreamWithCallback();
        PipedOutputStream out = new PipedOutputStream();
        try {
            in.connect(out);
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
        Disposable subscription = observable.subscribeOn(Schedulers.boundedElastic()).subscribe(s -> {
            try {
                out.write(s.getBytes(StandardCharsets.UTF_8));
                out.write(10);
                out.flush();
            }
            catch (IOException e) {
                throw this.logger.logExceptionAsError(new RuntimeException(e));
            }
        });
        in.addCallback(() -> {
            subscription.dispose();
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return in;
    }

    @Override
    public Map<String, AppSetting> getAppSettings() {
        return (Map)this.getAppSettingsAsync().block();
    }

    @Override
    public Mono<Map<String, AppSetting>> getAppSettingsAsync() {
        return Mono.zip(this.listAppSettings(), this.listSlotConfigurations(), (appSettingsInner, slotConfigs) -> appSettingsInner.properties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new AppSettingImpl((String)entry.getKey(), (String)entry.getValue(), slotConfigs.appSettingNames() != null && slotConfigs.appSettingNames().contains(entry.getKey())))));
    }

    @Override
    public Map<String, ConnectionString> getConnectionStrings() {
        return (Map)this.getConnectionStringsAsync().block();
    }

    @Override
    public Mono<Map<String, ConnectionString>> getConnectionStringsAsync() {
        return Mono.zip(this.listConnectionStrings(), this.listSlotConfigurations(), (connectionStringsInner, slotConfigs) -> connectionStringsInner.properties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ConnectionStringImpl((String)entry.getKey(), (ConnStringValueTypePair)entry.getValue(), slotConfigs.connectionStringNames() != null && slotConfigs.connectionStringNames().contains(entry.getKey())))));
    }

    @Override
    public WebAppAuthentication getAuthenticationConfig() {
        return (WebAppAuthentication)this.getAuthenticationConfigAsync().block();
    }

    @Override
    public Mono<WebAppAuthentication> getAuthenticationConfigAsync() {
        return this.getAuthentication().map(siteAuthSettingsInner -> new WebAppAuthenticationImpl((SiteAuthSettingsInner)((Object)siteAuthSettingsInner), this));
    }

    abstract Mono<SiteInner> createOrUpdateInner(SiteInner var1);

    abstract Mono<SiteInner> updateInner(SitePatchResourceInner var1);

    abstract Mono<SiteInner> getInner();

    abstract Mono<SiteConfigResourceInner> getConfigInner();

    abstract Mono<SiteConfigResourceInner> createOrUpdateSiteConfig(SiteConfigResourceInner var1);

    abstract Mono<Void> deleteHostnameBinding(String var1);

    abstract Mono<StringDictionaryInner> listAppSettings();

    abstract Mono<StringDictionaryInner> updateAppSettings(StringDictionaryInner var1);

    abstract Mono<ConnectionStringDictionaryInner> listConnectionStrings();

    abstract Mono<ConnectionStringDictionaryInner> updateConnectionStrings(ConnectionStringDictionaryInner var1);

    abstract Mono<SlotConfigNamesResourceInner> listSlotConfigurations();

    abstract Mono<SlotConfigNamesResourceInner> updateSlotConfigurations(SlotConfigNamesResourceInner var1);

    abstract Mono<SiteSourceControlInner> createOrUpdateSourceControl(SiteSourceControlInner var1);

    abstract Mono<Void> deleteSourceControl();

    abstract Mono<SiteAuthSettingsInner> updateAuthentication(SiteAuthSettingsInner var1);

    abstract Mono<SiteAuthSettingsInner> getAuthentication();

    abstract Mono<MSDeployStatusInner> createMSDeploy(MSDeploy var1);

    abstract Mono<SiteLogsConfigInner> updateDiagnosticLogsConfig(SiteLogsConfigInner var1);

    public void beforeGroupCreateOrUpdate() {
        IndexableTaskItem rootTaskItem;
        if (this.hostNameSslStateMap.size() > 0) {
            ((SiteInner)((Object)this.innerModel())).withHostnameSslStates(new ArrayList<HostnameSslState>(this.hostNameSslStateMap.values()));
        }
        IndexableTaskItem lastTaskItem = rootTaskItem = WebAppBaseImpl.wrapTask(context -> this.submitHostNameBindings().flatMap(fluentT -> this.submitSslBindings((SiteInner)((Object)((Object)((Object)fluentT.innerModel()))))));
        lastTaskItem = WebAppBaseImpl.sequentialTask(lastTaskItem, context -> this.submitSiteConfig());
        lastTaskItem = WebAppBaseImpl.sequentialTask(lastTaskItem, context -> this.submitMetadata().flatMap(ignored -> this.submitAppSettings().mergeWith(this.submitConnectionStrings()).last()).flatMap(ignored -> this.submitStickiness()));
        lastTaskItem = WebAppBaseImpl.sequentialTask(lastTaskItem, context -> this.submitSourceControlToDelete().flatMap(ignored -> this.submitSourceControlToCreate()));
        lastTaskItem = WebAppBaseImpl.sequentialTask(lastTaskItem, context -> this.submitAuthentication());
        lastTaskItem = WebAppBaseImpl.sequentialTask(lastTaskItem, context -> this.submitLogConfiguration());
        if (this.msiHandler != null) {
            WebAppBaseImpl.sequentialTask(lastTaskItem, this.msiHandler);
        }
        this.addPostRunDependent((TaskGroup.HasTaskGroup)rootTaskItem);
    }

    private static IndexableTaskItem wrapTask(FunctionalTaskItem taskItem) {
        return IndexableTaskItem.create((FunctionalTaskItem)taskItem);
    }

    private static IndexableTaskItem sequentialTask(IndexableTaskItem taskItem1, FunctionalTaskItem taskItem2) {
        IndexableTaskItem taskItem = IndexableTaskItem.create((FunctionalTaskItem)taskItem2);
        taskItem1.addPostRunDependent((TaskGroup.HasTaskGroup)taskItem);
        return taskItem;
    }

    public Mono<FluentT> createResourceAsync() {
        this.webAppMsiHandler.processCreatedExternalIdentities();
        this.webAppMsiHandler.handleExternalIdentities();
        return this.submitSite((SiteInner)((Object)this.innerModel())).map(siteInner -> {
            this.setInner((SiteInner)((Object)siteInner));
            return this;
        });
    }

    public Mono<FluentT> updateResourceAsync() {
        SiteInner siteInner = (SiteInner)((Object)this.innerModel());
        SitePatchResourceInner siteUpdate = new SitePatchResourceInner();
        siteUpdate.withHostnameSslStates(siteInner.hostnameSslStates());
        siteUpdate.withKind(siteInner.kind());
        siteUpdate.withEnabled(siteInner.enabled());
        siteUpdate.withServerFarmId(siteInner.serverFarmId());
        siteUpdate.withReserved(siteInner.reserved());
        siteUpdate.withIsXenon(siteInner.isXenon());
        siteUpdate.withHyperV(siteInner.hyperV());
        siteUpdate.withScmSiteAlsoStopped(siteInner.scmSiteAlsoStopped());
        siteUpdate.withHostingEnvironmentProfile(siteInner.hostingEnvironmentProfile());
        siteUpdate.withClientAffinityEnabled(siteInner.clientAffinityEnabled());
        siteUpdate.withClientCertEnabled(siteInner.clientCertEnabled());
        siteUpdate.withClientCertExclusionPaths(siteInner.clientCertExclusionPaths());
        siteUpdate.withHostNamesDisabled(siteInner.hostNamesDisabled());
        siteUpdate.withContainerSize(siteInner.containerSize());
        siteUpdate.withDailyMemoryTimeQuota(siteInner.dailyMemoryTimeQuota());
        siteUpdate.withCloningInfo(siteInner.cloningInfo());
        siteUpdate.withHttpsOnly(siteInner.httpsOnly());
        siteUpdate.withRedundancyMode(siteInner.redundancyMode());
        siteUpdate.withPublicNetworkAccess(siteInner.publicNetworkAccess());
        siteUpdate.withDnsConfiguration(siteInner.dnsConfiguration());
        siteUpdate.withClientAffinityProxyEnabled(siteInner.clientAffinityProxyEnabled());
        siteUpdate.withClientCertMode(siteInner.clientCertMode());
        siteUpdate.withCustomDomainVerificationId(siteInner.customDomainVerificationId());
        siteUpdate.withStorageAccountRequired(siteInner.storageAccountRequired());
        siteUpdate.withKeyVaultReferenceIdentity(siteInner.keyVaultReferenceIdentity());
        siteUpdate.withVirtualNetworkSubnetId(siteInner.virtualNetworkSubnetId());
        this.webAppMsiHandler.handleExternalIdentities(siteUpdate);
        return this.submitSite(siteUpdate).map(siteInner1 -> {
            this.setInner((SiteInner)((Object)siteInner1));
            this.webAppMsiHandler.clear();
            return this;
        });
    }

    public Mono<Void> afterPostRunAsync(boolean isGroupFaulted) {
        if (!isGroupFaulted) {
            this.isInCreateMode = false;
            this.initializeKuduClient();
        }
        return Mono.fromCallable(() -> {
            this.normalizeProperties();
            return null;
        });
    }

    Mono<SiteInner> submitSite(SiteInner site) {
        site.withSiteConfig(new SiteConfigInner());
        return this.submitSiteWithoutSiteConfig(site);
    }

    Mono<SiteInner> submitSiteWithoutSiteConfig(SiteInner site) {
        return this.createOrUpdateInner(site).map(siteInner -> {
            site.withSiteConfig(null);
            return siteInner;
        });
    }

    Mono<SiteInner> submitSite(SitePatchResourceInner siteUpdate) {
        return this.updateInner(siteUpdate).map(siteInner -> {
            siteInner.withSiteConfig(null);
            return siteInner;
        });
    }

    Mono<FluentT> submitHostNameBindings() {
        ArrayList<Object> bindingObservables = new ArrayList<Object>();
        for (HostnameBindingImpl<FluentT, FluentImplT> hostnameBindingImpl : this.hostNameBindingsToCreate.values()) {
            bindingObservables.add(hostnameBindingImpl.createAsync());
        }
        for (String string : this.hostNameBindingsToDelete) {
            bindingObservables.add(this.deleteHostnameBinding(string).then(Mono.empty()));
        }
        if (bindingObservables.isEmpty()) {
            return Mono.just((Object)this);
        }
        return Flux.zip(bindingObservables, ignored -> this).last().onErrorResume(throwable -> {
            if (throwable instanceof HttpResponseException && ((HttpResponseException)throwable).getResponse().getStatusCode() == 400) {
                return this.submitSite((SiteInner)((Object)((Object)((Object)this.innerModel())))).flatMap(ignored -> Flux.zip((Iterable)bindingObservables, ignored1 -> this).last());
            }
            return Mono.error((Throwable)throwable);
        }).flatMap(WebAppBaseImpl::refreshAsync);
    }

    Mono<Indexable> submitSslBindings(SiteInner site) {
        ArrayList<Mono<AppServiceCertificate>> certs = new ArrayList<Mono<AppServiceCertificate>>();
        for (HostnameSslBindingImpl<FluentT, FluentImplT> binding : this.sslBindingsToCreate.values()) {
            certs.add(binding.newCertificate());
            this.hostNameSslStateMap.put(((HostnameSslState)binding.innerModel()).name(), ((HostnameSslState)binding.innerModel()).withToUpdate(true));
        }
        if (certs.isEmpty()) {
            return Mono.just((Object)this);
        }
        site.withHostnameSslStates(new ArrayList<HostnameSslState>(this.hostNameSslStateMap.values()));
        return Flux.zip(certs, ignored -> site).last().flatMap(this::createOrUpdateInner).map(siteInner -> {
            this.setInner((SiteInner)((Object)siteInner));
            return this;
        });
    }

    Mono<Indexable> submitSiteConfig() {
        if (this.siteConfig == null) {
            return Mono.just((Object)this);
        }
        if (this.siteConfig.azureStorageAccounts() != null && this.siteConfig.azureStorageAccounts().values().stream().filter(Objects::nonNull).anyMatch(v -> v.accessKey() == null)) {
            this.siteConfig.withAzureStorageAccounts(null);
        }
        return this.createOrUpdateSiteConfig(this.siteConfig).flatMap(returnedSiteConfig -> {
            this.siteConfig = returnedSiteConfig;
            return Mono.just((Object)this);
        });
    }

    Mono<Indexable> submitAppSettings() {
        Mono observable = Mono.just((Object)this);
        if (!this.appSettingsToAdd.isEmpty() || !this.appSettingsToRemove.isEmpty()) {
            observable = this.listAppSettings().switchIfEmpty(Mono.just((Object)((Object)new StringDictionaryInner()))).flatMap(stringDictionaryInner -> {
                if (stringDictionaryInner.properties() == null) {
                    stringDictionaryInner.withProperties(new HashMap<String, String>());
                }
                for (String appSettingKey : this.appSettingsToRemove) {
                    stringDictionaryInner.properties().remove(appSettingKey);
                }
                stringDictionaryInner.properties().putAll(this.appSettingsToAdd);
                return this.updateAppSettings((StringDictionaryInner)((Object)stringDictionaryInner));
            }).map(ignored -> this);
        }
        return observable;
    }

    Mono<Indexable> submitMetadata() {
        return Mono.just((Object)this);
    }

    Mono<Indexable> submitConnectionStrings() {
        Mono observable = Mono.just((Object)this);
        if (!this.connectionStringsToAdd.isEmpty() || !this.connectionStringsToRemove.isEmpty()) {
            observable = this.listConnectionStrings().switchIfEmpty(Mono.just((Object)((Object)new ConnectionStringDictionaryInner()))).flatMap(dictionaryInner -> {
                if (dictionaryInner.properties() == null) {
                    dictionaryInner.withProperties(new HashMap<String, ConnStringValueTypePair>());
                }
                for (String connectionString : this.connectionStringsToRemove) {
                    dictionaryInner.properties().remove(connectionString);
                }
                dictionaryInner.properties().putAll(this.connectionStringsToAdd);
                return this.updateConnectionStrings((ConnectionStringDictionaryInner)((Object)dictionaryInner));
            }).map(ignored -> this);
        }
        return observable;
    }

    Mono<Indexable> submitStickiness() {
        Mono observable = Mono.just((Object)this);
        if (!this.appSettingStickiness.isEmpty() || !this.connectionStringStickiness.isEmpty()) {
            observable = this.listSlotConfigurations().switchIfEmpty(Mono.just((Object)((Object)new SlotConfigNamesResourceInner()))).flatMap(slotConfigNamesResourceInner -> {
                if (slotConfigNamesResourceInner.appSettingNames() == null) {
                    slotConfigNamesResourceInner.withAppSettingNames(new ArrayList<String>());
                }
                if (slotConfigNamesResourceInner.connectionStringNames() == null) {
                    slotConfigNamesResourceInner.withConnectionStringNames(new ArrayList<String>());
                }
                HashSet<String> stickyAppSettingKeys = new HashSet<String>(slotConfigNamesResourceInner.appSettingNames());
                HashSet<String> stickyConnectionStringNames = new HashSet<String>(slotConfigNamesResourceInner.connectionStringNames());
                for (Map.Entry<String, Boolean> stickiness : this.appSettingStickiness.entrySet()) {
                    if (stickiness.getValue().booleanValue()) {
                        stickyAppSettingKeys.add(stickiness.getKey());
                        continue;
                    }
                    stickyAppSettingKeys.remove(stickiness.getKey());
                }
                for (Map.Entry<String, Boolean> stickiness : this.connectionStringStickiness.entrySet()) {
                    if (stickiness.getValue().booleanValue()) {
                        stickyConnectionStringNames.add(stickiness.getKey());
                        continue;
                    }
                    stickyConnectionStringNames.remove(stickiness.getKey());
                }
                slotConfigNamesResourceInner.withAppSettingNames(new ArrayList<String>(stickyAppSettingKeys));
                slotConfigNamesResourceInner.withConnectionStringNames(new ArrayList<String>(stickyConnectionStringNames));
                return this.updateSlotConfigurations((SlotConfigNamesResourceInner)((Object)slotConfigNamesResourceInner));
            }).map(ignored -> this);
        }
        return observable;
    }

    Mono<Indexable> submitSourceControlToCreate() {
        if (this.sourceControl == null || this.sourceControlToDelete) {
            return Mono.just((Object)this);
        }
        return this.sourceControl.registerGithubAccessToken().then(this.createOrUpdateSourceControl((SiteSourceControlInner)((Object)this.sourceControl.innerModel()))).delayElement(ResourceManagerUtils.InternalRuntimeContext.getDelayDuration((Duration)Duration.ofSeconds(30L))).map(ignored -> this);
    }

    Mono<Indexable> submitSourceControlToDelete() {
        if (!this.sourceControlToDelete) {
            return Mono.just((Object)this);
        }
        return this.deleteSourceControl().map(ignored -> this);
    }

    Mono<Indexable> submitAuthentication() {
        if (!this.authenticationToUpdate) {
            return Mono.just((Object)this);
        }
        return this.updateAuthentication((SiteAuthSettingsInner)((Object)this.authentication.innerModel())).map(siteAuthSettingsInner -> {
            this.authentication = new WebAppAuthenticationImpl((SiteAuthSettingsInner)((Object)siteAuthSettingsInner), this);
            return this;
        });
    }

    Mono<Indexable> submitLogConfiguration() {
        if (!this.diagnosticLogsToUpdate) {
            return Mono.just((Object)this);
        }
        return this.updateDiagnosticLogsConfig((SiteLogsConfigInner)((Object)this.diagnosticLogs.innerModel())).map(siteLogsConfigInner -> {
            this.diagnosticLogs = new WebAppDiagnosticLogsImpl((SiteLogsConfigInner)((Object)siteLogsConfigInner), this);
            return this;
        });
    }

    @Override
    public WebDeploymentImpl<FluentT, FluentImplT> deploy() {
        return new WebDeploymentImpl(this);
    }

    WebAppBaseImpl<FluentT, FluentImplT> withNewHostNameSslBinding(HostnameSslBindingImpl<FluentT, FluentImplT> hostNameSslBinding) {
        this.sslBindingsToCreate.put(hostNameSslBinding.name(), hostNameSslBinding);
        return this;
    }

    public FluentImplT withManagedHostnameBindings(AppServiceDomain domain, String ... hostnames) {
        for (String hostname : hostnames) {
            if ("@".equals(hostname) || hostname.equalsIgnoreCase(domain.name())) {
                ((HostnameBindingImpl)((HostnameBindingImpl)((HostnameBindingImpl)((HostnameBindingImpl)this.defineHostnameBinding()).withAzureManagedDomain(domain)).withSubDomain(hostname)).withDnsRecordType(CustomHostnameDnsRecordType.A)).attach();
                continue;
            }
            ((HostnameBindingImpl)((HostnameBindingImpl)((HostnameBindingImpl)((HostnameBindingImpl)this.defineHostnameBinding()).withAzureManagedDomain(domain)).withSubDomain(hostname)).withDnsRecordType(CustomHostnameDnsRecordType.CNAME)).attach();
        }
        return (FluentImplT)this;
    }

    public HostnameBindingImpl<FluentT, FluentImplT> defineHostnameBinding() {
        HostnameBindingInner inner = new HostnameBindingInner();
        inner.withSiteName(this.name());
        inner.withAzureResourceType(AzureResourceType.WEBSITE);
        inner.withAzureResourceName(this.name());
        inner.withHostnameType(HostnameType.VERIFIED);
        return new HostnameBindingImpl(inner, this);
    }

    public FluentImplT withThirdPartyHostnameBinding(String domain, String ... hostnames) {
        for (String hostname : hostnames) {
            ((HostnameBindingImpl)((HostnameBindingImpl)((HostnameBindingImpl)((HostnameBindingImpl)this.defineHostnameBinding()).withThirdPartyDomain(domain)).withSubDomain(hostname)).withDnsRecordType(CustomHostnameDnsRecordType.CNAME)).attach();
        }
        return (FluentImplT)this;
    }

    public FluentImplT withoutHostnameBinding(String hostname) {
        this.hostNameBindingsToDelete.add(hostname);
        return (FluentImplT)this;
    }

    public FluentImplT withoutSslBinding(String hostname) {
        if (this.hostNameSslStateMap.containsKey(hostname)) {
            this.hostNameSslStateMap.get(hostname).withSslState(SslState.DISABLED).withToUpdate(true);
        }
        return (FluentImplT)this;
    }

    FluentImplT withHostNameBinding(HostnameBindingImpl<FluentT, FluentImplT> hostNameBinding) {
        this.hostNameBindingsToCreate.put(hostNameBinding.name(), hostNameBinding);
        return (FluentImplT)this;
    }

    public FluentImplT withAppDisabledOnCreation() {
        ((SiteInner)((Object)this.innerModel())).withEnabled(false);
        return (FluentImplT)this;
    }

    public FluentImplT withScmSiteAlsoStopped(boolean scmSiteAlsoStopped) {
        ((SiteInner)((Object)this.innerModel())).withScmSiteAlsoStopped(scmSiteAlsoStopped);
        return (FluentImplT)this;
    }

    public FluentImplT withClientAffinityEnabled(boolean enabled) {
        ((SiteInner)((Object)this.innerModel())).withClientAffinityEnabled(enabled);
        return (FluentImplT)this;
    }

    public FluentImplT withClientCertEnabled(boolean enabled) {
        ((SiteInner)((Object)this.innerModel())).withClientCertEnabled(enabled);
        return (FluentImplT)this;
    }

    public HostnameSslBindingImpl<FluentT, FluentImplT> defineSslBinding() {
        return new HostnameSslBindingImpl(new HostnameSslState(), this);
    }

    public FluentImplT withNetFrameworkVersion(NetFrameworkVersion version) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withNetFrameworkVersion(version.toString());
        return (FluentImplT)this;
    }

    public FluentImplT withPhpVersion(PhpVersion version) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withPhpVersion(version.toString());
        return (FluentImplT)this;
    }

    public FluentImplT withoutPhp() {
        return (FluentImplT)this.withPhpVersion(PhpVersion.fromString(""));
    }

    public FluentImplT withJavaVersion(JavaVersion version) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withJavaVersion(version.toString());
        return (FluentImplT)this;
    }

    public FluentImplT withoutJava() {
        return (FluentImplT)((WebAppBaseImpl)this.withJavaVersion(JavaVersion.fromString(""))).withWebContainer(WebContainer.fromString(""));
    }

    public FluentImplT withWebContainer(WebContainer webContainer) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        if (webContainer == null) {
            this.siteConfig.withJavaContainer(null);
            this.siteConfig.withJavaContainerVersion(null);
        } else if (webContainer.toString().isEmpty()) {
            this.siteConfig.withJavaContainer("");
            this.siteConfig.withJavaContainerVersion("");
        } else {
            String[] containerInfo = webContainer.toString().split(" ");
            this.siteConfig.withJavaContainer(containerInfo[0]);
            this.siteConfig.withJavaContainerVersion(containerInfo[1]);
        }
        return (FluentImplT)this;
    }

    public FluentImplT withPythonVersion(PythonVersion version) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withPythonVersion(version.toString());
        return (FluentImplT)this;
    }

    public FluentImplT withoutPython() {
        return (FluentImplT)this.withPythonVersion(PythonVersion.fromString(""));
    }

    public FluentImplT withPlatformArchitecture(PlatformArchitecture platform) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withUse32BitWorkerProcess(platform.equals((Object)PlatformArchitecture.X86));
        return (FluentImplT)this;
    }

    public FluentImplT withWebSocketsEnabled(boolean enabled) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withWebSocketsEnabled(enabled);
        return (FluentImplT)this;
    }

    public FluentImplT withWebAppAlwaysOn(boolean alwaysOn) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withAlwaysOn(alwaysOn);
        return (FluentImplT)this;
    }

    public FluentImplT withManagedPipelineMode(ManagedPipelineMode managedPipelineMode) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withManagedPipelineMode(managedPipelineMode);
        return (FluentImplT)this;
    }

    public FluentImplT withAutoSwapSlotName(String slotName) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withAutoSwapSlotName(slotName);
        return (FluentImplT)this;
    }

    public FluentImplT withRemoteDebuggingEnabled(RemoteVisualStudioVersion remoteVisualStudioVersion) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withRemoteDebuggingEnabled(true);
        this.siteConfig.withRemoteDebuggingVersion(remoteVisualStudioVersion.toString());
        return (FluentImplT)this;
    }

    public FluentImplT withRemoteDebuggingDisabled() {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withRemoteDebuggingEnabled(false);
        return (FluentImplT)this;
    }

    public FluentImplT withDefaultDocument(String document) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        if (this.siteConfig.defaultDocuments() == null) {
            this.siteConfig.withDefaultDocuments(new ArrayList<String>());
        }
        this.siteConfig.defaultDocuments().add(document);
        return (FluentImplT)this;
    }

    public FluentImplT withDefaultDocuments(List<String> documents) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        if (this.siteConfig.defaultDocuments() == null) {
            this.siteConfig.withDefaultDocuments(new ArrayList<String>());
        }
        this.siteConfig.defaultDocuments().addAll(documents);
        return (FluentImplT)this;
    }

    public FluentImplT withoutDefaultDocument(String document) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        if (this.siteConfig.defaultDocuments() != null) {
            this.siteConfig.defaultDocuments().remove(document);
        }
        return (FluentImplT)this;
    }

    public FluentImplT withHttpsOnly(boolean httpsOnly) {
        ((SiteInner)((Object)this.innerModel())).withHttpsOnly(httpsOnly);
        return (FluentImplT)this;
    }

    public FluentImplT withHttp20Enabled(boolean http20Enabled) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withHttp20Enabled(http20Enabled);
        return (FluentImplT)this;
    }

    public FluentImplT withFtpsState(FtpsState ftpsState) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withFtpsState(ftpsState);
        return (FluentImplT)this;
    }

    public FluentImplT withVirtualApplications(List<VirtualApplication> virtualApplications) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withVirtualApplications(virtualApplications);
        return (FluentImplT)this;
    }

    public FluentImplT withMinTlsVersion(SupportedTlsVersions minTlsVersion) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withMinTlsVersion(minTlsVersion);
        return (FluentImplT)this;
    }

    public FluentImplT withAppSetting(String key, String value) {
        this.appSettingsToAdd.put(key, value);
        return (FluentImplT)this;
    }

    public FluentImplT withAppSettings(Map<String, String> settings) {
        this.appSettingsToAdd.putAll(settings);
        return (FluentImplT)this;
    }

    public FluentImplT withStickyAppSetting(String key, String value) {
        this.withAppSetting(key, value);
        return (FluentImplT)this.withAppSettingStickiness(key, true);
    }

    public FluentImplT withStickyAppSettings(Map<String, String> settings) {
        this.withAppSettings((Map)settings);
        for (String key : settings.keySet()) {
            this.appSettingStickiness.put(key, true);
        }
        return (FluentImplT)this;
    }

    public FluentImplT withoutAppSetting(String key) {
        this.appSettingsToRemove.add(key);
        this.appSettingStickiness.remove(key);
        return (FluentImplT)this;
    }

    public FluentImplT withAppSettingStickiness(String key, boolean sticky) {
        this.appSettingStickiness.put(key, sticky);
        return (FluentImplT)this;
    }

    public FluentImplT withConnectionString(String name, String value, ConnectionStringType type) {
        this.connectionStringsToAdd.put(name, new ConnStringValueTypePair().withValue(value).withType(type));
        return (FluentImplT)this;
    }

    public FluentImplT withStickyConnectionString(String name, String value, ConnectionStringType type) {
        this.connectionStringsToAdd.put(name, new ConnStringValueTypePair().withValue(value).withType(type));
        this.connectionStringStickiness.put(name, true);
        return (FluentImplT)this;
    }

    public FluentImplT withoutConnectionString(String name) {
        this.connectionStringsToRemove.add(name);
        this.connectionStringStickiness.remove(name);
        return (FluentImplT)this;
    }

    public FluentImplT withConnectionStringStickiness(String name, boolean stickiness) {
        this.connectionStringStickiness.put(name, stickiness);
        return (FluentImplT)this;
    }

    void withSourceControl(WebAppSourceControlImpl<FluentT, FluentImplT> sourceControl) {
        this.sourceControl = sourceControl;
    }

    public WebAppSourceControlImpl<FluentT, FluentImplT> defineSourceControl() {
        SiteSourceControlInner sourceControlInner = new SiteSourceControlInner();
        return new WebAppSourceControlImpl(sourceControlInner, this);
    }

    public FluentImplT withLocalGitSourceControl() {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withScmType(ScmType.LOCAL_GIT);
        return (FluentImplT)this;
    }

    public FluentImplT withoutSourceControl() {
        this.sourceControlToDelete = true;
        return (FluentImplT)this;
    }

    void withAuthentication(WebAppAuthenticationImpl<FluentT, FluentImplT> authentication) {
        this.authentication = authentication;
        this.authenticationToUpdate = true;
    }

    void withDiagnosticLogs(WebAppDiagnosticLogsImpl<FluentT, FluentImplT> diagnosticLogs) {
        this.diagnosticLogs = diagnosticLogs;
        this.diagnosticLogsToUpdate = true;
    }

    public Mono<FluentT> refreshAsync() {
        return super.refreshAsync().flatMap(fluentT -> this.getConfigInner().map(returnedSiteConfig -> {
            this.siteConfig = returnedSiteConfig;
            return fluentT;
        }));
    }

    protected Mono<SiteInner> getInnerAsync() {
        return this.getInner();
    }

    public WebAppAuthenticationImpl<FluentT, FluentImplT> defineAuthentication() {
        return new WebAppAuthenticationImpl(new SiteAuthSettingsInner().withEnabled(true), this);
    }

    public FluentImplT withoutAuthentication() {
        ((SiteAuthSettingsInner)((Object)this.authentication.innerModel())).withEnabled(false);
        this.authenticationToUpdate = true;
        return (FluentImplT)this;
    }

    public FluentImplT withContainerLoggingEnabled(int quotaInMB, int retentionDays) {
        return (FluentImplT)((WebAppDiagnosticLogsImpl)((WebAppDiagnosticLogsImpl)((WebAppDiagnosticLogsImpl)((WebAppDiagnosticLogsImpl)((WebAppDiagnosticLogsImpl)this.updateDiagnosticLogsConfiguration()).withWebServerLogging()).withWebServerLogsStoredOnFileSystem()).withWebServerFileSystemQuotaInMB(quotaInMB)).withLogRetentionDays(retentionDays)).attach();
    }

    public FluentImplT withContainerLoggingEnabled() {
        return (FluentImplT)this.withContainerLoggingEnabled(35, 0);
    }

    public FluentImplT withContainerLoggingDisabled() {
        return (FluentImplT)((WebAppDiagnosticLogsImpl)((WebAppDiagnosticLogsImpl)this.updateDiagnosticLogsConfiguration()).withoutWebServerLogging()).attach();
    }

    public FluentImplT withSystemAssignedManagedServiceIdentity() {
        this.webAppMsiHandler.withLocalManagedServiceIdentity();
        return (FluentImplT)this;
    }

    public FluentImplT withoutSystemAssignedManagedServiceIdentity() {
        this.webAppMsiHandler.withoutLocalManagedServiceIdentity();
        return (FluentImplT)this;
    }

    public FluentImplT withUserAssignedManagedServiceIdentity() {
        return (FluentImplT)this;
    }

    public FluentImplT withSystemAssignedIdentityBasedAccessTo(String resourceId, BuiltInRole role) {
        this.webAppMsiHandler.withAccessTo(resourceId, role);
        return (FluentImplT)this;
    }

    public FluentImplT withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(BuiltInRole role) {
        this.webAppMsiHandler.withAccessToCurrentResourceGroup(role);
        return (FluentImplT)this;
    }

    public FluentImplT withSystemAssignedIdentityBasedAccessTo(String resourceId, String roleDefinitionId) {
        this.webAppMsiHandler.withAccessTo(resourceId, roleDefinitionId);
        return (FluentImplT)this;
    }

    public FluentImplT withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(String roleDefinitionId) {
        this.webAppMsiHandler.withAccessToCurrentResourceGroup(roleDefinitionId);
        return (FluentImplT)this;
    }

    public FluentImplT withNewUserAssignedManagedServiceIdentity(Creatable<Identity> creatableIdentity) {
        this.webAppMsiHandler.withNewExternalManagedServiceIdentity(creatableIdentity);
        return (FluentImplT)this;
    }

    public FluentImplT withExistingUserAssignedManagedServiceIdentity(Identity identity) {
        this.webAppMsiHandler.withExistingExternalManagedServiceIdentity(identity);
        return (FluentImplT)this;
    }

    public FluentImplT withoutUserAssignedManagedServiceIdentity(String identityId) {
        this.webAppMsiHandler.withoutExternalManagedServiceIdentity(identityId);
        return (FluentImplT)this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> defineDiagnosticLogsConfiguration() {
        if (this.diagnosticLogs == null) {
            return new WebAppDiagnosticLogsImpl(new SiteLogsConfigInner(), this);
        }
        return this.diagnosticLogs;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> updateDiagnosticLogsConfiguration() {
        return this.defineDiagnosticLogsConfiguration();
    }

    @Override
    public ManagedServiceIdentity identity() {
        return this.webSiteBase.identity();
    }

    @Override
    public boolean hyperV() {
        return this.webSiteBase.hyperV();
    }

    @Override
    public HostingEnvironmentProfile hostingEnvironmentProfile() {
        return this.webSiteBase.hostingEnvironmentProfile();
    }

    @Override
    public Set<String> clientCertExclusionPaths() {
        return this.webSiteBase.clientCertExclusionPaths();
    }

    @Override
    public Set<String> possibleOutboundIpAddresses() {
        return this.webSiteBase.possibleOutboundIpAddresses();
    }

    @Override
    public int dailyMemoryTimeQuota() {
        return this.webSiteBase.dailyMemoryTimeQuota();
    }

    @Override
    public OffsetDateTime suspendedTill() {
        return this.webSiteBase.suspendedTill();
    }

    @Override
    public int maxNumberOfWorkers() {
        return this.webSiteBase.maxNumberOfWorkers();
    }

    @Override
    public SlotSwapStatus slotSwapStatus() {
        return this.webSiteBase.slotSwapStatus();
    }

    @Override
    public RedundancyMode redundancyMode() {
        return this.webSiteBase.redundancyMode();
    }

    protected void setAppFrameworkVersion(String fxVersion) {
        if (this.operatingSystem() == OperatingSystem.LINUX) {
            this.siteConfig.withLinuxFxVersion(fxVersion);
        } else {
            this.siteConfig.withWindowsFxVersion(fxVersion);
        }
    }

    public FluentImplT withAccessFromAllNetworks() {
        this.ensureIpSecurityRestrictions();
        this.siteConfig.withIpSecurityRestrictions(new ArrayList<IpSecurityRestriction>());
        return (FluentImplT)this;
    }

    public FluentImplT withAccessFromNetworkSubnet(String subnetId, int priority) {
        this.ensureIpSecurityRestrictions();
        this.siteConfig.ipSecurityRestrictions().add(new IpSecurityRestriction().withAction(IP_RESTRICTION_ACTION_ALLOW).withPriority(priority).withTag(IpFilterTag.DEFAULT).withVnetSubnetResourceId(subnetId));
        return (FluentImplT)this;
    }

    public FluentImplT withAccessFromIpAddress(String ipAddress, int priority) {
        String ipAddressCidr = ipAddress.contains("/") ? ipAddress : ipAddress + "/32";
        return (FluentImplT)this.withAccessFromIpAddressRange(ipAddressCidr, priority);
    }

    public FluentImplT withAccessFromIpAddressRange(String ipAddressCidr, int priority) {
        this.ensureIpSecurityRestrictions();
        this.siteConfig.ipSecurityRestrictions().add(new IpSecurityRestriction().withAction(IP_RESTRICTION_ACTION_ALLOW).withPriority(priority).withTag(IpFilterTag.DEFAULT).withIpAddress(ipAddressCidr));
        return (FluentImplT)this;
    }

    public FluentImplT withAccessRule(IpSecurityRestriction ipSecurityRule) {
        this.ensureIpSecurityRestrictions();
        this.siteConfig.ipSecurityRestrictions().add(ipSecurityRule);
        return (FluentImplT)this;
    }

    public FluentImplT withoutNetworkSubnetAccess(String subnetId) {
        if (this.siteConfig != null && this.siteConfig.ipSecurityRestrictions() != null) {
            this.siteConfig.withIpSecurityRestrictions(this.siteConfig.ipSecurityRestrictions().stream().filter(r -> !IP_RESTRICTION_ACTION_ALLOW.equalsIgnoreCase(r.action()) || IpFilterTag.DEFAULT != r.tag() || !subnetId.equalsIgnoreCase(r.vnetSubnetResourceId())).collect(Collectors.toList()));
        }
        return (FluentImplT)this;
    }

    public FluentImplT withoutIpAddressAccess(String ipAddress) {
        String ipAddressCidr = ipAddress.contains("/") ? ipAddress : ipAddress + "/32";
        return (FluentImplT)this.withoutIpAddressRangeAccess(ipAddressCidr);
    }

    public FluentImplT withoutIpAddressRangeAccess(String ipAddressCidr) {
        if (this.siteConfig != null && this.siteConfig.ipSecurityRestrictions() != null) {
            this.siteConfig.withIpSecurityRestrictions(this.siteConfig.ipSecurityRestrictions().stream().filter(r -> !IP_RESTRICTION_ACTION_ALLOW.equalsIgnoreCase(r.action()) || IpFilterTag.DEFAULT != r.tag() || !Objects.equals(ipAddressCidr, r.ipAddress())).collect(Collectors.toList()));
        }
        return (FluentImplT)this;
    }

    public FluentImplT enablePublicNetworkAccess() {
        if (Objects.isNull((Object)this.siteConfig)) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withPublicNetworkAccess("Enabled");
        ((SiteInner)((Object)this.innerModel())).withPublicNetworkAccess("Enabled");
        return (FluentImplT)this;
    }

    public FluentImplT disablePublicNetworkAccess() {
        if (Objects.isNull((Object)this.siteConfig)) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withPublicNetworkAccess("Disabled");
        ((SiteInner)((Object)this.innerModel())).withPublicNetworkAccess("Disabled");
        return (FluentImplT)this;
    }

    @Override
    public PublicNetworkAccess publicNetworkAccess() {
        return Objects.isNull(((SiteInner)((Object)this.innerModel())).publicNetworkAccess()) ? null : PublicNetworkAccess.fromString(((SiteInner)((Object)this.innerModel())).publicNetworkAccess());
    }

    public FluentImplT withContainerSize(int containerSize) {
        ((SiteInner)((Object)this.innerModel())).withContainerSize(containerSize);
        return (FluentImplT)this;
    }

    @Override
    public Map<String, String> getSiteAppSettings() {
        return (Map)this.getSiteAppSettingsAsync().block();
    }

    @Override
    public Mono<Map<String, String>> getSiteAppSettingsAsync() {
        return this.kuduClient.settings();
    }

    public FluentImplT withoutAccessRule(IpSecurityRestriction ipSecurityRule) {
        if (this.siteConfig != null && this.siteConfig.ipSecurityRestrictions() != null) {
            this.siteConfig.withIpSecurityRestrictions(this.siteConfig.ipSecurityRestrictions().stream().filter(r -> !Objects.equals(r.action(), ipSecurityRule.action()) || !Objects.equals((Object)r.tag(), (Object)ipSecurityRule.tag()) || !Objects.equals(r.ipAddress(), ipSecurityRule.ipAddress()) && !Objects.equals(r.vnetSubnetResourceId(), ipSecurityRule.vnetSubnetResourceId())).collect(Collectors.toList()));
        }
        return (FluentImplT)this;
    }

    private void ensureIpSecurityRestrictions() {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        if (this.siteConfig.ipSecurityRestrictions() == null) {
            this.siteConfig.withIpSecurityRestrictions(new ArrayList<IpSecurityRestriction>());
        }
    }

    private static class PipedInputStreamWithCallback
    extends PipedInputStream {
        private Runnable callback;

        private PipedInputStreamWithCallback() {
        }

        private void addCallback(Runnable action) {
            this.callback = action;
        }

        @Override
        public void close() throws IOException {
            this.callback.run();
            super.close();
        }
    }

    protected static final class PrivateEndpointConnectionImpl
    implements PrivateEndpointConnection {
        private final RemotePrivateEndpointConnectionArmResourceInner innerModel;
        private final PrivateEndpoint privateEndpoint;
        private final PrivateLinkServiceConnectionState privateLinkServiceConnectionState;
        private final PrivateEndpointConnectionProvisioningState provisioningState;

        protected PrivateEndpointConnectionImpl(RemotePrivateEndpointConnectionArmResourceInner innerModel) {
            this.innerModel = innerModel;
            PrivateEndpoint privateEndpoint = this.privateEndpoint = innerModel.privateEndpoint() == null ? null : new PrivateEndpoint(innerModel.privateEndpoint().id());
            this.privateLinkServiceConnectionState = innerModel.privateLinkServiceConnectionState() == null ? null : new PrivateLinkServiceConnectionState(innerModel.privateLinkServiceConnectionState().status() == null ? null : PrivateEndpointServiceConnectionStatus.fromString((String)innerModel.privateLinkServiceConnectionState().status()), innerModel.privateLinkServiceConnectionState().description(), innerModel.privateLinkServiceConnectionState().actionsRequired());
            this.provisioningState = innerModel.provisioningState() == null ? null : PrivateEndpointConnectionProvisioningState.fromString((String)innerModel.provisioningState());
        }

        public String id() {
            return this.innerModel.id();
        }

        public String name() {
            return this.innerModel.name();
        }

        public String type() {
            return this.innerModel.type();
        }

        public PrivateEndpoint privateEndpoint() {
            return this.privateEndpoint;
        }

        public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
            return this.privateLinkServiceConnectionState;
        }

        public PrivateEndpointConnectionProvisioningState provisioningState() {
            return this.provisioningState;
        }
    }

    protected static final class PrivateLinkResourceImpl
    implements com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateLinkResource {
        private final PrivateLinkResource innerModel;

        protected PrivateLinkResourceImpl(PrivateLinkResource innerModel) {
            this.innerModel = innerModel;
        }

        public String groupId() {
            return this.innerModel.properties().groupId();
        }

        public List<String> requiredMemberNames() {
            return Collections.unmodifiableList(this.innerModel.properties().requiredMembers());
        }

        public List<String> requiredDnsZoneNames() {
            return Collections.unmodifiableList(this.innerModel.properties().requiredZoneNames());
        }
    }
}

