/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.StaticSiteDatabaseConnectionConfigurationFileOverview;
import java.io.IOException;
import java.util.List;

public final class DatabaseConnectionOverview
implements JsonSerializable<DatabaseConnectionOverview> {
    private String resourceId;
    private String connectionIdentity;
    private String region;
    private List<StaticSiteDatabaseConnectionConfigurationFileOverview> configurationFiles;
    private String name;

    public String resourceId() {
        return this.resourceId;
    }

    public String connectionIdentity() {
        return this.connectionIdentity;
    }

    public String region() {
        return this.region;
    }

    public List<StaticSiteDatabaseConnectionConfigurationFileOverview> configurationFiles() {
        return this.configurationFiles;
    }

    public String name() {
        return this.name;
    }

    public void validate() {
        if (this.configurationFiles() != null) {
            this.configurationFiles().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static DatabaseConnectionOverview fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseConnectionOverview)jsonReader.readObject(reader -> {
            DatabaseConnectionOverview deserializedDatabaseConnectionOverview = new DatabaseConnectionOverview();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceId".equals(fieldName)) {
                    deserializedDatabaseConnectionOverview.resourceId = reader.getString();
                    continue;
                }
                if ("connectionIdentity".equals(fieldName)) {
                    deserializedDatabaseConnectionOverview.connectionIdentity = reader.getString();
                    continue;
                }
                if ("region".equals(fieldName)) {
                    deserializedDatabaseConnectionOverview.region = reader.getString();
                    continue;
                }
                if ("configurationFiles".equals(fieldName)) {
                    List configurationFiles;
                    deserializedDatabaseConnectionOverview.configurationFiles = configurationFiles = reader.readArray(reader1 -> StaticSiteDatabaseConnectionConfigurationFileOverview.fromJson(reader1));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDatabaseConnectionOverview.name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseConnectionOverview;
        });
    }
}

