/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.Address;
import java.io.IOException;

public final class Contact
implements JsonSerializable<Contact> {
    private Address addressMailing;
    private String email;
    private String fax;
    private String jobTitle;
    private String nameFirst;
    private String nameLast;
    private String nameMiddle;
    private String organization;
    private String phone;
    private static final ClientLogger LOGGER = new ClientLogger(Contact.class);

    public Address addressMailing() {
        return this.addressMailing;
    }

    public Contact withAddressMailing(Address addressMailing) {
        this.addressMailing = addressMailing;
        return this;
    }

    public String email() {
        return this.email;
    }

    public Contact withEmail(String email) {
        this.email = email;
        return this;
    }

    public String fax() {
        return this.fax;
    }

    public Contact withFax(String fax) {
        this.fax = fax;
        return this;
    }

    public String jobTitle() {
        return this.jobTitle;
    }

    public Contact withJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
        return this;
    }

    public String nameFirst() {
        return this.nameFirst;
    }

    public Contact withNameFirst(String nameFirst) {
        this.nameFirst = nameFirst;
        return this;
    }

    public String nameLast() {
        return this.nameLast;
    }

    public Contact withNameLast(String nameLast) {
        this.nameLast = nameLast;
        return this;
    }

    public String nameMiddle() {
        return this.nameMiddle;
    }

    public Contact withNameMiddle(String nameMiddle) {
        this.nameMiddle = nameMiddle;
        return this;
    }

    public String organization() {
        return this.organization;
    }

    public Contact withOrganization(String organization) {
        this.organization = organization;
        return this;
    }

    public String phone() {
        return this.phone;
    }

    public Contact withPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public void validate() {
        if (this.addressMailing() != null) {
            this.addressMailing().validate();
        }
        if (this.email() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property email in model Contact"));
        }
        if (this.nameFirst() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property nameFirst in model Contact"));
        }
        if (this.nameLast() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property nameLast in model Contact"));
        }
        if (this.phone() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property phone in model Contact"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("email", this.email);
        jsonWriter.writeStringField("nameFirst", this.nameFirst);
        jsonWriter.writeStringField("nameLast", this.nameLast);
        jsonWriter.writeStringField("phone", this.phone);
        jsonWriter.writeJsonField("addressMailing", (JsonSerializable)this.addressMailing);
        jsonWriter.writeStringField("fax", this.fax);
        jsonWriter.writeStringField("jobTitle", this.jobTitle);
        jsonWriter.writeStringField("nameMiddle", this.nameMiddle);
        jsonWriter.writeStringField("organization", this.organization);
        return jsonWriter.writeEndObject();
    }

    public static Contact fromJson(JsonReader jsonReader) throws IOException {
        return (Contact)jsonReader.readObject(reader -> {
            Contact deserializedContact = new Contact();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("email".equals(fieldName)) {
                    deserializedContact.email = reader.getString();
                    continue;
                }
                if ("nameFirst".equals(fieldName)) {
                    deserializedContact.nameFirst = reader.getString();
                    continue;
                }
                if ("nameLast".equals(fieldName)) {
                    deserializedContact.nameLast = reader.getString();
                    continue;
                }
                if ("phone".equals(fieldName)) {
                    deserializedContact.phone = reader.getString();
                    continue;
                }
                if ("addressMailing".equals(fieldName)) {
                    deserializedContact.addressMailing = Address.fromJson(reader);
                    continue;
                }
                if ("fax".equals(fieldName)) {
                    deserializedContact.fax = reader.getString();
                    continue;
                }
                if ("jobTitle".equals(fieldName)) {
                    deserializedContact.jobTitle = reader.getString();
                    continue;
                }
                if ("nameMiddle".equals(fieldName)) {
                    deserializedContact.nameMiddle = reader.getString();
                    continue;
                }
                if ("organization".equals(fieldName)) {
                    deserializedContact.organization = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContact;
        });
    }
}

