/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.SiteContainerProperties;
import com.azure.resourcemanager.appservice.models.AuthType;
import com.azure.resourcemanager.appservice.models.EnvironmentVariable;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.VolumeMount;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class SiteContainerInner
extends ProxyOnlyResource {
    private SiteContainerProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private SiteContainerProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public SiteContainerInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String image() {
        return this.innerProperties() == null ? null : this.innerProperties().image();
    }

    public SiteContainerInner withImage(String image) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteContainerProperties();
        }
        this.innerProperties().withImage(image);
        return this;
    }

    public String targetPort() {
        return this.innerProperties() == null ? null : this.innerProperties().targetPort();
    }

    public SiteContainerInner withTargetPort(String targetPort) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteContainerProperties();
        }
        this.innerProperties().withTargetPort(targetPort);
        return this;
    }

    public Boolean isMain() {
        return this.innerProperties() == null ? null : Boolean.valueOf(this.innerProperties().isMain());
    }

    public SiteContainerInner withIsMain(Boolean isMain) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteContainerProperties();
        }
        this.innerProperties().withIsMain(isMain);
        return this;
    }

    public String startUpCommand() {
        return this.innerProperties() == null ? null : this.innerProperties().startUpCommand();
    }

    public SiteContainerInner withStartUpCommand(String startUpCommand) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteContainerProperties();
        }
        this.innerProperties().withStartUpCommand(startUpCommand);
        return this;
    }

    public AuthType authType() {
        return this.innerProperties() == null ? null : this.innerProperties().authType();
    }

    public SiteContainerInner withAuthType(AuthType authType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteContainerProperties();
        }
        this.innerProperties().withAuthType(authType);
        return this;
    }

    public String username() {
        return this.innerProperties() == null ? null : this.innerProperties().username();
    }

    public SiteContainerInner withUsername(String username) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteContainerProperties();
        }
        this.innerProperties().withUsername(username);
        return this;
    }

    public String passwordSecret() {
        return this.innerProperties() == null ? null : this.innerProperties().passwordSecret();
    }

    public SiteContainerInner withPasswordSecret(String passwordSecret) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteContainerProperties();
        }
        this.innerProperties().withPasswordSecret(passwordSecret);
        return this;
    }

    public String userManagedIdentityClientId() {
        return this.innerProperties() == null ? null : this.innerProperties().userManagedIdentityClientId();
    }

    public SiteContainerInner withUserManagedIdentityClientId(String userManagedIdentityClientId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteContainerProperties();
        }
        this.innerProperties().withUserManagedIdentityClientId(userManagedIdentityClientId);
        return this;
    }

    public OffsetDateTime createdTime() {
        return this.innerProperties() == null ? null : this.innerProperties().createdTime();
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public List<VolumeMount> volumeMounts() {
        return this.innerProperties() == null ? null : this.innerProperties().volumeMounts();
    }

    public SiteContainerInner withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteContainerProperties();
        }
        this.innerProperties().withVolumeMounts(volumeMounts);
        return this;
    }

    public Boolean inheritAppSettingsAndConnectionStrings() {
        return this.innerProperties() == null ? null : this.innerProperties().inheritAppSettingsAndConnectionStrings();
    }

    public SiteContainerInner withInheritAppSettingsAndConnectionStrings(Boolean inheritAppSettingsAndConnectionStrings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteContainerProperties();
        }
        this.innerProperties().withInheritAppSettingsAndConnectionStrings(inheritAppSettingsAndConnectionStrings);
        return this;
    }

    public List<EnvironmentVariable> environmentVariables() {
        return this.innerProperties() == null ? null : this.innerProperties().environmentVariables();
    }

    public SiteContainerInner withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteContainerProperties();
        }
        this.innerProperties().withEnvironmentVariables(environmentVariables);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SiteContainerInner fromJson(JsonReader jsonReader) throws IOException {
        return (SiteContainerInner)((Object)jsonReader.readObject(reader -> {
            SiteContainerInner deserializedSiteContainerInner = new SiteContainerInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSiteContainerInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSiteContainerInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSiteContainerInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedSiteContainerInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSiteContainerInner.innerProperties = SiteContainerProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSiteContainerInner;
        }));
    }
}

