/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.RequestHistoryProperties;
import com.azure.resourcemanager.appservice.models.WorkflowResource;
import java.io.IOException;
import java.util.Map;

public final class RequestHistoryInner
extends WorkflowResource {
    private RequestHistoryProperties properties;
    private String type;
    private String name;
    private String id;

    public RequestHistoryProperties properties() {
        return this.properties;
    }

    public RequestHistoryInner withProperties(RequestHistoryProperties properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public RequestHistoryInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public RequestHistoryInner withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    @Override
    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static RequestHistoryInner fromJson(JsonReader jsonReader) throws IOException {
        return (RequestHistoryInner)((Object)jsonReader.readObject(reader -> {
            RequestHistoryInner deserializedRequestHistoryInner = new RequestHistoryInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRequestHistoryInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRequestHistoryInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRequestHistoryInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedRequestHistoryInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedRequestHistoryInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRequestHistoryInner.properties = RequestHistoryProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRequestHistoryInner;
        }));
    }
}

