/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.AddressResponseProperties;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.VirtualIpMapping;
import java.io.IOException;
import java.util.List;

public final class AddressResponseInner
extends ProxyOnlyResource {
    private AddressResponseProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private AddressResponseProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public AddressResponseInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String serviceIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceIpAddress();
    }

    public AddressResponseInner withServiceIpAddress(String serviceIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AddressResponseProperties();
        }
        this.innerProperties().withServiceIpAddress(serviceIpAddress);
        return this;
    }

    public String internalIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().internalIpAddress();
    }

    public AddressResponseInner withInternalIpAddress(String internalIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AddressResponseProperties();
        }
        this.innerProperties().withInternalIpAddress(internalIpAddress);
        return this;
    }

    public List<String> outboundIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().outboundIpAddresses();
    }

    public AddressResponseInner withOutboundIpAddresses(List<String> outboundIpAddresses) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AddressResponseProperties();
        }
        this.innerProperties().withOutboundIpAddresses(outboundIpAddresses);
        return this;
    }

    public List<VirtualIpMapping> vipMappings() {
        return this.innerProperties() == null ? null : this.innerProperties().vipMappings();
    }

    public AddressResponseInner withVipMappings(List<VirtualIpMapping> vipMappings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AddressResponseProperties();
        }
        this.innerProperties().withVipMappings(vipMappings);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AddressResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return (AddressResponseInner)((Object)jsonReader.readObject(reader -> {
            AddressResponseInner deserializedAddressResponseInner = new AddressResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAddressResponseInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAddressResponseInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAddressResponseInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedAddressResponseInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAddressResponseInner.innerProperties = AddressResponseProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAddressResponseInner;
        }));
    }
}

