/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.share.models.NfsFileType;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;

public final class DirectoriesGetPropertiesHeaders {
    private String xMsGroup;
    private String xMsVersion;
    private String xMsFilePermissionKey;
    private String xMsFileId;
    private OffsetDateTime xMsFileCreationTime;
    private NfsFileType xMsFileFileType;
    private DateTimeRfc1123 lastModified;
    private Map<String, String> xMsMeta;
    private DateTimeRfc1123 date;
    private String xMsMode;
    private Boolean xMsServerEncrypted;
    private String eTag;
    private String xMsFileAttributes;
    private OffsetDateTime xMsFileChangeTime;
    private String xMsFileParentId;
    private String xMsRequestId;
    private OffsetDateTime xMsFileLastWriteTime;
    private String xMsOwner;
    private static final HttpHeaderName X_MS_GROUP = HttpHeaderName.fromString((String)"x-ms-group");
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_FILE_PERMISSION_KEY = HttpHeaderName.fromString((String)"x-ms-file-permission-key");
    private static final HttpHeaderName X_MS_FILE_ID = HttpHeaderName.fromString((String)"x-ms-file-id");
    private static final HttpHeaderName X_MS_FILE_CREATION_TIME = HttpHeaderName.fromString((String)"x-ms-file-creation-time");
    private static final HttpHeaderName X_MS_FILE_FILE_TYPE = HttpHeaderName.fromString((String)"x-ms-file-file-type");
    private static final HttpHeaderName X_MS_MODE = HttpHeaderName.fromString((String)"x-ms-mode");
    private static final HttpHeaderName X_MS_SERVER_ENCRYPTED = HttpHeaderName.fromString((String)"x-ms-server-encrypted");
    private static final HttpHeaderName X_MS_FILE_ATTRIBUTES = HttpHeaderName.fromString((String)"x-ms-file-attributes");
    private static final HttpHeaderName X_MS_FILE_CHANGE_TIME = HttpHeaderName.fromString((String)"x-ms-file-change-time");
    private static final HttpHeaderName X_MS_FILE_PARENT_ID = HttpHeaderName.fromString((String)"x-ms-file-parent-id");
    private static final HttpHeaderName X_MS_FILE_LAST_WRITE_TIME = HttpHeaderName.fromString((String)"x-ms-file-last-write-time");
    private static final HttpHeaderName X_MS_OWNER = HttpHeaderName.fromString((String)"x-ms-owner");

    public DirectoriesGetPropertiesHeaders(HttpHeaders rawHeaders) {
        String date;
        String lastModified;
        String xMsFileFileType;
        this.xMsGroup = rawHeaders.getValue(X_MS_GROUP);
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        this.xMsFilePermissionKey = rawHeaders.getValue(X_MS_FILE_PERMISSION_KEY);
        this.xMsFileId = rawHeaders.getValue(X_MS_FILE_ID);
        String xMsFileCreationTime = rawHeaders.getValue(X_MS_FILE_CREATION_TIME);
        if (xMsFileCreationTime != null) {
            this.xMsFileCreationTime = OffsetDateTime.parse(xMsFileCreationTime);
        }
        if ((xMsFileFileType = rawHeaders.getValue(X_MS_FILE_FILE_TYPE)) != null) {
            this.xMsFileFileType = NfsFileType.fromString(xMsFileFileType);
        }
        if ((lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED)) != null) {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        if ((date = rawHeaders.getValue(HttpHeaderName.DATE)) != null) {
            this.date = new DateTimeRfc1123(date);
        }
        this.xMsMode = rawHeaders.getValue(X_MS_MODE);
        String xMsServerEncrypted = rawHeaders.getValue(X_MS_SERVER_ENCRYPTED);
        if (xMsServerEncrypted != null) {
            this.xMsServerEncrypted = Boolean.parseBoolean(xMsServerEncrypted);
        }
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        this.xMsFileAttributes = rawHeaders.getValue(X_MS_FILE_ATTRIBUTES);
        String xMsFileChangeTime = rawHeaders.getValue(X_MS_FILE_CHANGE_TIME);
        if (xMsFileChangeTime != null) {
            this.xMsFileChangeTime = OffsetDateTime.parse(xMsFileChangeTime);
        }
        this.xMsFileParentId = rawHeaders.getValue(X_MS_FILE_PARENT_ID);
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        String xMsFileLastWriteTime = rawHeaders.getValue(X_MS_FILE_LAST_WRITE_TIME);
        if (xMsFileLastWriteTime != null) {
            this.xMsFileLastWriteTime = OffsetDateTime.parse(xMsFileLastWriteTime);
        }
        this.xMsOwner = rawHeaders.getValue(X_MS_OWNER);
        LinkedHashMap<String, String> xMsMetaHeaderCollection = new LinkedHashMap<String, String>();
        for (HttpHeader header : rawHeaders) {
            String headerName = header.getName();
            if (!headerName.startsWith("x-ms-meta-")) continue;
            xMsMetaHeaderCollection.put(headerName.substring(10), header.getValue());
        }
        this.xMsMeta = xMsMetaHeaderCollection;
    }

    public String getXMsGroup() {
        return this.xMsGroup;
    }

    public DirectoriesGetPropertiesHeaders setXMsGroup(String xMsGroup) {
        this.xMsGroup = xMsGroup;
        return this;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public DirectoriesGetPropertiesHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getXMsFilePermissionKey() {
        return this.xMsFilePermissionKey;
    }

    public DirectoriesGetPropertiesHeaders setXMsFilePermissionKey(String xMsFilePermissionKey) {
        this.xMsFilePermissionKey = xMsFilePermissionKey;
        return this;
    }

    public String getXMsFileId() {
        return this.xMsFileId;
    }

    public DirectoriesGetPropertiesHeaders setXMsFileId(String xMsFileId) {
        this.xMsFileId = xMsFileId;
        return this;
    }

    public OffsetDateTime getXMsFileCreationTime() {
        return this.xMsFileCreationTime;
    }

    public DirectoriesGetPropertiesHeaders setXMsFileCreationTime(OffsetDateTime xMsFileCreationTime) {
        this.xMsFileCreationTime = xMsFileCreationTime;
        return this;
    }

    public NfsFileType getXMsFileFileType() {
        return this.xMsFileFileType;
    }

    public DirectoriesGetPropertiesHeaders setXMsFileFileType(NfsFileType xMsFileFileType) {
        this.xMsFileFileType = xMsFileFileType;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public DirectoriesGetPropertiesHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public Map<String, String> getXMsMeta() {
        return this.xMsMeta;
    }

    public DirectoriesGetPropertiesHeaders setXMsMeta(Map<String, String> xMsMeta) {
        this.xMsMeta = xMsMeta;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public DirectoriesGetPropertiesHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public String getXMsMode() {
        return this.xMsMode;
    }

    public DirectoriesGetPropertiesHeaders setXMsMode(String xMsMode) {
        this.xMsMode = xMsMode;
        return this;
    }

    public Boolean isXMsServerEncrypted() {
        return this.xMsServerEncrypted;
    }

    public DirectoriesGetPropertiesHeaders setXMsServerEncrypted(Boolean xMsServerEncrypted) {
        this.xMsServerEncrypted = xMsServerEncrypted;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public DirectoriesGetPropertiesHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public String getXMsFileAttributes() {
        return this.xMsFileAttributes;
    }

    public DirectoriesGetPropertiesHeaders setXMsFileAttributes(String xMsFileAttributes) {
        this.xMsFileAttributes = xMsFileAttributes;
        return this;
    }

    public OffsetDateTime getXMsFileChangeTime() {
        return this.xMsFileChangeTime;
    }

    public DirectoriesGetPropertiesHeaders setXMsFileChangeTime(OffsetDateTime xMsFileChangeTime) {
        this.xMsFileChangeTime = xMsFileChangeTime;
        return this;
    }

    public String getXMsFileParentId() {
        return this.xMsFileParentId;
    }

    public DirectoriesGetPropertiesHeaders setXMsFileParentId(String xMsFileParentId) {
        this.xMsFileParentId = xMsFileParentId;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public DirectoriesGetPropertiesHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public OffsetDateTime getXMsFileLastWriteTime() {
        return this.xMsFileLastWriteTime;
    }

    public DirectoriesGetPropertiesHeaders setXMsFileLastWriteTime(OffsetDateTime xMsFileLastWriteTime) {
        this.xMsFileLastWriteTime = xMsFileLastWriteTime;
        return this;
    }

    public String getXMsOwner() {
        return this.xMsOwner;
    }

    public DirectoriesGetPropertiesHeaders setXMsOwner(String xMsOwner) {
        this.xMsOwner = xMsOwner;
        return this;
    }
}

