/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.specialized;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.util.CoreUtils;
import com.azure.storage.file.share.ShareAsyncClient;
import com.azure.storage.file.share.ShareClient;
import com.azure.storage.file.share.ShareFileAsyncClient;
import com.azure.storage.file.share.ShareFileClient;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.models.ShareTokenIntent;
import com.azure.storage.file.share.specialized.ShareLeaseAsyncClient;
import com.azure.storage.file.share.specialized.ShareLeaseClient;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={ShareLeaseClient.class, ShareLeaseAsyncClient.class})
public final class ShareLeaseClientBuilder {
    private String shareName;
    private String resourcePath;
    private String shareSnapshot;
    private HttpPipeline pipeline;
    private String url;
    private String leaseId;
    private boolean isShareFile;
    private String accountName;
    private ShareServiceVersion serviceVersion;
    private ShareTokenIntent shareTokenIntent;
    private boolean allowSourceTrailingDot;
    private boolean allowTrailingDot;

    public ShareLeaseClient buildClient() {
        return new ShareLeaseClient(this.buildAsyncClient());
    }

    public ShareLeaseAsyncClient buildAsyncClient() {
        ShareServiceVersion version = this.serviceVersion == null ? ShareServiceVersion.getLatest() : this.serviceVersion;
        return new ShareLeaseAsyncClient(this.pipeline, this.url, this.shareName, this.shareSnapshot, this.resourcePath, this.getLeaseId(), this.isShareFile, this.accountName, version.getVersion(), this.allowTrailingDot, this.allowSourceTrailingDot, this.shareTokenIntent);
    }

    public ShareLeaseClientBuilder fileClient(ShareFileClient fileClient) {
        Objects.requireNonNull(fileClient);
        this.pipeline = fileClient.getHttpPipeline();
        this.url = fileClient.getAccountUrl();
        this.shareName = fileClient.getShareName();
        this.resourcePath = fileClient.getFilePath();
        this.isShareFile = true;
        this.accountName = fileClient.getAccountName();
        this.serviceVersion = fileClient.getServiceVersion();
        return this;
    }

    public ShareLeaseClientBuilder fileAsyncClient(ShareFileAsyncClient fileAsyncClient) {
        Objects.requireNonNull(fileAsyncClient);
        this.pipeline = fileAsyncClient.getHttpPipeline();
        this.url = fileAsyncClient.getAccountUrl();
        this.shareName = fileAsyncClient.getShareName();
        this.resourcePath = fileAsyncClient.getFilePath();
        this.isShareFile = true;
        this.accountName = fileAsyncClient.getAccountName();
        this.serviceVersion = fileAsyncClient.getServiceVersion();
        return this;
    }

    public ShareLeaseClientBuilder shareClient(ShareClient shareClient) {
        Objects.requireNonNull(shareClient);
        this.pipeline = shareClient.getHttpPipeline();
        this.url = shareClient.getAccountUrl();
        this.shareName = shareClient.getShareName();
        this.shareSnapshot = shareClient.getSnapshotId();
        this.isShareFile = false;
        this.accountName = shareClient.getAccountName();
        this.serviceVersion = shareClient.getServiceVersion();
        return this;
    }

    public ShareLeaseClientBuilder shareAsyncClient(ShareAsyncClient shareAsyncClient) {
        Objects.requireNonNull(shareAsyncClient);
        this.pipeline = shareAsyncClient.getHttpPipeline();
        this.url = shareAsyncClient.getAccountUrl();
        this.shareName = shareAsyncClient.getShareName();
        this.shareSnapshot = shareAsyncClient.getSnapshotId();
        this.isShareFile = false;
        this.accountName = shareAsyncClient.getAccountName();
        this.serviceVersion = shareAsyncClient.getServiceVersion();
        return this;
    }

    public ShareLeaseClientBuilder leaseId(String leaseId) {
        this.leaseId = leaseId;
        return this;
    }

    private String getLeaseId() {
        return this.leaseId == null ? CoreUtils.randomUuid().toString() : this.leaseId;
    }

    public ShareLeaseClientBuilder allowSourceTrailingDot(boolean allowSourceTrailingDot) {
        this.allowSourceTrailingDot = allowSourceTrailingDot;
        return this;
    }

    public ShareLeaseClientBuilder allowTrailingDot(boolean allowTrailingDot) {
        this.allowTrailingDot = allowTrailingDot;
        return this;
    }

    public ShareLeaseClientBuilder shareTokenIntent(ShareTokenIntent shareTokenIntent) {
        this.shareTokenIntent = shareTokenIntent;
        return this;
    }
}

