/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.implementation;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;
import reactor.core.publisher.Flux;

final class PayloadSizeGate {
    private final long threshold;
    private long size = 0L;
    private Queue<ByteBuffer> byteBuffers = new LinkedList<ByteBuffer>();

    PayloadSizeGate(long threshold) {
        this.threshold = threshold;
    }

    Flux<ByteBuffer> write(ByteBuffer buf) {
        ByteBuffer cachedBuffer = ByteBuffer.allocate(buf.remaining()).put(buf);
        cachedBuffer.flip();
        if (this.isThresholdBreached()) {
            this.size += (long)cachedBuffer.remaining();
            return Flux.just((Object)cachedBuffer);
        }
        this.size += (long)cachedBuffer.remaining();
        this.byteBuffers.add(cachedBuffer);
        if (this.isThresholdBreached()) {
            Flux<ByteBuffer> result = PayloadSizeGate.dequeuingFlux(this.byteBuffers);
            this.byteBuffers = null;
            return result;
        }
        return Flux.empty();
    }

    Flux<ByteBuffer> flush() {
        if (this.byteBuffers != null) {
            Flux result = Flux.fromIterable(this.byteBuffers);
            this.byteBuffers = null;
            return result;
        }
        return Flux.empty();
    }

    long size() {
        return this.size;
    }

    boolean isThresholdBreached() {
        return this.size > this.threshold;
    }

    private static Flux<ByteBuffer> dequeuingFlux(Queue<ByteBuffer> queue) {
        return Flux.generate(sink -> {
            ByteBuffer buffer = (ByteBuffer)queue.poll();
            if (buffer != null) {
                sink.next((Object)buffer);
            } else {
                sink.complete();
            }
        });
    }
}

