/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.models.AccountKind;
import com.azure.storage.blob.models.SkuName;
import java.time.OffsetDateTime;

public final class BlobsGetAccountInfoHeaders {
    private String xMsVersion;
    private AccountKind xMsAccountKind;
    private Boolean xMsIsHnsEnabled;
    private SkuName xMsSkuName;
    private String xMsRequestId;
    private String xMsClientRequestId;
    private DateTimeRfc1123 date;
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_ACCOUNT_KIND = HttpHeaderName.fromString((String)"x-ms-account-kind");
    private static final HttpHeaderName X_MS_IS_HNS_ENABLED = HttpHeaderName.fromString((String)"x-ms-is-hns-enabled");
    private static final HttpHeaderName X_MS_SKU_NAME = HttpHeaderName.fromString((String)"x-ms-sku-name");

    public BlobsGetAccountInfoHeaders(HttpHeaders rawHeaders) {
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        String xMsAccountKind = rawHeaders.getValue(X_MS_ACCOUNT_KIND);
        this.xMsAccountKind = xMsAccountKind != null ? AccountKind.fromString(xMsAccountKind) : null;
        String xMsIsHnsEnabled = rawHeaders.getValue(X_MS_IS_HNS_ENABLED);
        this.xMsIsHnsEnabled = xMsIsHnsEnabled != null ? Boolean.valueOf(Boolean.parseBoolean(xMsIsHnsEnabled)) : null;
        String xMsSkuName = rawHeaders.getValue(X_MS_SKU_NAME);
        this.xMsSkuName = xMsSkuName != null ? SkuName.fromString(xMsSkuName) : null;
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        this.xMsClientRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        this.date = date != null ? new DateTimeRfc1123(date) : null;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public BlobsGetAccountInfoHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public AccountKind getXMsAccountKind() {
        return this.xMsAccountKind;
    }

    public BlobsGetAccountInfoHeaders setXMsAccountKind(AccountKind xMsAccountKind) {
        this.xMsAccountKind = xMsAccountKind;
        return this;
    }

    public Boolean isXMsIsHnsEnabled() {
        return this.xMsIsHnsEnabled;
    }

    public BlobsGetAccountInfoHeaders setXMsIsHnsEnabled(Boolean xMsIsHnsEnabled) {
        this.xMsIsHnsEnabled = xMsIsHnsEnabled;
        return this;
    }

    public SkuName getXMsSkuName() {
        return this.xMsSkuName;
    }

    public BlobsGetAccountInfoHeaders setXMsSkuName(SkuName xMsSkuName) {
        this.xMsSkuName = xMsSkuName;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public BlobsGetAccountInfoHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public BlobsGetAccountInfoHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public BlobsGetAccountInfoHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }
}

