/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobServiceAsyncClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.BlobUrlParts;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.util.BuilderHelper;
import com.azure.storage.blob.models.BlobContainerEncryptionScope;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.implementation.connectionstring.StorageAuthenticationSettings;
import com.azure.storage.common.implementation.connectionstring.StorageConnectionString;
import com.azure.storage.common.implementation.connectionstring.StorageEndpoint;
import com.azure.storage.common.policy.RequestRetryOptions;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={BlobServiceClient.class, BlobServiceAsyncClient.class})
public final class BlobServiceClientBuilder {
    private final ClientLogger logger = new ClientLogger(BlobServiceClientBuilder.class);
    private String endpoint;
    private String accountName;
    private CpkInfo customerProvidedKey;
    private EncryptionScope encryptionScope;
    private BlobContainerEncryptionScope blobContainerEncryptionScope;
    private StorageSharedKeyCredential storageSharedKeyCredential;
    private TokenCredential tokenCredential;
    private AzureSasCredential azureSasCredential;
    private String sasToken;
    private HttpClient httpClient;
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpLogOptions logOptions;
    private RequestRetryOptions retryOptions = new RequestRetryOptions();
    private HttpPipeline httpPipeline;
    private ClientOptions clientOptions = new ClientOptions();
    private Configuration configuration;
    private BlobServiceVersion version;

    public BlobServiceClientBuilder() {
        this.logOptions = BlobServiceClientBuilder.getDefaultHttpLogOptions();
    }

    public BlobServiceClient buildClient() {
        return new BlobServiceClient(this.buildAsyncClient());
    }

    public BlobServiceAsyncClient buildAsyncClient() {
        BuilderHelper.httpsValidation(this.customerProvidedKey, "customer provided key", this.endpoint, this.logger);
        boolean anonymousAccess = false;
        if (Objects.isNull(this.storageSharedKeyCredential) && Objects.isNull(this.tokenCredential) && Objects.isNull(this.azureSasCredential) && Objects.isNull(this.sasToken)) {
            anonymousAccess = true;
        }
        if (Objects.nonNull(this.customerProvidedKey) && Objects.nonNull(this.encryptionScope)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Customer provided key and encryption scope cannot both be set"));
        }
        BlobServiceVersion serviceVersion = this.version != null ? this.version : BlobServiceVersion.getLatest();
        HttpPipeline pipeline = this.httpPipeline != null ? this.httpPipeline : BuilderHelper.buildPipeline(this.storageSharedKeyCredential, this.tokenCredential, this.azureSasCredential, this.sasToken, this.endpoint, this.retryOptions, this.logOptions, this.clientOptions, this.httpClient, this.perCallPolicies, this.perRetryPolicies, this.configuration, this.logger);
        return new BlobServiceAsyncClient(pipeline, this.endpoint, serviceVersion, this.accountName, this.customerProvidedKey, this.encryptionScope, this.blobContainerEncryptionScope, anonymousAccess);
    }

    public BlobServiceClientBuilder endpoint(String endpoint) {
        try {
            BlobUrlParts parts = BlobUrlParts.parse(new URL(endpoint));
            this.accountName = parts.getAccountName();
            this.endpoint = BuilderHelper.getEndpoint(parts);
            String sasToken = parts.getCommonSasQueryParameters().encode();
            if (!CoreUtils.isNullOrEmpty((CharSequence)sasToken)) {
                this.sasToken(sasToken);
            }
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The Azure Storage endpoint url is malformed."));
        }
        return this;
    }

    public BlobServiceClientBuilder customerProvidedKey(CustomerProvidedKey customerProvidedKey) {
        this.customerProvidedKey = customerProvidedKey == null ? null : new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        return this;
    }

    public BlobServiceClientBuilder encryptionScope(String encryptionScope) {
        this.encryptionScope = encryptionScope == null ? null : new EncryptionScope().setEncryptionScope(encryptionScope);
        return this;
    }

    public BlobServiceClientBuilder blobContainerEncryptionScope(BlobContainerEncryptionScope blobContainerEncryptionScope) {
        this.blobContainerEncryptionScope = blobContainerEncryptionScope;
        return this;
    }

    public BlobServiceClientBuilder credential(StorageSharedKeyCredential credential) {
        this.storageSharedKeyCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.tokenCredential = null;
        this.sasToken = null;
        return this;
    }

    public BlobServiceClientBuilder credential(TokenCredential credential) {
        this.tokenCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.storageSharedKeyCredential = null;
        this.sasToken = null;
        return this;
    }

    public BlobServiceClientBuilder sasToken(String sasToken) {
        this.sasToken = Objects.requireNonNull(sasToken, "'sasToken' cannot be null.");
        this.storageSharedKeyCredential = null;
        this.tokenCredential = null;
        return this;
    }

    public BlobServiceClientBuilder credential(AzureSasCredential credential) {
        this.azureSasCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this;
    }

    public BlobServiceClientBuilder connectionString(String connectionString) {
        StorageAuthenticationSettings authSettings;
        StorageConnectionString storageConnectionString = StorageConnectionString.create((String)connectionString, (ClientLogger)this.logger);
        StorageEndpoint endpoint = storageConnectionString.getBlobEndpoint();
        if (endpoint == null || endpoint.getPrimaryUri() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("connectionString missing required settings to derive blob service endpoint."));
        }
        this.endpoint(endpoint.getPrimaryUri());
        if (storageConnectionString.getAccountName() != null) {
            this.accountName = storageConnectionString.getAccountName();
        }
        if ((authSettings = storageConnectionString.getStorageAuthSettings()).getType() == StorageAuthenticationSettings.Type.ACCOUNT_NAME_KEY) {
            this.credential(new StorageSharedKeyCredential(authSettings.getAccount().getName(), authSettings.getAccount().getAccessKey()));
        } else if (authSettings.getType() == StorageAuthenticationSettings.Type.SAS_TOKEN) {
            this.sasToken(authSettings.getSasToken());
        }
        return this;
    }

    public BlobServiceClientBuilder httpClient(HttpClient httpClient) {
        if (this.httpClient != null && httpClient == null) {
            this.logger.info("'httpClient' is being set to 'null' when it was previously configured.");
        }
        this.httpClient = httpClient;
        return this;
    }

    public BlobServiceClientBuilder addPolicy(HttpPipelinePolicy pipelinePolicy) {
        Objects.requireNonNull(pipelinePolicy, "'pipelinePolicy' cannot be null");
        if (pipelinePolicy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(pipelinePolicy);
        } else {
            this.perRetryPolicies.add(pipelinePolicy);
        }
        return this;
    }

    public BlobServiceClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.logOptions = Objects.requireNonNull(logOptions, "'logOptions' cannot be null.");
        return this;
    }

    public static HttpLogOptions getDefaultHttpLogOptions() {
        return BuilderHelper.getDefaultHttpLogOptions();
    }

    public BlobServiceClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public BlobServiceClientBuilder retryOptions(RequestRetryOptions retryOptions) {
        this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
        return this;
    }

    public BlobServiceClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = Objects.requireNonNull(clientOptions, "'clientOptions' cannot be null.");
        return this;
    }

    public BlobServiceClientBuilder pipeline(HttpPipeline httpPipeline) {
        if (this.httpPipeline != null && httpPipeline == null) {
            this.logger.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public BlobServiceClientBuilder serviceVersion(BlobServiceVersion version) {
        this.version = version;
        return this;
    }
}

