/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized.cryptography;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.specialized.cryptography.EncryptedRegionInfo;
import com.azure.storage.blob.specialized.cryptography.EncryptionAgent;
import com.azure.storage.blob.specialized.cryptography.EncryptionAlgorithm;
import com.azure.storage.blob.specialized.cryptography.WrappedKey;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

final class EncryptionData {
    private static final ClientLogger LOGGER = new ClientLogger(EncryptionData.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
    @JsonProperty(value="EncryptionMode")
    private String encryptionMode;
    @JsonProperty(value="WrappedContentKey", required=true)
    private WrappedKey wrappedContentKey;
    @JsonProperty(value="EncryptionAgent", required=true)
    private EncryptionAgent encryptionAgent;
    @JsonProperty(value="ContentEncryptionIV", required=true)
    private byte[] contentEncryptionIV;
    @JsonProperty(value="EncryptedRegionInfo")
    private EncryptedRegionInfo encryptedRegionInfo;
    @JsonProperty(value="KeyWrappingMetadata", required=true)
    private Map<String, String> keyWrappingMetadata;

    EncryptionData() {
    }

    EncryptionData(String encryptionMode, WrappedKey wrappedContentKey, EncryptionAgent encryptionAgent, byte[] contentEncryptionIV, EncryptedRegionInfo encryptedRegionInfo, Map<String, String> keyWrappingMetadata) {
        this.encryptionMode = encryptionMode;
        this.wrappedContentKey = wrappedContentKey;
        this.encryptionAgent = encryptionAgent;
        this.contentEncryptionIV = contentEncryptionIV;
        this.encryptedRegionInfo = encryptedRegionInfo;
        this.keyWrappingMetadata = keyWrappingMetadata;
    }

    String getEncryptionMode() {
        return this.encryptionMode;
    }

    WrappedKey getWrappedContentKey() {
        return this.wrappedContentKey;
    }

    EncryptionAgent getEncryptionAgent() {
        return this.encryptionAgent;
    }

    byte[] getContentEncryptionIV() {
        return this.contentEncryptionIV;
    }

    EncryptedRegionInfo getEncryptedRegionInfo() {
        return this.encryptedRegionInfo;
    }

    Map<String, String> getKeyWrappingMetadata() {
        return this.keyWrappingMetadata;
    }

    EncryptionData setEncryptionMode(String encryptionMode) {
        this.encryptionMode = encryptionMode;
        return this;
    }

    EncryptionData setWrappedContentKey(WrappedKey wrappedContentKey) {
        this.wrappedContentKey = wrappedContentKey;
        return this;
    }

    EncryptionData setEncryptionAgent(EncryptionAgent encryptionAgent) {
        this.encryptionAgent = encryptionAgent;
        return this;
    }

    EncryptionData setContentEncryptionIV(byte[] contentEncryptionIV) {
        this.contentEncryptionIV = contentEncryptionIV;
        return this;
    }

    EncryptionData setKeyWrappingMetadata(Map<String, String> keyWrappingMetadata) {
        this.keyWrappingMetadata = keyWrappingMetadata;
        return this;
    }

    EncryptionData setEncryptedRegionInfo(EncryptedRegionInfo encryptedRegionInfo) {
        this.encryptedRegionInfo = encryptedRegionInfo;
        return this;
    }

    String toJsonString() throws JsonProcessingException {
        return MAPPER.writeValueAsString((Object)this);
    }

    static EncryptionData getAndValidateEncryptionData(String encryptionDataString, boolean requiresEncryption) {
        if (encryptionDataString == null) {
            if (requiresEncryption) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'requiresEncryption' set to true but downloaded data is not encrypted."));
            }
            return null;
        }
        try {
            EncryptionData encryptionData = (EncryptionData)MAPPER.readValue(encryptionDataString, EncryptionData.class);
            if (encryptionData.getEncryptionAgent().getProtocol().equals("1.0")) {
                Objects.requireNonNull(encryptionData.getContentEncryptionIV(), "contentEncryptionIV in encryptionData cannot be null");
                Objects.requireNonNull(encryptionData.getWrappedContentKey().getEncryptedKey(), "encryptedKey in encryptionData.wrappedContentKey cannot be null");
                if (!encryptionData.getEncryptionAgent().getAlgorithm().equals((Object)EncryptionAlgorithm.AES_CBC_256)) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Encryption algorithm does not match v1 protocol: " + (Object)((Object)encryptionData.getEncryptionAgent().getAlgorithm())));
                }
            } else if (encryptionData.getEncryptionAgent().getProtocol().equals("2.0")) {
                Objects.requireNonNull(encryptionData.getWrappedContentKey().getEncryptedKey(), "encryptedKey in encryptionData.wrappedContentKey cannot be null");
                if (!encryptionData.getEncryptionAgent().getAlgorithm().equals((Object)EncryptionAlgorithm.AES_GCM_256)) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Encryption algorithm does not match v2 protocol: " + (Object)((Object)encryptionData.getEncryptionAgent().getAlgorithm())));
                }
            } else {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(Locale.ROOT, "Invalid Encryption Agent. This version of the client library does not understand the Encryption Agent set on the blob message: %s", encryptionDataString)));
            }
            return encryptionData;
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    static EncryptionData fromJsonString(String jsonString) throws JsonProcessingException {
        return (EncryptionData)MAPPER.readValue(jsonString, EncryptionData.class);
    }
}

