/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized.cryptography;

import com.azure.core.cryptography.AsyncKeyEncryptionKey;
import com.azure.core.cryptography.AsyncKeyEncryptionKeyResolver;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.specialized.cryptography.CryptographyConstants;
import com.azure.storage.blob.specialized.cryptography.Decryptor;
import com.azure.storage.blob.specialized.cryptography.EncryptedBlobRange;
import com.azure.storage.blob.specialized.cryptography.EncryptionData;
import com.azure.storage.common.implementation.BufferStagingArea;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DecryptorV2
extends Decryptor {
    private static final ClientLogger LOGGER = new ClientLogger(DecryptorV2.class);

    protected DecryptorV2(AsyncKeyEncryptionKeyResolver keyResolver, AsyncKeyEncryptionKey keyWrapper, EncryptionData encryptionData) {
        super(keyResolver, keyWrapper, encryptionData);
    }

    @Override
    Flux<ByteBuffer> decrypt(Flux<ByteBuffer> encryptedFlux, EncryptedBlobRange encryptedBlobRange, boolean padding, String requestUri, AtomicLong totalInputBytes, byte[] contentEncryptionKey) {
        int gcmEncryptionRegionLength = this.encryptionData.getEncryptedRegionInfo().getDataLength();
        int nonceLength = this.encryptionData.getEncryptedRegionInfo().getNonceLength();
        BufferStagingArea stagingArea = new BufferStagingArea((long)(gcmEncryptionRegionLength + 16 + nonceLength), (long)(gcmEncryptionRegionLength + 16 + nonceLength));
        return encryptedFlux.flatMapSequential(arg_0 -> ((BufferStagingArea)stagingArea).write(arg_0), 1, 1).concatWith((Publisher)Flux.defer(() -> ((BufferStagingArea)stagingArea).flush())).flatMapSequential(aggregator -> {
            Cipher gmcCipher;
            byte[] gmcIv = aggregator.getFirstNBytes(nonceLength);
            try {
                gmcCipher = this.getCipher(contentEncryptionKey, gmcIv, false);
            }
            catch (InvalidKeyException e) {
                return Mono.error((Throwable)LOGGER.logExceptionAsError(Exceptions.propagate((Throwable)e)));
            }
            ByteBuffer decryptedRegion = ByteBuffer.allocate(gcmEncryptionRegionLength);
            return aggregator.asFlux().map(buffer -> {
                try {
                    gmcCipher.update((ByteBuffer)buffer, decryptedRegion);
                }
                catch (ShortBufferException e) {
                    throw LOGGER.logExceptionAsError(Exceptions.propagate((Throwable)e));
                }
                return decryptedRegion;
            }).then(Mono.fromCallable(() -> {
                gmcCipher.doFinal(CryptographyConstants.EMPTY_BUFFER, decryptedRegion);
                decryptedRegion.flip();
                return decryptedRegion;
            })).flux();
        });
    }

    @Override
    protected Mono<byte[]> getKeyEncryptionKey() {
        return super.getKeyEncryptionKey().flatMap(keyBytes -> {
            ByteArrayInputStream keyStream = new ByteArrayInputStream((byte[])keyBytes);
            byte[] protocolBytes = new byte[3];
            try {
                keyStream.read(protocolBytes);
                if (ByteBuffer.wrap("2.0".getBytes(StandardCharsets.UTF_8)).compareTo(ByteBuffer.wrap(protocolBytes)) != 0) {
                    return Mono.error((Throwable)LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Padded wrapped key did not match protocol version")));
                }
                for (int i = 0; i < 5; ++i) {
                    keyStream.read();
                }
                if (keyStream.available() != 32) {
                    return Mono.error((Throwable)LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Wrapped key bytes were incorrect length")));
                }
                byte[] strippedKeyBytes = new byte[32];
                keyStream.read(strippedKeyBytes);
                return Mono.just((Object)strippedKeyBytes);
            }
            catch (IOException e) {
                return Mono.error((Throwable)LOGGER.logThrowableAsError((Throwable)e));
            }
        });
    }

    @Override
    protected Cipher getCipher(byte[] contentEncryptionKey, byte[] iv, boolean padding) throws InvalidKeyException {
        SecretKeySpec keySpec = new SecretKeySpec(contentEncryptionKey, 0, contentEncryptionKey.length, "AES");
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)keySpec, new GCMParameterSpec(128, iv));
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw LOGGER.logExceptionAsError(Exceptions.propagate((Throwable)e));
        }
    }
}

