/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.repository.support;

import com.azure.cosmos.models.ExcludedPath;
import com.azure.cosmos.models.IncludedPath;
import com.azure.cosmos.models.IndexingPolicy;
import java.util.List;
import java.util.stream.Collectors;

public class IndexPolicyCompareService {
    public static boolean policyNeedsUpdate(IndexingPolicy existingPolicy, IndexingPolicy newPolicy) {
        return !IndexPolicyCompareService.hasSameIncludedPaths(existingPolicy.getIncludedPaths(), newPolicy.getIncludedPaths()) || !IndexPolicyCompareService.hasSameExcludedPaths(existingPolicy.getExcludedPaths(), newPolicy.getExcludedPaths()) || !existingPolicy.getCompositeIndexes().equals(newPolicy.getCompositeIndexes()) || !existingPolicy.getIndexingMode().equals((Object)newPolicy.getIndexingMode()) || !existingPolicy.isAutomatic().equals(newPolicy.isAutomatic());
    }

    private static boolean hasSameIncludedPaths(List<IncludedPath> existingPaths, List<IncludedPath> newPaths) {
        List existingListDiff = existingPaths.stream().filter(element -> !newPaths.contains(element)).collect(Collectors.toList());
        List newListDiff = newPaths.stream().filter(element -> !existingPaths.contains(element)).collect(Collectors.toList());
        return existingListDiff.size() == 0 && newListDiff.size() == 0 || newListDiff.size() == 0 && existingListDiff.size() == 1 && ((IncludedPath)existingListDiff.get(0)).getPath().equals("/*");
    }

    private static boolean hasSameExcludedPaths(List<ExcludedPath> existingPaths, List<ExcludedPath> newPaths) {
        List existingListDiff = existingPaths.stream().filter(element -> !newPaths.contains(element)).collect(Collectors.toList());
        List newListDiff = newPaths.stream().filter(element -> !existingPaths.contains(element)).collect(Collectors.toList());
        return existingListDiff.size() == 0 && newListDiff.size() == 0 || newListDiff.size() == 0 && existingListDiff.size() == 1 && ((ExcludedPath)existingListDiff.get(0)).getPath().equals("/\"_etag\"/?");
    }
}

