/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.repository.support;

import com.azure.spring.data.cosmos.core.CosmosOperations;
import com.azure.spring.data.cosmos.core.mapping.CosmosMappingContext;
import com.azure.spring.data.cosmos.repository.support.CosmosRepositoryFactory;
import java.io.Serializable;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

public class CosmosRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    private CosmosOperations operations;
    private boolean mappingContextConfigured = false;

    public CosmosRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setCosmosOperations(CosmosOperations operations) {
        this.operations = operations;
    }

    protected final RepositoryFactorySupport createRepositoryFactory() {
        return this.getFactoryInstance();
    }

    protected RepositoryFactorySupport getFactoryInstance() {
        return new CosmosRepositoryFactory(this.operations);
    }

    protected void setMappingContext(MappingContext<?, ?> mappingContext) {
        super.setMappingContext(mappingContext);
        this.mappingContextConfigured = true;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (!this.mappingContextConfigured) {
            if (this.operations != null) {
                this.setMappingContext(this.operations.getConverter().getMappingContext());
            } else {
                this.setMappingContext((MappingContext<?, ?>)new CosmosMappingContext());
            }
        }
    }
}

