/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.repository.support;

import com.azure.spring.data.cosmos.core.CosmosOperations;
import com.azure.spring.data.cosmos.repository.query.CosmosQueryMethod;
import com.azure.spring.data.cosmos.repository.query.PartTreeCosmosQuery;
import com.azure.spring.data.cosmos.repository.support.CosmosEntityInformation;
import com.azure.spring.data.cosmos.repository.support.SimpleCosmosRepository;
import com.azure.spring.data.cosmos.repository.support.StringBasedCosmosQuery;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;

public class CosmosRepositoryFactory
extends RepositoryFactorySupport {
    private final CosmosOperations cosmosOperations;

    public CosmosRepositoryFactory(CosmosOperations cosmosOperations) {
        this.cosmosOperations = cosmosOperations;
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleCosmosRepository.class;
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        EntityInformation entityInformation = this.getEntityInformation(information.getDomainType());
        return this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, this.cosmosOperations});
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainType) {
        return new CosmosEntityInformation(domainType);
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new CosmosDbQueryLookupStrategy(this.cosmosOperations, evaluationContextProvider));
    }

    private static class CosmosDbQueryLookupStrategy
    implements QueryLookupStrategy {
        private final CosmosOperations dbOperations;

        CosmosDbQueryLookupStrategy(CosmosOperations operations, QueryMethodEvaluationContextProvider provider) {
            this.dbOperations = operations;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            CosmosQueryMethod queryMethod = new CosmosQueryMethod(method, metadata, factory);
            Assert.notNull((Object)((Object)queryMethod), (String)"queryMethod must not be null!");
            Assert.notNull((Object)this.dbOperations, (String)"dbOperations must not be null!");
            if (queryMethod.hasAnnotatedQuery()) {
                return new StringBasedCosmosQuery(queryMethod, this.dbOperations);
            }
            return new PartTreeCosmosQuery(queryMethod, this.dbOperations);
        }
    }
}

