/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.keys.implementation.models.JsonWebKeySignatureAlgorithm;
import java.io.IOException;
import java.util.Objects;

public final class KeyVerifyParameters
implements JsonSerializable<KeyVerifyParameters> {
    private final JsonWebKeySignatureAlgorithm algorithm;
    private final Base64Url digest;
    private final Base64Url signature;

    public KeyVerifyParameters(JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        this.algorithm = algorithm;
        this.digest = digest == null ? null : Base64Url.encode((byte[])digest);
        this.signature = signature == null ? null : Base64Url.encode((byte[])signature);
    }

    public JsonWebKeySignatureAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getDigest() {
        if (this.digest == null) {
            return null;
        }
        return this.digest.decodedBytes();
    }

    public byte[] getSignature() {
        if (this.signature == null) {
            return null;
        }
        return this.signature.decodedBytes();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("alg", this.algorithm == null ? null : this.algorithm.toString());
        jsonWriter.writeStringField("digest", Objects.toString(this.digest, null));
        jsonWriter.writeStringField("value", Objects.toString(this.signature, null));
        return jsonWriter.writeEndObject();
    }

    public static KeyVerifyParameters fromJson(JsonReader jsonReader) throws IOException {
        return (KeyVerifyParameters)jsonReader.readObject(reader -> {
            JsonWebKeySignatureAlgorithm algorithm = null;
            byte[] digest = null;
            byte[] signature = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("alg".equals(fieldName)) {
                    algorithm = JsonWebKeySignatureAlgorithm.fromString(reader.getString());
                    continue;
                }
                if ("digest".equals(fieldName)) {
                    Base64Url digestHolder = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    if (digestHolder == null) continue;
                    digest = digestHolder.decodedBytes();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    Base64Url signatureHolder = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    if (signatureHolder == null) continue;
                    signature = signatureHolder.decodedBytes();
                    continue;
                }
                reader.skipChildren();
            }
            return new KeyVerifyParameters(algorithm, digest, signature);
        });
    }
}

