/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.keys.implementation.models.JsonWebKey;
import com.azure.security.keyvault.keys.implementation.models.KeyAttributes;
import com.azure.security.keyvault.keys.implementation.models.KeyReleasePolicy;
import java.io.IOException;
import java.util.Map;

public final class KeyBundle
implements JsonSerializable<KeyBundle> {
    private JsonWebKey key;
    private KeyAttributes attributes;
    private Map<String, String> tags;
    private Boolean managed;
    private KeyReleasePolicy releasePolicy;

    private KeyBundle() {
    }

    public JsonWebKey getKey() {
        return this.key;
    }

    public KeyAttributes getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Boolean isManaged() {
        return this.managed;
    }

    public KeyReleasePolicy getReleasePolicy() {
        return this.releasePolicy;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("key", (JsonSerializable)this.key);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("release_policy", (JsonSerializable)this.releasePolicy);
        return jsonWriter.writeEndObject();
    }

    public static KeyBundle fromJson(JsonReader jsonReader) throws IOException {
        return (KeyBundle)jsonReader.readObject(reader -> {
            KeyBundle deserializedKeyBundle = new KeyBundle();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedKeyBundle.key = JsonWebKey.fromJson(reader);
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedKeyBundle.attributes = KeyAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedKeyBundle.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("managed".equals(fieldName)) {
                    deserializedKeyBundle.managed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("release_policy".equals(fieldName)) {
                    deserializedKeyBundle.releasePolicy = KeyReleasePolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyBundle;
        });
    }
}

