/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography.implementation;

import com.azure.core.util.Context;
import com.azure.security.keyvault.keys.cryptography.implementation.Algorithm;
import com.azure.security.keyvault.keys.cryptography.implementation.AlgorithmResolver;
import com.azure.security.keyvault.keys.cryptography.implementation.AsymmetricEncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.implementation.CryptographyClientImpl;
import com.azure.security.keyvault.keys.cryptography.implementation.CryptographyUtils;
import com.azure.security.keyvault.keys.cryptography.implementation.HashAlgorithm;
import com.azure.security.keyvault.keys.cryptography.implementation.ICryptoTransform;
import com.azure.security.keyvault.keys.cryptography.implementation.LocalKeyCryptographyClient;
import com.azure.security.keyvault.keys.cryptography.implementation.SignatureHashResolver;
import com.azure.security.keyvault.keys.cryptography.models.DecryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.DecryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.EncryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.SignResult;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.UnwrapResult;
import com.azure.security.keyvault.keys.cryptography.models.VerifyResult;
import com.azure.security.keyvault.keys.cryptography.models.WrapResult;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyOperation;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import reactor.core.publisher.Mono;

class RsaKeyCryptographyClient
extends LocalKeyCryptographyClient {
    private final KeyPair rsaKeyPair;

    RsaKeyCryptographyClient(JsonWebKey jsonWebKey, CryptographyClientImpl implClient) {
        super(jsonWebKey, implClient);
        this.rsaKeyPair = jsonWebKey.toRsa(jsonWebKey.hasPrivateKey());
    }

    @Override
    public Mono<EncryptResult> encryptAsync(EncryptionAlgorithm algorithm, byte[] plaintext, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(plaintext, "Plaintext cannot be null.");
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.implClient != null) {
                return this.implClient.encryptAsync(algorithm, plaintext, context);
            }
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (!(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (this.rsaKeyPair.getPublic() == null) {
            if (this.implClient != null) {
                return this.implClient.encryptAsync(algorithm, plaintext, context);
            }
            throw new IllegalArgumentException("The public portion of the key is not available to perform the encrypt operation.");
        }
        CryptographyUtils.verifyKeyPermissions(this.jsonWebKey, KeyOperation.ENCRYPT);
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        return Mono.fromCallable(() -> {
            ICryptoTransform transform = algo.createEncryptor(this.rsaKeyPair);
            return new EncryptResult(transform.doFinal(plaintext), algorithm, this.jsonWebKey.getId());
        });
    }

    @Override
    public EncryptResult encrypt(EncryptionAlgorithm algorithm, byte[] plaintext, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(plaintext, "Plaintext cannot be null.");
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.implClient != null) {
                return this.implClient.encrypt(algorithm, plaintext, context);
            }
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (!(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (this.rsaKeyPair.getPublic() == null) {
            if (this.implClient != null) {
                return this.implClient.encrypt(algorithm, plaintext, context);
            }
            throw new IllegalArgumentException("The public portion of the key is not available to perform the encrypt operation.");
        }
        CryptographyUtils.verifyKeyPermissions(this.jsonWebKey, KeyOperation.ENCRYPT);
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        try {
            ICryptoTransform transform = algo.createEncryptor(this.rsaKeyPair);
            return new EncryptResult(transform.doFinal(plaintext), algorithm, this.jsonWebKey.getId());
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Mono<EncryptResult> encryptAsync(EncryptParameters encryptParameters, Context context) {
        return Mono.fromCallable(() -> this.encrypt(encryptParameters, context));
    }

    @Override
    public EncryptResult encrypt(EncryptParameters encryptParameters, Context context) {
        Objects.requireNonNull(encryptParameters, "Encrypt parameters cannot be null.");
        return this.encrypt(encryptParameters.getAlgorithm(), encryptParameters.getPlainText(), context);
    }

    @Override
    public Mono<DecryptResult> decryptAsync(EncryptionAlgorithm algorithm, byte[] ciphertext, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(ciphertext, "Ciphertext cannot be null.");
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.implClient != null) {
                return this.implClient.decryptAsync(algorithm, ciphertext, context);
            }
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (!(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (this.rsaKeyPair.getPrivate() == null) {
            if (this.implClient != null) {
                return this.implClient.decryptAsync(algorithm, ciphertext, context);
            }
            throw new IllegalArgumentException("The private portion of the key is not available to perform the decrypt operation.");
        }
        CryptographyUtils.verifyKeyPermissions(this.jsonWebKey, KeyOperation.DECRYPT);
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        return Mono.fromCallable(() -> {
            ICryptoTransform transform = algo.createDecryptor(this.rsaKeyPair);
            return new DecryptResult(transform.doFinal(ciphertext), algorithm, this.jsonWebKey.getId());
        });
    }

    @Override
    public DecryptResult decrypt(EncryptionAlgorithm algorithm, byte[] ciphertext, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(ciphertext, "Ciphertext cannot be null.");
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.implClient != null) {
                return this.implClient.decrypt(algorithm, ciphertext, context);
            }
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (!(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (this.rsaKeyPair.getPrivate() == null) {
            if (this.implClient != null) {
                return this.implClient.decrypt(algorithm, ciphertext, context);
            }
            throw new IllegalArgumentException("The private portion of the key is not available to perform the decrypt operation.");
        }
        CryptographyUtils.verifyKeyPermissions(this.jsonWebKey, KeyOperation.DECRYPT);
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        try {
            ICryptoTransform transform = algo.createDecryptor(this.rsaKeyPair);
            return new DecryptResult(transform.doFinal(ciphertext), algorithm, this.jsonWebKey.getId());
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Mono<DecryptResult> decryptAsync(DecryptParameters decryptParameters, Context context) {
        return Mono.fromCallable(() -> this.decrypt(decryptParameters, context));
    }

    @Override
    public DecryptResult decrypt(DecryptParameters decryptParameters, Context context) {
        Objects.requireNonNull(decryptParameters, "Decrypt parameters cannot be null.");
        return this.decrypt(decryptParameters.getAlgorithm(), decryptParameters.getCipherText(), context);
    }

    @Override
    public Mono<SignResult> signAsync(SignatureAlgorithm algorithm, byte[] digest, Context context) {
        return this.implClient != null ? this.implClient.signAsync(algorithm, digest, context) : Mono.error((Throwable)new UnsupportedOperationException("The sign operation on local RSA key is not currently supported."));
    }

    @Override
    public SignResult sign(SignatureAlgorithm algorithm, byte[] digest, Context context) {
        if (this.implClient != null) {
            return this.implClient.sign(algorithm, digest, context);
        }
        throw new UnsupportedOperationException("The sign operation on local RSA key is not currently supported.");
    }

    @Override
    public Mono<VerifyResult> verifyAsync(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context) {
        return this.implClient != null ? this.implClient.verifyAsync(algorithm, digest, signature, context) : Mono.error((Throwable)new UnsupportedOperationException("The verify operation on a local RSA key is not currently supported."));
    }

    @Override
    public VerifyResult verify(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context) {
        if (this.implClient != null) {
            return this.implClient.verify(algorithm, digest, signature, context);
        }
        throw new UnsupportedOperationException("The verify operation on a local RSA key is not currently supported.");
    }

    @Override
    public Mono<WrapResult> wrapKeyAsync(KeyWrapAlgorithm algorithm, byte[] keyToWrap, Context context) {
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(keyToWrap, "Key content to be wrapped cannot be null.");
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.implClient != null) {
                return this.implClient.wrapKeyAsync(algorithm, keyToWrap, context);
            }
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (!(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (this.rsaKeyPair.getPublic() == null) {
            if (this.implClient != null) {
                return this.implClient.wrapKeyAsync(algorithm, keyToWrap, context);
            }
            throw new IllegalArgumentException("The public portion of the key is not available to perform the key wrap operation.");
        }
        CryptographyUtils.verifyKeyPermissions(this.jsonWebKey, KeyOperation.WRAP_KEY);
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        return Mono.fromCallable(() -> {
            ICryptoTransform transform = algo.createEncryptor(this.rsaKeyPair);
            return new WrapResult(transform.doFinal(keyToWrap), algorithm, this.jsonWebKey.getId());
        });
    }

    @Override
    public WrapResult wrapKey(KeyWrapAlgorithm algorithm, byte[] keyToWrap, Context context) {
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(keyToWrap, "Key content to be wrapped cannot be null.");
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.implClient != null) {
                return this.implClient.wrapKey(algorithm, keyToWrap, context);
            }
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (!(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (this.rsaKeyPair.getPublic() == null) {
            if (this.implClient != null) {
                return this.implClient.wrapKey(algorithm, keyToWrap, context);
            }
            throw new IllegalArgumentException("The public portion of the key is not available to perform the key wrap operation.");
        }
        CryptographyUtils.verifyKeyPermissions(this.jsonWebKey, KeyOperation.WRAP_KEY);
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        try {
            ICryptoTransform transform = algo.createEncryptor(this.rsaKeyPair);
            return new WrapResult(transform.doFinal(keyToWrap), algorithm, this.jsonWebKey.getId());
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Mono<UnwrapResult> unwrapKeyAsync(KeyWrapAlgorithm algorithm, byte[] encryptedKey, Context context) {
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(encryptedKey, "Encrypted key content to be unwrapped cannot be null.");
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.implClient != null) {
                return this.implClient.unwrapKeyAsync(algorithm, encryptedKey, context);
            }
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (!(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (this.rsaKeyPair.getPrivate() == null) {
            if (this.implClient != null) {
                return this.implClient.unwrapKeyAsync(algorithm, encryptedKey, context);
            }
            throw new IllegalArgumentException("The private portion of the key is not available to perform the key unwrap operation.");
        }
        CryptographyUtils.verifyKeyPermissions(this.jsonWebKey, KeyOperation.UNWRAP_KEY);
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        return Mono.fromCallable(() -> {
            ICryptoTransform transform = algo.createDecryptor(this.rsaKeyPair);
            return new UnwrapResult(transform.doFinal(encryptedKey), algorithm, this.jsonWebKey.getId());
        });
    }

    @Override
    public UnwrapResult unwrapKey(KeyWrapAlgorithm algorithm, byte[] encryptedKey, Context context) {
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(encryptedKey, "Encrypted key content to be unwrapped cannot be null.");
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.implClient != null) {
                return this.implClient.unwrapKey(algorithm, encryptedKey, context);
            }
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (!(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (this.rsaKeyPair.getPrivate() == null) {
            if (this.implClient != null) {
                return this.implClient.unwrapKey(algorithm, encryptedKey, context);
            }
            throw new IllegalArgumentException("The private portion of the key is not available to perform the key unwrap operation.");
        }
        CryptographyUtils.verifyKeyPermissions(this.jsonWebKey, KeyOperation.UNWRAP_KEY);
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        try {
            ICryptoTransform transform = algo.createDecryptor(this.rsaKeyPair);
            return new UnwrapResult(transform.doFinal(encryptedKey), algorithm, this.jsonWebKey.getId());
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Mono<SignResult> signDataAsync(SignatureAlgorithm algorithm, byte[] data, Context context) {
        try {
            return this.signAsync(algorithm, RsaKeyCryptographyClient.calculateDigest(algorithm, data), context);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SignResult signData(SignatureAlgorithm algorithm, byte[] data, Context context) {
        try {
            return this.sign(algorithm, RsaKeyCryptographyClient.calculateDigest(algorithm, data), context);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Mono<VerifyResult> verifyDataAsync(SignatureAlgorithm algorithm, byte[] data, byte[] signature, Context context) {
        try {
            return this.verifyAsync(algorithm, RsaKeyCryptographyClient.calculateDigest(algorithm, data), signature, context);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public VerifyResult verifyData(SignatureAlgorithm algorithm, byte[] data, byte[] signature, Context context) {
        try {
            return this.verify(algorithm, RsaKeyCryptographyClient.calculateDigest(algorithm, data), signature, context);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] calculateDigest(SignatureAlgorithm algorithm, byte[] data) throws NoSuchAlgorithmException {
        HashAlgorithm hashAlgorithm = SignatureHashResolver.DEFAULT.get(algorithm);
        MessageDigest md = MessageDigest.getInstance(Objects.toString((Object)hashAlgorithm, null));
        md.update(data);
        return md.digest();
    }
}

