/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.models.CertificateKeyCurveName;
import com.azure.security.keyvault.certificates.models.CertificateKeyType;
import java.io.IOException;

public final class KeyProperties
implements JsonSerializable<KeyProperties> {
    private Boolean exportable;
    private CertificateKeyType keyType;
    private Integer keySize;
    private Boolean reuseKey;
    private CertificateKeyCurveName curve;

    public Boolean isExportable() {
        return this.exportable;
    }

    public KeyProperties setExportable(Boolean exportable) {
        this.exportable = exportable;
        return this;
    }

    public CertificateKeyType getKeyType() {
        return this.keyType;
    }

    public KeyProperties setKeyType(CertificateKeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    public Integer getKeySize() {
        return this.keySize;
    }

    public KeyProperties setKeySize(Integer keySize) {
        this.keySize = keySize;
        return this;
    }

    public Boolean isReuseKey() {
        return this.reuseKey;
    }

    public KeyProperties setReuseKey(Boolean reuseKey) {
        this.reuseKey = reuseKey;
        return this;
    }

    public CertificateKeyCurveName getCurve() {
        return this.curve;
    }

    public KeyProperties setCurve(CertificateKeyCurveName curve) {
        this.curve = curve;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("exportable", this.exportable);
        jsonWriter.writeStringField("kty", this.keyType == null ? null : this.keyType.toString());
        jsonWriter.writeNumberField("key_size", (Number)this.keySize);
        jsonWriter.writeBooleanField("reuse_key", this.reuseKey);
        jsonWriter.writeStringField("crv", this.curve == null ? null : this.curve.toString());
        return jsonWriter.writeEndObject();
    }

    public static KeyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (KeyProperties)jsonReader.readObject(reader -> {
            KeyProperties deserializedKeyProperties = new KeyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("exportable".equals(fieldName)) {
                    deserializedKeyProperties.exportable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("kty".equals(fieldName)) {
                    deserializedKeyProperties.keyType = CertificateKeyType.fromString(reader.getString());
                    continue;
                }
                if ("key_size".equals(fieldName)) {
                    deserializedKeyProperties.keySize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("reuse_key".equals(fieldName)) {
                    deserializedKeyProperties.reuseKey = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("crv".equals(fieldName)) {
                    deserializedKeyProperties.curve = CertificateKeyCurveName.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyProperties;
        });
    }
}

