/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.models.CertificateAttributes;
import com.azure.security.keyvault.certificates.models.CertificateProperties;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class KeyVaultCertificate
implements JsonSerializable<KeyVaultCertificate> {
    private final byte[] cer;
    private final String keyId;
    private final String secretId;
    private CertificateProperties properties;

    KeyVaultCertificate() {
        this(null, null, null, new CertificateProperties());
    }

    KeyVaultCertificate(byte[] cer, String keyId, String secretId, CertificateProperties properties) {
        this.cer = CoreUtils.clone((byte[])cer);
        this.keyId = keyId;
        this.secretId = secretId;
        this.properties = properties;
    }

    public CertificateProperties getProperties() {
        return this.properties;
    }

    public KeyVaultCertificate setProperties(CertificateProperties properties) {
        Objects.requireNonNull(properties, "The certificate properties cannot be null");
        properties.setName(this.properties.getName());
        this.properties = properties;
        return this;
    }

    public String getId() {
        return this.properties.getId();
    }

    public String getName() {
        return this.properties.getName();
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public byte[] getCer() {
        return CoreUtils.clone((byte[])this.cer);
    }

    public Boolean isCertificateOrderPreserved() {
        return this.properties.isCertificateOrderPreserved();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeBinaryField("cer", this.cer).writeEndObject();
    }

    public static KeyVaultCertificate fromJson(JsonReader jsonReader) throws IOException {
        return (KeyVaultCertificate)jsonReader.readObject(reader -> {
            String id = null;
            CertificateAttributes attributes = null;
            Map tags = null;
            byte[] wireThumbprint = null;
            byte[] cer = null;
            String keyId = null;
            String secretId = null;
            boolean certificateOrderPreserved = false;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    attributes = CertificateAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(JsonReader::getString);
                    continue;
                }
                if ("x5t".equals(fieldName)) {
                    wireThumbprint = reader.getBinary();
                    continue;
                }
                if ("cer".equals(fieldName)) {
                    cer = reader.getBinary();
                    continue;
                }
                if ("kid".equals(fieldName)) {
                    keyId = reader.getString();
                    continue;
                }
                if ("sid".equals(fieldName)) {
                    secretId = reader.getString();
                    continue;
                }
                if ("preserveCertOrder".equals(fieldName)) {
                    certificateOrderPreserved = reader.getBoolean();
                    continue;
                }
                reader.skipChildren();
            }
            return new KeyVaultCertificate(cer, keyId, secretId, new CertificateProperties(id, attributes, tags, wireThumbprint, null, certificateOrderPreserved));
        });
    }
}

