/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.confidentialledger.certificate.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.security.confidentialledger.certificate.ConfidentialLedgerCertificateServiceVersion;
import reactor.core.publisher.Mono;

public final class ConfidentialLedgerCertificateClientImpl {
    private final ConfidentialLedgerCertificateClientService service;
    private final String certificateEndpoint;
    private final ConfidentialLedgerCertificateServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getCertificateEndpoint() {
        return this.certificateEndpoint;
    }

    public ConfidentialLedgerCertificateServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public ConfidentialLedgerCertificateClientImpl(String certificateEndpoint, ConfidentialLedgerCertificateServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), certificateEndpoint, serviceVersion);
    }

    public ConfidentialLedgerCertificateClientImpl(HttpPipeline httpPipeline, String certificateEndpoint, ConfidentialLedgerCertificateServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), certificateEndpoint, serviceVersion);
    }

    public ConfidentialLedgerCertificateClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String certificateEndpoint, ConfidentialLedgerCertificateServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.certificateEndpoint = certificateEndpoint;
        this.serviceVersion = serviceVersion;
        this.service = (ConfidentialLedgerCertificateClientService)RestProxy.create(ConfidentialLedgerCertificateClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getLedgerIdentityWithResponseAsync(String ledgerId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getLedgerIdentity(this.getCertificateEndpoint(), this.getServiceVersion().getVersion(), ledgerId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getLedgerIdentityWithResponseAsync(String ledgerId, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.getLedgerIdentity(this.getCertificateEndpoint(), this.getServiceVersion().getVersion(), ledgerId, "application/json", requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getLedgerIdentityWithResponse(String ledgerId, RequestOptions requestOptions) {
        return (Response)this.getLedgerIdentityWithResponseAsync(ledgerId, requestOptions).block();
    }

    @Host(value="{certificateEndpoint}")
    @ServiceInterface(name="ConfidentialLedgerCe")
    private static interface ConfidentialLedgerCertificateClientService {
        @Get(value="/ledgerIdentity/{ledgerId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getLedgerIdentity(@HostParam(value="certificateEndpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="ledgerId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);
    }
}

