/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.confidentialledger;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.security.confidentialledger.ConfidentialLedgerAsyncClient;
import com.azure.security.confidentialledger.ConfidentialLedgerClientBuilder;

@ServiceClient(builder=ConfidentialLedgerClientBuilder.class)
public final class ConfidentialLedgerClient {
    private final ConfidentialLedgerAsyncClient client;

    ConfidentialLedgerClient(ConfidentialLedgerAsyncClient client) {
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getConstitutionWithResponse(RequestOptions requestOptions) {
        return (Response)this.client.getConstitutionWithResponse(requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listConsortiumMembers(RequestOptions requestOptions) {
        return new PagedIterable(this.client.listConsortiumMembers(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getEnclaveQuotesWithResponse(RequestOptions requestOptions) {
        return (Response)this.client.getEnclaveQuotesWithResponse(requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listCollections(RequestOptions requestOptions) {
        return new PagedIterable(this.client.listCollections(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listLedgerEntries(RequestOptions requestOptions) {
        return new PagedIterable(this.client.listLedgerEntries(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createLedgerEntryWithResponse(BinaryData entry, RequestOptions requestOptions) {
        return (Response)this.client.createLedgerEntryWithResponse(entry, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getLedgerEntryWithResponse(String transactionId, RequestOptions requestOptions) {
        return (Response)this.client.getLedgerEntryWithResponse(transactionId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getReceiptWithResponse(String transactionId, RequestOptions requestOptions) {
        return (Response)this.client.getReceiptWithResponse(transactionId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTransactionStatusWithResponse(String transactionId, RequestOptions requestOptions) {
        return (Response)this.client.getTransactionStatusWithResponse(transactionId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCurrentLedgerEntryWithResponse(RequestOptions requestOptions) {
        return (Response)this.client.getCurrentLedgerEntryWithResponse(requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteUserWithResponse(String userId, RequestOptions requestOptions) {
        return (Response)this.client.deleteUserWithResponse(userId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getUserWithResponse(String userId, RequestOptions requestOptions) {
        return (Response)this.client.getUserWithResponse(userId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateUserWithResponse(String userId, BinaryData userDetails, RequestOptions requestOptions) {
        return (Response)this.client.createOrUpdateUserWithResponse(userId, userDetails, requestOptions).block();
    }
}

