/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.search.documents.models.QueryRewritesType;
import java.util.HashMap;
import java.util.Objects;

public class QueryRewrites {
    private final QueryRewritesType rewritesType;
    private Integer count;

    public QueryRewrites(QueryRewritesType rewritesType) {
        this.rewritesType = Objects.requireNonNull(rewritesType, "'rewritesType' cannot be null");
    }

    public QueryRewritesType getRewritesType() {
        return this.rewritesType;
    }

    public Integer getCount() {
        return this.count;
    }

    public QueryRewrites setCount(Integer count) {
        this.count = count;
        return this;
    }

    public String toString() {
        String queryRewritesTypeString = this.rewritesType.toString();
        if (this.rewritesType == QueryRewritesType.NONE || this.count == null) {
            return queryRewritesTypeString;
        }
        return queryRewritesTypeString + "|count-" + this.count;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rewritesType, this.count});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QueryRewrites)) {
            return false;
        }
        QueryRewrites other = (QueryRewrites)obj;
        return Objects.equals((Object)this.rewritesType, (Object)other.rewritesType) && Objects.equals(this.count, other.count);
    }

    public static QueryRewrites fromString(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        if (!str.contains("|")) {
            return new QueryRewrites(QueryRewritesType.fromString(str));
        }
        String[] parts = new String[]{str.substring(0, str.indexOf("|")), str.substring(str.indexOf("|") + 1)};
        QueryRewritesType rewritesType = QueryRewritesType.fromString(parts[0]);
        HashMap<String, String> queryRewriteOptions = new HashMap<String, String>();
        for (String queryRewriteOption : parts[1].split(",")) {
            if (!queryRewriteOption.contains("-")) continue;
            String[] optionParts = queryRewriteOption.split("-");
            queryRewriteOptions.putIfAbsent(optionParts[0], optionParts[1]);
        }
        QueryRewrites queryRewrites = new QueryRewrites(rewritesType);
        if (queryRewriteOptions.containsKey("count")) {
            queryRewrites.setCount(Integer.parseInt(queryRewriteOptions.get("count").toString()));
        }
        return queryRewrites;
    }
}

