/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.models.HybridCountAndFacetMode;
import java.io.IOException;

public final class HybridSearch
implements JsonSerializable<HybridSearch> {
    private Integer maxTextRecallSize;
    private HybridCountAndFacetMode countAndFacetMode;

    public Integer getMaxTextRecallSize() {
        return this.maxTextRecallSize;
    }

    public HybridSearch setMaxTextRecallSize(Integer maxTextRecallSize) {
        this.maxTextRecallSize = maxTextRecallSize;
        return this;
    }

    public HybridCountAndFacetMode getCountAndFacetMode() {
        return this.countAndFacetMode;
    }

    public HybridSearch setCountAndFacetMode(HybridCountAndFacetMode countAndFacetMode) {
        this.countAndFacetMode = countAndFacetMode;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("maxTextRecallSize", (Number)this.maxTextRecallSize);
        jsonWriter.writeStringField("countAndFacetMode", this.countAndFacetMode == null ? null : this.countAndFacetMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static HybridSearch fromJson(JsonReader jsonReader) throws IOException {
        return (HybridSearch)jsonReader.readObject(reader -> {
            HybridSearch deserializedHybridSearch = new HybridSearch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxTextRecallSize".equals(fieldName)) {
                    deserializedHybridSearch.maxTextRecallSize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("countAndFacetMode".equals(fieldName)) {
                    deserializedHybridSearch.countAndFacetMode = HybridCountAndFacetMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHybridSearch;
        });
    }
}

