/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class VisionVectorizeSkill
extends SearchIndexerSkill {
    private String odataType = "#Microsoft.Skills.Vision.VectorizeSkill";
    private final String modelVersion;

    public VisionVectorizeSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs, String modelVersion) {
        super(inputs, outputs);
        this.modelVersion = modelVersion;
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    @Override
    public VisionVectorizeSkill setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public VisionVectorizeSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public VisionVectorizeSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("inputs", this.getInputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.getOutputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("context", this.getContext());
        jsonWriter.writeStringField("modelVersion", this.modelVersion);
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    public static VisionVectorizeSkill fromJson(JsonReader jsonReader) throws IOException {
        return (VisionVectorizeSkill)jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List inputs = null;
            boolean outputsFound = false;
            List outputs = null;
            String name = null;
            String description = null;
            String context = null;
            boolean modelVersionFound = false;
            String modelVersion = null;
            String odataType = "#Microsoft.Skills.Vision.VectorizeSkill";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    context = reader.getString();
                    continue;
                }
                if ("modelVersion".equals(fieldName)) {
                    modelVersion = reader.getString();
                    modelVersionFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (inputsFound && outputsFound && modelVersionFound) {
                VisionVectorizeSkill deserializedVisionVectorizeSkill = new VisionVectorizeSkill(inputs, outputs, modelVersion);
                deserializedVisionVectorizeSkill.setName(name);
                deserializedVisionVectorizeSkill.setDescription(description);
                deserializedVisionVectorizeSkill.setContext(context);
                deserializedVisionVectorizeSkill.odataType = odataType;
                return deserializedVisionVectorizeSkill;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            if (!modelVersionFound) {
                missingProperties.add("modelVersion");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

