/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.AIServicesVisionVectorizer;
import com.azure.search.documents.indexes.models.AzureMachineLearningVectorizer;
import com.azure.search.documents.indexes.models.AzureOpenAIVectorizer;
import com.azure.search.documents.indexes.models.VectorSearchVectorizerKind;
import com.azure.search.documents.indexes.models.WebApiVectorizer;
import java.io.IOException;

public class VectorSearchVectorizer
implements JsonSerializable<VectorSearchVectorizer> {
    private VectorSearchVectorizerKind kind = VectorSearchVectorizerKind.fromString("VectorSearchVectorizer");
    private final String vectorizerName;

    public VectorSearchVectorizer(String vectorizerName) {
        this.vectorizerName = vectorizerName;
    }

    public VectorSearchVectorizerKind getKind() {
        return this.kind;
    }

    public String getVectorizerName() {
        return this.vectorizerName;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.vectorizerName);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static VectorSearchVectorizer fromJson(JsonReader jsonReader) throws IOException {
        return (VectorSearchVectorizer)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                VectorSearchVectorizer vectorSearchVectorizer;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("azureOpenAI".equals(discriminatorValue)) {
                    vectorSearchVectorizer = AzureOpenAIVectorizer.fromJson(readerToUse.reset());
                    return vectorSearchVectorizer;
                }
                if ("customWebApi".equals(discriminatorValue)) {
                    vectorSearchVectorizer = WebApiVectorizer.fromJson(readerToUse.reset());
                    return vectorSearchVectorizer;
                }
                if ("aiServicesVision".equals(discriminatorValue)) {
                    vectorSearchVectorizer = AIServicesVisionVectorizer.fromJson(readerToUse.reset());
                    return vectorSearchVectorizer;
                }
                if ("aml".equals(discriminatorValue)) {
                    vectorSearchVectorizer = AzureMachineLearningVectorizer.fromJson(readerToUse.reset());
                    return vectorSearchVectorizer;
                }
                vectorSearchVectorizer = VectorSearchVectorizer.fromJsonKnownDiscriminator(readerToUse.reset());
                return vectorSearchVectorizer;
            }
        });
    }

    static VectorSearchVectorizer fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (VectorSearchVectorizer)jsonReader.readObject(reader -> {
            boolean vectorizerNameFound = false;
            String vectorizerName = null;
            VectorSearchVectorizerKind kind = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    vectorizerName = reader.getString();
                    vectorizerNameFound = true;
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = VectorSearchVectorizerKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (vectorizerNameFound) {
                VectorSearchVectorizer deserializedVectorSearchVectorizer = new VectorSearchVectorizer(vectorizerName);
                deserializedVectorSearchVectorizer.kind = kind;
                return deserializedVectorSearchVectorizer;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

