/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.AzureOpenAITokenizerParameters;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import com.azure.search.documents.indexes.models.SplitSkillLanguage;
import com.azure.search.documents.indexes.models.SplitSkillUnit;
import com.azure.search.documents.indexes.models.TextSplitMode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class SplitSkill
extends SearchIndexerSkill {
    private String odataType = "#Microsoft.Skills.Text.SplitSkill";
    private SplitSkillLanguage defaultLanguageCode;
    private TextSplitMode textSplitMode;
    private Integer maximumPageLength;
    private Integer pageOverlapLength;
    private Integer maximumPagesToTake;
    private SplitSkillUnit unit;
    private AzureOpenAITokenizerParameters azureOpenAITokenizerParameters;

    public SplitSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public SplitSkillLanguage getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    public SplitSkill setDefaultLanguageCode(SplitSkillLanguage defaultLanguageCode) {
        this.defaultLanguageCode = defaultLanguageCode;
        return this;
    }

    public TextSplitMode getTextSplitMode() {
        return this.textSplitMode;
    }

    public SplitSkill setTextSplitMode(TextSplitMode textSplitMode) {
        this.textSplitMode = textSplitMode;
        return this;
    }

    public Integer getMaximumPageLength() {
        return this.maximumPageLength;
    }

    public SplitSkill setMaximumPageLength(Integer maximumPageLength) {
        this.maximumPageLength = maximumPageLength;
        return this;
    }

    public Integer getPageOverlapLength() {
        return this.pageOverlapLength;
    }

    public SplitSkill setPageOverlapLength(Integer pageOverlapLength) {
        this.pageOverlapLength = pageOverlapLength;
        return this;
    }

    public Integer getMaximumPagesToTake() {
        return this.maximumPagesToTake;
    }

    public SplitSkill setMaximumPagesToTake(Integer maximumPagesToTake) {
        this.maximumPagesToTake = maximumPagesToTake;
        return this;
    }

    public SplitSkillUnit getUnit() {
        return this.unit;
    }

    public SplitSkill setUnit(SplitSkillUnit unit) {
        this.unit = unit;
        return this;
    }

    public AzureOpenAITokenizerParameters getAzureOpenAITokenizerParameters() {
        return this.azureOpenAITokenizerParameters;
    }

    public SplitSkill setAzureOpenAITokenizerParameters(AzureOpenAITokenizerParameters azureOpenAITokenizerParameters) {
        this.azureOpenAITokenizerParameters = azureOpenAITokenizerParameters;
        return this;
    }

    @Override
    public SplitSkill setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public SplitSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SplitSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("inputs", this.getInputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.getOutputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("context", this.getContext());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeStringField("defaultLanguageCode", this.defaultLanguageCode == null ? null : this.defaultLanguageCode.toString());
        jsonWriter.writeStringField("textSplitMode", this.textSplitMode == null ? null : this.textSplitMode.toString());
        jsonWriter.writeNumberField("maximumPageLength", (Number)this.maximumPageLength);
        jsonWriter.writeNumberField("pageOverlapLength", (Number)this.pageOverlapLength);
        jsonWriter.writeNumberField("maximumPagesToTake", (Number)this.maximumPagesToTake);
        jsonWriter.writeStringField("unit", this.unit == null ? null : this.unit.toString());
        jsonWriter.writeJsonField("azureOpenAITokenizerParameters", (JsonSerializable)this.azureOpenAITokenizerParameters);
        return jsonWriter.writeEndObject();
    }

    public static SplitSkill fromJson(JsonReader jsonReader) throws IOException {
        return (SplitSkill)jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List inputs = null;
            boolean outputsFound = false;
            List outputs = null;
            String name = null;
            String description = null;
            String context = null;
            String odataType = "#Microsoft.Skills.Text.SplitSkill";
            SplitSkillLanguage defaultLanguageCode = null;
            TextSplitMode textSplitMode = null;
            Integer maximumPageLength = null;
            Integer pageOverlapLength = null;
            Integer maximumPagesToTake = null;
            SplitSkillUnit unit = null;
            AzureOpenAITokenizerParameters azureOpenAITokenizerParameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    context = reader.getString();
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("defaultLanguageCode".equals(fieldName)) {
                    defaultLanguageCode = SplitSkillLanguage.fromString(reader.getString());
                    continue;
                }
                if ("textSplitMode".equals(fieldName)) {
                    textSplitMode = TextSplitMode.fromString(reader.getString());
                    continue;
                }
                if ("maximumPageLength".equals(fieldName)) {
                    maximumPageLength = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("pageOverlapLength".equals(fieldName)) {
                    pageOverlapLength = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maximumPagesToTake".equals(fieldName)) {
                    maximumPagesToTake = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    unit = SplitSkillUnit.fromString(reader.getString());
                    continue;
                }
                if ("azureOpenAITokenizerParameters".equals(fieldName)) {
                    azureOpenAITokenizerParameters = AzureOpenAITokenizerParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (inputsFound && outputsFound) {
                SplitSkill deserializedSplitSkill = new SplitSkill(inputs, outputs);
                deserializedSplitSkill.setName(name);
                deserializedSplitSkill.setDescription(description);
                deserializedSplitSkill.setContext(context);
                deserializedSplitSkill.odataType = odataType;
                deserializedSplitSkill.defaultLanguageCode = defaultLanguageCode;
                deserializedSplitSkill.textSplitMode = textSplitMode;
                deserializedSplitSkill.maximumPageLength = maximumPageLength;
                deserializedSplitSkill.pageOverlapLength = pageOverlapLength;
                deserializedSplitSkill.maximumPagesToTake = maximumPagesToTake;
                deserializedSplitSkill.unit = unit;
                deserializedSplitSkill.azureOpenAITokenizerParameters = azureOpenAITokenizerParameters;
                return deserializedSplitSkill;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

