/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.implementation.models.AzureActiveDirectoryApplicationCredentials;
import com.azure.search.documents.indexes.models.SearchIndexerDataIdentity;
import java.io.IOException;
import java.util.ArrayList;

public final class SearchResourceEncryptionKey
implements JsonSerializable<SearchResourceEncryptionKey> {
    private final String keyName;
    private String keyVersion;
    private final String vaultUrl;
    private AzureActiveDirectoryApplicationCredentials accessCredentials;
    private SearchIndexerDataIdentity identity;

    public SearchResourceEncryptionKey(String keyName, String vaultUrl) {
        this.keyName = keyName;
        this.vaultUrl = vaultUrl;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getKeyVersion() {
        return this.keyVersion;
    }

    public SearchResourceEncryptionKey setKeyVersion(String keyVersion) {
        this.keyVersion = keyVersion;
        return this;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    public SearchIndexerDataIdentity getIdentity() {
        return this.identity;
    }

    public SearchResourceEncryptionKey setIdentity(SearchIndexerDataIdentity identity) {
        this.identity = identity;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyVaultKeyName", this.keyName);
        jsonWriter.writeStringField("keyVaultUri", this.vaultUrl);
        jsonWriter.writeStringField("keyVaultKeyVersion", this.keyVersion);
        jsonWriter.writeJsonField("accessCredentials", (JsonSerializable)this.accessCredentials);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static SearchResourceEncryptionKey fromJson(JsonReader jsonReader) throws IOException {
        return (SearchResourceEncryptionKey)jsonReader.readObject(reader -> {
            boolean keyNameFound = false;
            String keyName = null;
            boolean vaultUrlFound = false;
            String vaultUrl = null;
            String keyVersion = null;
            AzureActiveDirectoryApplicationCredentials accessCredentials = null;
            SearchIndexerDataIdentity identity = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyVaultKeyName".equals(fieldName)) {
                    keyName = reader.getString();
                    keyNameFound = true;
                    continue;
                }
                if ("keyVaultUri".equals(fieldName)) {
                    vaultUrl = reader.getString();
                    vaultUrlFound = true;
                    continue;
                }
                if ("keyVaultKeyVersion".equals(fieldName)) {
                    keyVersion = reader.getString();
                    continue;
                }
                if ("accessCredentials".equals(fieldName)) {
                    accessCredentials = AzureActiveDirectoryApplicationCredentials.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    identity = SearchIndexerDataIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (keyNameFound && vaultUrlFound) {
                SearchResourceEncryptionKey deserializedSearchResourceEncryptionKey = new SearchResourceEncryptionKey(keyName, vaultUrl);
                deserializedSearchResourceEncryptionKey.keyVersion = keyVersion;
                deserializedSearchResourceEncryptionKey.accessCredentials = accessCredentials;
                deserializedSearchResourceEncryptionKey.identity = identity;
                return deserializedSearchResourceEncryptionKey;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!keyNameFound) {
                missingProperties.add("keyVaultKeyName");
            }
            if (!vaultUrlFound) {
                missingProperties.add("keyVaultUri");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }

    public String getApplicationId() {
        return this.accessCredentials == null ? null : this.accessCredentials.getApplicationId();
    }

    public SearchResourceEncryptionKey setApplicationId(String applicationId) {
        if (this.accessCredentials == null) {
            this.accessCredentials = new AzureActiveDirectoryApplicationCredentials();
        }
        this.accessCredentials.setApplicationId(applicationId);
        return this;
    }

    public String getApplicationSecret() {
        return this.accessCredentials == null ? null : this.accessCredentials.getApplicationSecret();
    }

    public SearchResourceEncryptionKey setApplicationSecret(String applicationSecret) {
        if (this.accessCredentials == null) {
            this.accessCredentials = new AzureActiveDirectoryApplicationCredentials();
        }
        this.accessCredentials.setApplicationSecret(applicationSecret);
        return this;
    }
}

