/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class MagnitudeScoringParameters
implements JsonSerializable<MagnitudeScoringParameters> {
    private final double boostingRangeStart;
    private final double boostingRangeEnd;
    private Boolean shouldBoostBeyondRangeByConstant;

    public MagnitudeScoringParameters(double boostingRangeStart, double boostingRangeEnd) {
        this.boostingRangeStart = boostingRangeStart;
        this.boostingRangeEnd = boostingRangeEnd;
    }

    public double getBoostingRangeStart() {
        return this.boostingRangeStart;
    }

    public double getBoostingRangeEnd() {
        return this.boostingRangeEnd;
    }

    public Boolean shouldBoostBeyondRangeByConstant() {
        return this.shouldBoostBeyondRangeByConstant;
    }

    public MagnitudeScoringParameters setShouldBoostBeyondRangeByConstant(Boolean shouldBoostBeyondRangeByConstant) {
        this.shouldBoostBeyondRangeByConstant = shouldBoostBeyondRangeByConstant;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("boostingRangeStart", this.boostingRangeStart);
        jsonWriter.writeDoubleField("boostingRangeEnd", this.boostingRangeEnd);
        jsonWriter.writeBooleanField("constantBoostBeyondRange", this.shouldBoostBeyondRangeByConstant);
        return jsonWriter.writeEndObject();
    }

    public static MagnitudeScoringParameters fromJson(JsonReader jsonReader) throws IOException {
        return (MagnitudeScoringParameters)jsonReader.readObject(reader -> {
            boolean boostingRangeStartFound = false;
            double boostingRangeStart = 0.0;
            boolean boostingRangeEndFound = false;
            double boostingRangeEnd = 0.0;
            Boolean shouldBoostBeyondRangeByConstant = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("boostingRangeStart".equals(fieldName)) {
                    boostingRangeStart = reader.getDouble();
                    boostingRangeStartFound = true;
                    continue;
                }
                if ("boostingRangeEnd".equals(fieldName)) {
                    boostingRangeEnd = reader.getDouble();
                    boostingRangeEndFound = true;
                    continue;
                }
                if ("constantBoostBeyondRange".equals(fieldName)) {
                    shouldBoostBeyondRangeByConstant = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            if (boostingRangeStartFound && boostingRangeEndFound) {
                MagnitudeScoringParameters deserializedMagnitudeScoringParameters = new MagnitudeScoringParameters(boostingRangeStart, boostingRangeEnd);
                deserializedMagnitudeScoringParameters.shouldBoostBeyondRangeByConstant = shouldBoostBeyondRangeByConstant;
                return deserializedMagnitudeScoringParameters;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!boostingRangeStartFound) {
                missingProperties.add("boostingRangeStart");
            }
            if (!boostingRangeEndFound) {
                missingProperties.add("boostingRangeEnd");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

