/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.KnowledgeAgentOutputConfigurationModality;
import java.io.IOException;

public final class KnowledgeAgentOutputConfiguration
implements JsonSerializable<KnowledgeAgentOutputConfiguration> {
    private KnowledgeAgentOutputConfigurationModality modality;
    private String answerInstructions;
    private Boolean attemptFastPath;
    private Boolean includeActivity;

    public KnowledgeAgentOutputConfigurationModality getModality() {
        return this.modality;
    }

    public KnowledgeAgentOutputConfiguration setModality(KnowledgeAgentOutputConfigurationModality modality) {
        this.modality = modality;
        return this;
    }

    public String getAnswerInstructions() {
        return this.answerInstructions;
    }

    public KnowledgeAgentOutputConfiguration setAnswerInstructions(String answerInstructions) {
        this.answerInstructions = answerInstructions;
        return this;
    }

    public Boolean isAttemptFastPath() {
        return this.attemptFastPath;
    }

    public KnowledgeAgentOutputConfiguration setAttemptFastPath(Boolean attemptFastPath) {
        this.attemptFastPath = attemptFastPath;
        return this;
    }

    public Boolean isIncludeActivity() {
        return this.includeActivity;
    }

    public KnowledgeAgentOutputConfiguration setIncludeActivity(Boolean includeActivity) {
        this.includeActivity = includeActivity;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("modality", this.modality == null ? null : this.modality.toString());
        jsonWriter.writeStringField("answerInstructions", this.answerInstructions);
        jsonWriter.writeBooleanField("attemptFastPath", this.attemptFastPath);
        jsonWriter.writeBooleanField("includeActivity", this.includeActivity);
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeAgentOutputConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentOutputConfiguration)jsonReader.readObject(reader -> {
            KnowledgeAgentOutputConfiguration deserializedKnowledgeAgentOutputConfiguration = new KnowledgeAgentOutputConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("modality".equals(fieldName)) {
                    deserializedKnowledgeAgentOutputConfiguration.modality = KnowledgeAgentOutputConfigurationModality.fromString(reader.getString());
                    continue;
                }
                if ("answerInstructions".equals(fieldName)) {
                    deserializedKnowledgeAgentOutputConfiguration.answerInstructions = reader.getString();
                    continue;
                }
                if ("attemptFastPath".equals(fieldName)) {
                    deserializedKnowledgeAgentOutputConfiguration.attemptFastPath = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("includeActivity".equals(fieldName)) {
                    deserializedKnowledgeAgentOutputConfiguration.includeActivity = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKnowledgeAgentOutputConfiguration;
        });
    }
}

