/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.KnowledgeAgentModel;
import com.azure.search.documents.indexes.models.KnowledgeAgentOutputConfiguration;
import com.azure.search.documents.indexes.models.KnowledgeAgentRequestLimits;
import com.azure.search.documents.indexes.models.KnowledgeSourceReference;
import com.azure.search.documents.indexes.models.SearchResourceEncryptionKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class KnowledgeAgent
implements JsonSerializable<KnowledgeAgent> {
    private final String name;
    private final List<KnowledgeAgentModel> models;
    private final List<KnowledgeSourceReference> knowledgeSources;
    private KnowledgeAgentOutputConfiguration outputConfiguration;
    private KnowledgeAgentRequestLimits requestLimits;
    private String retrievalInstructions;
    private String eTag;
    private SearchResourceEncryptionKey encryptionKey;
    private String description;

    public KnowledgeAgent(String name, List<KnowledgeAgentModel> models, List<KnowledgeSourceReference> knowledgeSources) {
        this.name = name;
        this.models = models;
        this.knowledgeSources = knowledgeSources;
    }

    public String getName() {
        return this.name;
    }

    public List<KnowledgeAgentModel> getModels() {
        return this.models;
    }

    public List<KnowledgeSourceReference> getKnowledgeSources() {
        return this.knowledgeSources;
    }

    public KnowledgeAgentOutputConfiguration getOutputConfiguration() {
        return this.outputConfiguration;
    }

    public KnowledgeAgent setOutputConfiguration(KnowledgeAgentOutputConfiguration outputConfiguration) {
        this.outputConfiguration = outputConfiguration;
        return this;
    }

    public KnowledgeAgentRequestLimits getRequestLimits() {
        return this.requestLimits;
    }

    public KnowledgeAgent setRequestLimits(KnowledgeAgentRequestLimits requestLimits) {
        this.requestLimits = requestLimits;
        return this;
    }

    public String getRetrievalInstructions() {
        return this.retrievalInstructions;
    }

    public KnowledgeAgent setRetrievalInstructions(String retrievalInstructions) {
        this.retrievalInstructions = retrievalInstructions;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public KnowledgeAgent setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public SearchResourceEncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public KnowledgeAgent setEncryptionKey(SearchResourceEncryptionKey encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public KnowledgeAgent setDescription(String description) {
        this.description = description;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("models", this.models, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("knowledgeSources", this.knowledgeSources, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("outputConfiguration", (JsonSerializable)this.outputConfiguration);
        jsonWriter.writeJsonField("requestLimits", (JsonSerializable)this.requestLimits);
        jsonWriter.writeStringField("retrievalInstructions", this.retrievalInstructions);
        jsonWriter.writeStringField("@odata.etag", this.eTag);
        jsonWriter.writeJsonField("encryptionKey", (JsonSerializable)this.encryptionKey);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeAgent fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgent)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean modelsFound = false;
            List models = null;
            boolean knowledgeSourcesFound = false;
            List knowledgeSources = null;
            KnowledgeAgentOutputConfiguration outputConfiguration = null;
            KnowledgeAgentRequestLimits requestLimits = null;
            String retrievalInstructions = null;
            String eTag = null;
            SearchResourceEncryptionKey encryptionKey = null;
            String description = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("models".equals(fieldName)) {
                    models = reader.readArray(reader1 -> KnowledgeAgentModel.fromJson(reader1));
                    modelsFound = true;
                    continue;
                }
                if ("knowledgeSources".equals(fieldName)) {
                    knowledgeSources = reader.readArray(reader1 -> KnowledgeSourceReference.fromJson(reader1));
                    knowledgeSourcesFound = true;
                    continue;
                }
                if ("outputConfiguration".equals(fieldName)) {
                    outputConfiguration = KnowledgeAgentOutputConfiguration.fromJson(reader);
                    continue;
                }
                if ("requestLimits".equals(fieldName)) {
                    requestLimits = KnowledgeAgentRequestLimits.fromJson(reader);
                    continue;
                }
                if ("retrievalInstructions".equals(fieldName)) {
                    retrievalInstructions = reader.getString();
                    continue;
                }
                if ("@odata.etag".equals(fieldName)) {
                    eTag = reader.getString();
                    continue;
                }
                if ("encryptionKey".equals(fieldName)) {
                    encryptionKey = SearchResourceEncryptionKey.fromJson(reader);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && modelsFound && knowledgeSourcesFound) {
                KnowledgeAgent deserializedKnowledgeAgent = new KnowledgeAgent(name, models, knowledgeSources);
                deserializedKnowledgeAgent.outputConfiguration = outputConfiguration;
                deserializedKnowledgeAgent.requestLimits = requestLimits;
                deserializedKnowledgeAgent.retrievalInstructions = retrievalInstructions;
                deserializedKnowledgeAgent.eTag = eTag;
                deserializedKnowledgeAgent.encryptionKey = encryptionKey;
                deserializedKnowledgeAgent.description = description;
                return deserializedKnowledgeAgent;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!modelsFound) {
                missingProperties.add("models");
            }
            if (!knowledgeSourcesFound) {
                missingProperties.add("knowledgeSources");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

