/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class KeepTokenFilter
extends TokenFilter {
    private String odataType = "#Microsoft.Azure.Search.KeepTokenFilter";
    private final List<String> keepWords;
    private Boolean lowerCaseKeepWords;

    public KeepTokenFilter(String name, List<String> keepWords) {
        super(name);
        this.keepWords = keepWords;
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public List<String> getKeepWords() {
        return this.keepWords;
    }

    public Boolean areLowerCaseKeepWords() {
        return this.lowerCaseKeepWords;
    }

    public KeepTokenFilter setLowerCaseKeepWords(Boolean lowerCaseKeepWords) {
        this.lowerCaseKeepWords = lowerCaseKeepWords;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeArrayField("keepWords", this.keepWords, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeBooleanField("keepWordsCase", this.lowerCaseKeepWords);
        return jsonWriter.writeEndObject();
    }

    public static KeepTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (KeepTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean keepWordsFound = false;
            List keepWords = null;
            String odataType = "#Microsoft.Azure.Search.KeepTokenFilter";
            Boolean lowerCaseKeepWords = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("keepWords".equals(fieldName)) {
                    keepWords = reader.readArray(reader1 -> reader1.getString());
                    keepWordsFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("keepWordsCase".equals(fieldName)) {
                    lowerCaseKeepWords = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && keepWordsFound) {
                KeepTokenFilter deserializedKeepTokenFilter = new KeepTokenFilter(name, keepWords);
                deserializedKeepTokenFilter.odataType = odataType;
                deserializedKeepTokenFilter.lowerCaseKeepWords = lowerCaseKeepWords;
                return deserializedKeepTokenFilter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!keepWordsFound) {
                missingProperties.add("keepWords");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

