/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.ChatCompletionExtraParametersBehavior;
import com.azure.search.documents.indexes.models.ChatCompletionResponseFormat;
import com.azure.search.documents.indexes.models.CommonModelParameters;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerDataIdentity;
import com.azure.search.documents.indexes.models.WebApiSkill;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class ChatCompletionSkill
extends WebApiSkill {
    private String odataType = "#Microsoft.Skills.Custom.ChatCompletionSkill";
    private String apiKey;
    private CommonModelParameters commonModelParameters;
    private Map<String, Object> extraParameters;
    private ChatCompletionExtraParametersBehavior extraParametersBehavior;
    private ChatCompletionResponseFormat responseFormat;

    public ChatCompletionSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs, String uri) {
        super(inputs, outputs, uri);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public ChatCompletionSkill setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public CommonModelParameters getCommonModelParameters() {
        return this.commonModelParameters;
    }

    public ChatCompletionSkill setCommonModelParameters(CommonModelParameters commonModelParameters) {
        this.commonModelParameters = commonModelParameters;
        return this;
    }

    public Map<String, Object> getExtraParameters() {
        return this.extraParameters;
    }

    public ChatCompletionSkill setExtraParameters(Map<String, Object> extraParameters) {
        this.extraParameters = extraParameters;
        return this;
    }

    public ChatCompletionExtraParametersBehavior getExtraParametersBehavior() {
        return this.extraParametersBehavior;
    }

    public ChatCompletionSkill setExtraParametersBehavior(ChatCompletionExtraParametersBehavior extraParametersBehavior) {
        this.extraParametersBehavior = extraParametersBehavior;
        return this;
    }

    public ChatCompletionResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public ChatCompletionSkill setResponseFormat(ChatCompletionResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    @Override
    public ChatCompletionSkill setHttpHeaders(Map<String, String> httpHeaders) {
        super.setHttpHeaders(httpHeaders);
        return this;
    }

    @Override
    public ChatCompletionSkill setHttpMethod(String httpMethod) {
        super.setHttpMethod(httpMethod);
        return this;
    }

    @Override
    public ChatCompletionSkill setTimeout(Duration timeout) {
        super.setTimeout(timeout);
        return this;
    }

    @Override
    public ChatCompletionSkill setBatchSize(Integer batchSize) {
        super.setBatchSize(batchSize);
        return this;
    }

    @Override
    public ChatCompletionSkill setDegreeOfParallelism(Integer degreeOfParallelism) {
        super.setDegreeOfParallelism(degreeOfParallelism);
        return this;
    }

    @Override
    public ChatCompletionSkill setAuthResourceId(String authResourceId) {
        super.setAuthResourceId(authResourceId);
        return this;
    }

    @Override
    public ChatCompletionSkill setAuthIdentity(SearchIndexerDataIdentity authIdentity) {
        super.setAuthIdentity(authIdentity);
        return this;
    }

    @Override
    public ChatCompletionSkill setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public ChatCompletionSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public ChatCompletionSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("inputs", this.getInputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.getOutputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("uri", this.getUri());
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("context", this.getContext());
        jsonWriter.writeMapField("httpHeaders", this.getHttpHeaders(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("httpMethod", this.getHttpMethod());
        jsonWriter.writeStringField("timeout", CoreUtils.durationToStringWithDays((Duration)this.getTimeout()));
        jsonWriter.writeNumberField("batchSize", (Number)this.getBatchSize());
        jsonWriter.writeNumberField("degreeOfParallelism", (Number)this.getDegreeOfParallelism());
        jsonWriter.writeStringField("authResourceId", this.getAuthResourceId());
        jsonWriter.writeJsonField("authIdentity", (JsonSerializable)this.getAuthIdentity());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeStringField("apiKey", this.apiKey);
        jsonWriter.writeJsonField("commonModelParameters", (JsonSerializable)this.commonModelParameters);
        jsonWriter.writeMapField("extraParameters", this.extraParameters, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("extraParametersBehavior", this.extraParametersBehavior == null ? null : this.extraParametersBehavior.toString());
        jsonWriter.writeJsonField("responseFormat", (JsonSerializable)this.responseFormat);
        return jsonWriter.writeEndObject();
    }

    public static ChatCompletionSkill fromJson(JsonReader jsonReader) throws IOException {
        return (ChatCompletionSkill)jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List inputs = null;
            boolean outputsFound = false;
            List outputs = null;
            boolean uriFound = false;
            String uri = null;
            String name = null;
            String description = null;
            String context = null;
            Map httpHeaders = null;
            String httpMethod = null;
            Duration timeout = null;
            Integer batchSize = null;
            Integer degreeOfParallelism = null;
            String authResourceId = null;
            SearchIndexerDataIdentity authIdentity = null;
            String odataType = "#Microsoft.Skills.Custom.ChatCompletionSkill";
            String apiKey = null;
            CommonModelParameters commonModelParameters = null;
            Map extraParameters = null;
            ChatCompletionExtraParametersBehavior extraParametersBehavior = null;
            ChatCompletionResponseFormat responseFormat = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                    continue;
                }
                if ("uri".equals(fieldName)) {
                    uri = reader.getString();
                    uriFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    context = reader.getString();
                    continue;
                }
                if ("httpHeaders".equals(fieldName)) {
                    httpHeaders = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("httpMethod".equals(fieldName)) {
                    httpMethod = reader.getString();
                    continue;
                }
                if ("timeout".equals(fieldName)) {
                    timeout = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("batchSize".equals(fieldName)) {
                    batchSize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("degreeOfParallelism".equals(fieldName)) {
                    degreeOfParallelism = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("authResourceId".equals(fieldName)) {
                    authResourceId = reader.getString();
                    continue;
                }
                if ("authIdentity".equals(fieldName)) {
                    authIdentity = SearchIndexerDataIdentity.fromJson(reader);
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("apiKey".equals(fieldName)) {
                    apiKey = reader.getString();
                    continue;
                }
                if ("commonModelParameters".equals(fieldName)) {
                    commonModelParameters = CommonModelParameters.fromJson(reader);
                    continue;
                }
                if ("extraParameters".equals(fieldName)) {
                    extraParameters = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("extraParametersBehavior".equals(fieldName)) {
                    extraParametersBehavior = ChatCompletionExtraParametersBehavior.fromString(reader.getString());
                    continue;
                }
                if ("responseFormat".equals(fieldName)) {
                    responseFormat = ChatCompletionResponseFormat.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (inputsFound && outputsFound && uriFound) {
                ChatCompletionSkill deserializedChatCompletionSkill = new ChatCompletionSkill(inputs, outputs, uri);
                deserializedChatCompletionSkill.setName(name);
                deserializedChatCompletionSkill.setDescription(description);
                deserializedChatCompletionSkill.setContext(context);
                deserializedChatCompletionSkill.setHttpHeaders(httpHeaders);
                deserializedChatCompletionSkill.setHttpMethod(httpMethod);
                deserializedChatCompletionSkill.setTimeout(timeout);
                deserializedChatCompletionSkill.setBatchSize(batchSize);
                deserializedChatCompletionSkill.setDegreeOfParallelism(degreeOfParallelism);
                deserializedChatCompletionSkill.setAuthResourceId(authResourceId);
                deserializedChatCompletionSkill.setAuthIdentity(authIdentity);
                deserializedChatCompletionSkill.odataType = odataType;
                deserializedChatCompletionSkill.apiKey = apiKey;
                deserializedChatCompletionSkill.commonModelParameters = commonModelParameters;
                deserializedChatCompletionSkill.extraParameters = extraParameters;
                deserializedChatCompletionSkill.extraParametersBehavior = extraParametersBehavior;
                deserializedChatCompletionSkill.responseFormat = responseFormat;
                return deserializedChatCompletionSkill;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            if (!uriFound) {
                missingProperties.add("uri");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

