/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.CognitiveServicesAccount;
import java.io.IOException;
import java.util.ArrayList;

public final class AIServicesAccountKey
extends CognitiveServicesAccount {
    private String odataType = "#Microsoft.Azure.Search.AIServicesByKey";
    private final String key;
    private final String subdomainUrl;

    public AIServicesAccountKey(String key, String subdomainUrl) {
        this.key = key;
        this.subdomainUrl = subdomainUrl;
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public String getKey() {
        return this.key;
    }

    public String getSubdomainUrl() {
        return this.subdomainUrl;
    }

    @Override
    public AIServicesAccountKey setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("key", this.key);
        jsonWriter.writeStringField("subdomainUrl", this.subdomainUrl);
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    public static AIServicesAccountKey fromJson(JsonReader jsonReader) throws IOException {
        return (AIServicesAccountKey)jsonReader.readObject(reader -> {
            String description = null;
            boolean keyFound = false;
            String key = null;
            boolean subdomainUrlFound = false;
            String subdomainUrl = null;
            String odataType = "#Microsoft.Azure.Search.AIServicesByKey";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("key".equals(fieldName)) {
                    key = reader.getString();
                    keyFound = true;
                    continue;
                }
                if ("subdomainUrl".equals(fieldName)) {
                    subdomainUrl = reader.getString();
                    subdomainUrlFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (keyFound && subdomainUrlFound) {
                AIServicesAccountKey deserializedAIServicesAccountKey = new AIServicesAccountKey(key, subdomainUrl);
                deserializedAIServicesAccountKey.setDescription(description);
                deserializedAIServicesAccountKey.odataType = odataType;
                return deserializedAIServicesAccountKey;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!keyFound) {
                missingProperties.add("key");
            }
            if (!subdomainUrlFound) {
                missingProperties.add("subdomainUrl");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

