/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.CognitiveServicesAccount;
import com.azure.search.documents.indexes.models.SearchIndexerDataIdentity;
import java.io.IOException;

public final class AIServicesAccountIdentity
extends CognitiveServicesAccount {
    private String odataType = "#Microsoft.Azure.Search.AIServicesByIdentity";
    private SearchIndexerDataIdentity identity;
    private final String subdomainUrl;

    public AIServicesAccountIdentity(String subdomainUrl) {
        this.subdomainUrl = subdomainUrl;
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public SearchIndexerDataIdentity getIdentity() {
        return this.identity;
    }

    public AIServicesAccountIdentity setIdentity(SearchIndexerDataIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String getSubdomainUrl() {
        return this.subdomainUrl;
    }

    @Override
    public AIServicesAccountIdentity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("subdomainUrl", this.subdomainUrl);
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static AIServicesAccountIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (AIServicesAccountIdentity)jsonReader.readObject(reader -> {
            String description = null;
            boolean subdomainUrlFound = false;
            String subdomainUrl = null;
            String odataType = "#Microsoft.Azure.Search.AIServicesByIdentity";
            SearchIndexerDataIdentity identity = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("subdomainUrl".equals(fieldName)) {
                    subdomainUrl = reader.getString();
                    subdomainUrlFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    identity = SearchIndexerDataIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (subdomainUrlFound) {
                AIServicesAccountIdentity deserializedAIServicesAccountIdentity = new AIServicesAccountIdentity(subdomainUrl);
                deserializedAIServicesAccountIdentity.setDescription(description);
                deserializedAIServicesAccountIdentity.odataType = odataType;
                deserializedAIServicesAccountIdentity.identity = identity;
                return deserializedAIServicesAccountIdentity;
            }
            throw new IllegalStateException("Missing required property: subdomainUrl");
        });
    }
}

