/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.util;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.util.CoreUtils;
import com.azure.search.documents.indexes.implementation.models.AnalyzeResult;
import com.azure.search.documents.indexes.implementation.models.ErrorResponseException;
import com.azure.search.documents.indexes.implementation.models.ListDataSourcesResult;
import com.azure.search.documents.indexes.implementation.models.ListIndexersResult;
import com.azure.search.documents.indexes.implementation.models.ListSkillsetsResult;
import com.azure.search.documents.indexes.implementation.models.ListSynonymMapsResult;
import com.azure.search.documents.indexes.models.AnalyzedTokenInfo;
import com.azure.search.documents.indexes.models.BlobIndexerDataToExtract;
import com.azure.search.documents.indexes.models.BlobIndexerImageAction;
import com.azure.search.documents.indexes.models.BlobIndexerParsingMode;
import com.azure.search.documents.indexes.models.BlobIndexerPdfTextRotationAlgorithm;
import com.azure.search.documents.indexes.models.IndexerExecutionEnvironment;
import com.azure.search.documents.indexes.models.IndexingParametersConfiguration;
import com.azure.search.documents.indexes.models.SearchIndex;
import com.azure.search.documents.indexes.models.SearchIndexer;
import com.azure.search.documents.indexes.models.SearchIndexerDataSourceConnection;
import com.azure.search.documents.indexes.models.SearchIndexerSkillset;
import com.azure.search.documents.indexes.models.SynonymMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class MappingUtils {
    public static PagedResponse<SearchIndexerDataSourceConnection> mapPagedDataSources(Response<ListDataSourcesResult> response) {
        return MappingUtils.pagedResponse(response, ((ListDataSourcesResult)response.getValue()).getDataSources());
    }

    public static PagedResponse<String> mapPagedDataSourceNames(Response<ListDataSourcesResult> response) {
        return MappingUtils.pagedResponse(response, MappingUtils.mapToNames(((ListDataSourcesResult)response.getValue()).getDataSources(), SearchIndexerDataSourceConnection::getName));
    }

    public static PagedResponse<String> mapPagedSearchIndexNames(PagedResponse<SearchIndex> response) {
        return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), MappingUtils.mapToNames(response.getValue(), SearchIndex::getName), (String)response.getContinuationToken(), null);
    }

    public static PagedResponse<SearchIndexer> mapPagedSearchIndexers(Response<ListIndexersResult> response) {
        return MappingUtils.pagedResponse(response, ((ListIndexersResult)response.getValue()).getIndexers());
    }

    public static PagedResponse<String> mapPagedSearchIndexerNames(Response<ListIndexersResult> response) {
        return MappingUtils.pagedResponse(response, MappingUtils.mapToNames(((ListIndexersResult)response.getValue()).getIndexers(), SearchIndexer::getName));
    }

    public static PagedResponse<SearchIndexerSkillset> mapPagedSkillsets(Response<ListSkillsetsResult> response) {
        return MappingUtils.pagedResponse(response, ((ListSkillsetsResult)response.getValue()).getSkillsets());
    }

    public static PagedResponse<String> mapPagedSkillsetNames(Response<ListSkillsetsResult> response) {
        return MappingUtils.pagedResponse(response, MappingUtils.mapToNames(((ListSkillsetsResult)response.getValue()).getSkillsets(), SearchIndexerSkillset::getName));
    }

    public static PagedResponse<SynonymMap> mapPagedSynonymMaps(Response<ListSynonymMapsResult> response) {
        return MappingUtils.pagedResponse(response, ((ListSynonymMapsResult)response.getValue()).getSynonymMaps());
    }

    public static PagedResponse<String> mapPagedSynonymMapNames(Response<ListSynonymMapsResult> response) {
        return MappingUtils.pagedResponse(response, MappingUtils.mapToNames(((ListSynonymMapsResult)response.getValue()).getSynonymMaps(), SynonymMap::getName));
    }

    public static PagedResponse<AnalyzedTokenInfo> mapPagedTokenInfos(Response<AnalyzeResult> response) {
        return MappingUtils.pagedResponse(response, ((AnalyzeResult)response.getValue()).getTokens());
    }

    public static Throwable exceptionMapper(Throwable throwable) {
        if (throwable instanceof com.azure.search.documents.implementation.models.ErrorResponseException) {
            com.azure.search.documents.implementation.models.ErrorResponseException exception = (com.azure.search.documents.implementation.models.ErrorResponseException)((Object)throwable);
            return new HttpResponseException(exception.getMessage(), exception.getResponse());
        }
        if (throwable instanceof ErrorResponseException) {
            ErrorResponseException exception = (ErrorResponseException)((Object)throwable);
            return new HttpResponseException(exception.getMessage(), exception.getResponse());
        }
        return throwable;
    }

    public static IndexingParametersConfiguration mapToIndexingParametersConfiguration(Map<String, Object> configuration) {
        if (CoreUtils.isNullOrEmpty(configuration)) {
            return null;
        }
        IndexingParametersConfiguration config = new IndexingParametersConfiguration();
        LinkedHashMap<String, Object> additionalProperties = null;
        block36: for (Map.Entry<String, Object> kvp : configuration.entrySet()) {
            String key = kvp.getKey();
            if (key == null) continue;
            Object value = kvp.getValue();
            switch (key) {
                case "parsingMode": {
                    config.setParsingMode(MappingUtils.converter(value, BlobIndexerParsingMode::fromString));
                    continue block36;
                }
                case "excludedFileNameExtensions": {
                    config.setExcludedFileNameExtensions((String)MappingUtils.converter(value, Function.identity()));
                    continue block36;
                }
                case "indexedFileNameExtensions": {
                    config.setIndexedFileNameExtensions((String)MappingUtils.converter(value, Function.identity()));
                    continue block36;
                }
                case "failOnUnsupportedContentType": {
                    config.setFailOnUnsupportedContentType(MappingUtils.converter(value, Boolean::parseBoolean));
                    continue block36;
                }
                case "failOnUnprocessableDocument": {
                    config.setFailOnUnprocessableDocument(MappingUtils.converter(value, Boolean::parseBoolean));
                    continue block36;
                }
                case "indexStorageMetadataOnlyForOversizedDocuments": {
                    config.setIndexStorageMetadataOnlyForOversizedDocuments(MappingUtils.converter(value, Boolean::parseBoolean));
                    continue block36;
                }
                case "delimitedTextHeaders": {
                    config.setDelimitedTextHeaders((String)MappingUtils.converter(value, Function.identity()));
                    continue block36;
                }
                case "delimitedTextDelimiter": {
                    config.setDelimitedTextDelimiter((String)MappingUtils.converter(value, Function.identity()));
                    continue block36;
                }
                case "firstLineContainsHeaders": {
                    config.setFirstLineContainsHeaders(MappingUtils.converter(value, Boolean::parseBoolean));
                    continue block36;
                }
                case "documentRoot": {
                    config.setDocumentRoot((String)MappingUtils.converter(value, Function.identity()));
                    continue block36;
                }
                case "dataToExtract": {
                    config.setDataToExtract(MappingUtils.converter(value, BlobIndexerDataToExtract::fromString));
                    continue block36;
                }
                case "imageAction": {
                    config.setImageAction(MappingUtils.converter(value, BlobIndexerImageAction::fromString));
                    continue block36;
                }
                case "allowSkillsetToReadFileData": {
                    config.setAllowSkillsetToReadFileData(MappingUtils.converter(value, Boolean::parseBoolean));
                    continue block36;
                }
                case "pdfTextRotationAlgorithm": {
                    config.setPdfTextRotationAlgorithm(MappingUtils.converter(value, BlobIndexerPdfTextRotationAlgorithm::fromString));
                    continue block36;
                }
                case "executionEnvironment": {
                    config.setExecutionEnvironment(MappingUtils.converter(value, IndexerExecutionEnvironment::fromString));
                    continue block36;
                }
                case "queryTimeout": {
                    config.setQueryTimeout((String)MappingUtils.converter(value, Function.identity()));
                    continue block36;
                }
            }
            if (additionalProperties == null) {
                additionalProperties = new LinkedHashMap<String, Object>();
            }
            additionalProperties.put(key, value);
        }
        return config.setAdditionalProperties(additionalProperties);
    }

    private static <T> T converter(Object value, Function<String, T> conv) {
        return value == null ? null : (T)conv.apply(String.valueOf(value));
    }

    public static Map<String, Object> indexingParametersConfigurationToMap(IndexingParametersConfiguration params) {
        if (params == null) {
            return null;
        }
        LinkedHashMap<String, Object> configuration = new LinkedHashMap<String, Object>();
        MappingUtils.setConfigurationValue((Object)params.getParsingMode(), "parsingMode", configuration);
        MappingUtils.setConfigurationValue(params.getExcludedFileNameExtensions(), "excludedFileNameExtensions", configuration);
        MappingUtils.setConfigurationValue(params.getIndexedFileNameExtensions(), "indexedFileNameExtensions", configuration);
        MappingUtils.setConfigurationValue(params.isFailOnUnsupportedContentType(), "failOnUnsupportedContentType", configuration);
        MappingUtils.setConfigurationValue(params.isFailOnUnprocessableDocument(), "failOnUnprocessableDocument", configuration);
        MappingUtils.setConfigurationValue(params.isIndexStorageMetadataOnlyForOversizedDocuments(), "indexStorageMetadataOnlyForOversizedDocuments", configuration);
        MappingUtils.setConfigurationValue(params.getDelimitedTextHeaders(), "delimitedTextHeaders", configuration);
        MappingUtils.setConfigurationValue(params.getDelimitedTextDelimiter(), "delimitedTextDelimiter", configuration);
        MappingUtils.setConfigurationValue(params.isFirstLineContainsHeaders(), "firstLineContainsHeaders", configuration);
        MappingUtils.setConfigurationValue(params.getDocumentRoot(), "documentRoot", configuration);
        MappingUtils.setConfigurationValue((Object)params.getDataToExtract(), "dataToExtract", configuration);
        MappingUtils.setConfigurationValue((Object)params.getImageAction(), "imageAction", configuration);
        MappingUtils.setConfigurationValue(params.isAllowSkillsetToReadFileData(), "allowSkillsetToReadFileData", configuration);
        MappingUtils.setConfigurationValue((Object)params.getPdfTextRotationAlgorithm(), "pdfTextRotationAlgorithm", configuration);
        MappingUtils.setConfigurationValue((Object)params.getExecutionEnvironment(), "executionEnvironment", configuration);
        MappingUtils.setConfigurationValue(params.getQueryTimeout(), "queryTimeout", configuration);
        Map<String, Object> additionalProperties = params.getAdditionalProperties();
        if (!CoreUtils.isNullOrEmpty(additionalProperties)) {
            configuration.putAll(additionalProperties);
        }
        return configuration;
    }

    private static void setConfigurationValue(Object value, String key, Map<String, Object> configuration) {
        if (value == null) {
            return;
        }
        configuration.put(key, String.valueOf(value));
    }

    private static <T> PagedResponse<T> pagedResponse(Response<?> response, List<T> values) {
        return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), values, null, null);
    }

    private static <T> List<String> mapToNames(List<T> values, Function<T, String> mapper) {
        return values.stream().map(mapper).collect(() -> new ArrayList(values.size()), List::add, List::addAll);
    }
}

