/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.agents.models.KnowledgeSourceKind;
import com.azure.search.documents.agents.models.KnowledgeSourceParams;
import java.io.IOException;

public final class SearchIndexKnowledgeSourceParams
extends KnowledgeSourceParams {
    private KnowledgeSourceKind kind = KnowledgeSourceKind.SEARCH_INDEX;
    private String filterAddOn;

    public SearchIndexKnowledgeSourceParams(String knowledgeSourceName) {
        super(knowledgeSourceName);
    }

    @Override
    public KnowledgeSourceKind getKind() {
        return this.kind;
    }

    public String getFilterAddOn() {
        return this.filterAddOn;
    }

    public SearchIndexKnowledgeSourceParams setFilterAddOn(String filterAddOn) {
        this.filterAddOn = filterAddOn;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("knowledgeSourceName", this.getKnowledgeSourceName());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("filterAddOn", this.filterAddOn);
        return jsonWriter.writeEndObject();
    }

    public static SearchIndexKnowledgeSourceParams fromJson(JsonReader jsonReader) throws IOException {
        return (SearchIndexKnowledgeSourceParams)jsonReader.readObject(reader -> {
            boolean knowledgeSourceNameFound = false;
            String knowledgeSourceName = null;
            KnowledgeSourceKind kind = KnowledgeSourceKind.SEARCH_INDEX;
            String filterAddOn = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("knowledgeSourceName".equals(fieldName)) {
                    knowledgeSourceName = reader.getString();
                    knowledgeSourceNameFound = true;
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = KnowledgeSourceKind.fromString(reader.getString());
                    continue;
                }
                if ("filterAddOn".equals(fieldName)) {
                    filterAddOn = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (knowledgeSourceNameFound) {
                SearchIndexKnowledgeSourceParams deserializedSearchIndexKnowledgeSourceParams = new SearchIndexKnowledgeSourceParams(knowledgeSourceName);
                deserializedSearchIndexKnowledgeSourceParams.kind = kind;
                deserializedSearchIndexKnowledgeSourceParams.filterAddOn = filterAddOn;
                return deserializedSearchIndexKnowledgeSourceParams;
            }
            throw new IllegalStateException("Missing required property: knowledgeSourceName");
        });
    }
}

