/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.agents.models.KnowledgeAgentActivityRecord;
import java.io.IOException;

public final class KnowledgeAgentSemanticRankerActivityRecord
extends KnowledgeAgentActivityRecord {
    private String type = "AzureSearchSemanticRanker";
    private Integer inputTokens;
    private Integer elapsedMs;

    public KnowledgeAgentSemanticRankerActivityRecord(int id) {
        super(id);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public Integer getInputTokens() {
        return this.inputTokens;
    }

    public KnowledgeAgentSemanticRankerActivityRecord setInputTokens(Integer inputTokens) {
        this.inputTokens = inputTokens;
        return this;
    }

    @Override
    public Integer getElapsedMs() {
        return this.elapsedMs;
    }

    @Override
    public KnowledgeAgentSemanticRankerActivityRecord setElapsedMs(Integer elapsedMs) {
        this.elapsedMs = elapsedMs;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("id", this.getId());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeNumberField("inputTokens", (Number)this.inputTokens);
        jsonWriter.writeNumberField("elapsedMs", (Number)this.elapsedMs);
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeAgentSemanticRankerActivityRecord fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentSemanticRankerActivityRecord)jsonReader.readObject(reader -> {
            boolean idFound = false;
            int id = 0;
            String type = "AzureSearchSemanticRanker";
            Integer inputTokens = null;
            Integer elapsedMs = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getInt();
                    idFound = true;
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("inputTokens".equals(fieldName)) {
                    inputTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("elapsedMs".equals(fieldName)) {
                    elapsedMs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound) {
                KnowledgeAgentSemanticRankerActivityRecord deserializedKnowledgeAgentSemanticRankerActivityRecord = new KnowledgeAgentSemanticRankerActivityRecord(id);
                deserializedKnowledgeAgentSemanticRankerActivityRecord.type = type;
                deserializedKnowledgeAgentSemanticRankerActivityRecord.inputTokens = inputTokens;
                deserializedKnowledgeAgentSemanticRankerActivityRecord.elapsedMs = elapsedMs;
                return deserializedKnowledgeAgentSemanticRankerActivityRecord;
            }
            throw new IllegalStateException("Missing required property: id");
        });
    }
}

