/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.agents.models.KnowledgeAgentMessageContent;
import java.io.IOException;
import java.util.List;

public final class KnowledgeAgentMessage
implements JsonSerializable<KnowledgeAgentMessage> {
    private String role;
    private final List<KnowledgeAgentMessageContent> content;

    public KnowledgeAgentMessage(List<KnowledgeAgentMessageContent> content) {
        this.content = content;
    }

    public String getRole() {
        return this.role;
    }

    public KnowledgeAgentMessage setRole(String role) {
        this.role = role;
        return this;
    }

    public List<KnowledgeAgentMessageContent> getContent() {
        return this.content;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("content", this.content, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("role", this.role);
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeAgentMessage fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentMessage)jsonReader.readObject(reader -> {
            boolean contentFound = false;
            List content = null;
            String role = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.readArray(reader1 -> KnowledgeAgentMessageContent.fromJson(reader1));
                    contentFound = true;
                    continue;
                }
                if ("role".equals(fieldName)) {
                    role = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (contentFound) {
                KnowledgeAgentMessage deserializedKnowledgeAgentMessage = new KnowledgeAgentMessage(content);
                deserializedKnowledgeAgentMessage.role = role;
                return deserializedKnowledgeAgentMessage;
            }
            throw new IllegalStateException("Missing required property: content");
        });
    }
}

