/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.agents.models.KnowledgeAgentReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public final class KnowledgeAgentAzureSearchDocReference
extends KnowledgeAgentReference {
    private String type = "AzureSearchDoc";
    private String docKey;
    private Map<String, Object> sourceData;

    public KnowledgeAgentAzureSearchDocReference(String id, int activitySource) {
        super(id, activitySource);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String getDocKey() {
        return this.docKey;
    }

    public KnowledgeAgentAzureSearchDocReference setDocKey(String docKey) {
        this.docKey = docKey;
        return this;
    }

    @Override
    public Map<String, Object> getSourceData() {
        return this.sourceData;
    }

    @Override
    public KnowledgeAgentAzureSearchDocReference setSourceData(Map<String, Object> sourceData) {
        this.sourceData = sourceData;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeIntField("activitySource", this.getActivitySource());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("docKey", this.docKey);
        jsonWriter.writeMapField("sourceData", this.sourceData, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeAgentAzureSearchDocReference fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentAzureSearchDocReference)jsonReader.readObject(reader -> {
            boolean idFound = false;
            String id = null;
            boolean activitySourceFound = false;
            int activitySource = 0;
            String type = "AzureSearchDoc";
            String docKey = null;
            Map sourceData = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    idFound = true;
                    continue;
                }
                if ("activitySource".equals(fieldName)) {
                    activitySource = reader.getInt();
                    activitySourceFound = true;
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("docKey".equals(fieldName)) {
                    docKey = reader.getString();
                    continue;
                }
                if ("sourceData".equals(fieldName)) {
                    sourceData = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound && activitySourceFound) {
                KnowledgeAgentAzureSearchDocReference deserializedKnowledgeAgentAzureSearchDocReference = new KnowledgeAgentAzureSearchDocReference(id, activitySource);
                deserializedKnowledgeAgentAzureSearchDocReference.type = type;
                deserializedKnowledgeAgentAzureSearchDocReference.docKey = docKey;
                deserializedKnowledgeAgentAzureSearchDocReference.sourceData = sourceData;
                return deserializedKnowledgeAgentAzureSearchDocReference;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!idFound) {
                missingProperties.add("id");
            }
            if (!activitySourceFound) {
                missingProperties.add("activitySource");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

