/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.search.documents.agents.implementation.KnowledgeAgentRetrievalClientImpl;
import com.azure.search.documents.agents.implementation.models.ErrorResponseException;
import com.azure.search.documents.agents.implementation.models.RequestOptions;
import com.azure.search.documents.agents.models.KnowledgeAgentRetrievalRequest;
import com.azure.search.documents.agents.models.KnowledgeAgentRetrievalResponse;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class KnowledgeRetrievalsImpl {
    private final KnowledgeRetrievalsService service;
    private final KnowledgeAgentRetrievalClientImpl client;

    KnowledgeRetrievalsImpl(KnowledgeAgentRetrievalClientImpl client) {
        this.service = (KnowledgeRetrievalsService)RestProxy.create(KnowledgeRetrievalsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KnowledgeAgentRetrievalResponse>> retrieveWithResponseAsync(KnowledgeAgentRetrievalRequest retrievalRequest, String xMsQuerySourceAuthorization, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.retrieveWithResponseAsync(retrievalRequest, xMsQuerySourceAuthorization, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KnowledgeAgentRetrievalResponse>> retrieveWithResponseAsync(KnowledgeAgentRetrievalRequest retrievalRequest, String xMsQuerySourceAuthorization, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.retrieve(this.client.getEndpoint(), this.client.getAgentName(), xMsClientRequestId, this.client.getApiVersion(), xMsQuerySourceAuthorization, "application/json; odata.metadata=minimal", retrievalRequest, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KnowledgeAgentRetrievalResponse> retrieveAsync(KnowledgeAgentRetrievalRequest retrievalRequest, String xMsQuerySourceAuthorization, RequestOptions requestOptions) {
        return this.retrieveWithResponseAsync(retrievalRequest, xMsQuerySourceAuthorization, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((KnowledgeAgentRetrievalResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KnowledgeAgentRetrievalResponse> retrieveAsync(KnowledgeAgentRetrievalRequest retrievalRequest, String xMsQuerySourceAuthorization, RequestOptions requestOptions, Context context) {
        return this.retrieveWithResponseAsync(retrievalRequest, xMsQuerySourceAuthorization, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((KnowledgeAgentRetrievalResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KnowledgeAgentRetrievalResponse> retrieveWithResponse(KnowledgeAgentRetrievalRequest retrievalRequest, String xMsQuerySourceAuthorization, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.retrieveSync(this.client.getEndpoint(), this.client.getAgentName(), xMsClientRequestId, this.client.getApiVersion(), xMsQuerySourceAuthorization, "application/json; odata.metadata=minimal", retrievalRequest, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KnowledgeAgentRetrievalResponse retrieve(KnowledgeAgentRetrievalRequest retrievalRequest, String xMsQuerySourceAuthorization, RequestOptions requestOptions) {
        return (KnowledgeAgentRetrievalResponse)this.retrieveWithResponse(retrievalRequest, xMsQuerySourceAuthorization, requestOptions, Context.NONE).getValue();
    }

    @Host(value="{endpoint}/agents('{agentName}')")
    @ServiceInterface(name="KnowledgeAgentRetrievalClientKnowledgeRetrievals")
    public static interface KnowledgeRetrievalsService {
        @Post(value="/retrieve")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<KnowledgeAgentRetrievalResponse>> retrieve(@HostParam(value="endpoint") String var1, @HostParam(value="agentName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="x-ms-query-source-authorization") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") KnowledgeAgentRetrievalRequest var7, Context var8);

        @Post(value="/retrieve")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<KnowledgeAgentRetrievalResponse> retrieveSync(@HostParam(value="endpoint") String var1, @HostParam(value="agentName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="x-ms-query-source-authorization") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") KnowledgeAgentRetrievalRequest var7, Context var8);
    }
}

