/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.util;

import com.azure.core.http.rest.PagedFluxBase;
import com.azure.core.http.rest.PagedIterableBase;
import com.azure.core.util.paging.PageRetrieverSync;
import com.azure.search.documents.implementation.models.SearchFirstPageResponseWrapper;
import com.azure.search.documents.implementation.util.SemanticSearchResultsAccessHelper;
import com.azure.search.documents.models.FacetResult;
import com.azure.search.documents.models.SearchResult;
import com.azure.search.documents.models.SemanticSearchResults;
import com.azure.search.documents.util.SearchPagedFlux;
import com.azure.search.documents.util.SearchPagedResponse;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public final class SearchPagedIterable
extends PagedIterableBase<SearchResult, SearchPagedResponse> {
    private final SearchPagedFlux pagedFlux;
    private final Supplier<SearchFirstPageResponseWrapper> metadataSupplier;

    public SearchPagedIterable(SearchPagedFlux pagedFlux) {
        super((PagedFluxBase)pagedFlux);
        this.pagedFlux = pagedFlux;
        this.metadataSupplier = null;
    }

    public SearchPagedIterable(Supplier<SearchPagedResponse> firstPageRetriever) {
        this(firstPageRetriever, null);
    }

    public SearchPagedIterable(Supplier<SearchPagedResponse> firstPageRetriever, Function<String, SearchPagedResponse> nextPageRetriever) {
        this(() -> (arg_0, arg_1) -> SearchPagedIterable.lambda$new$0((Supplier)firstPageRetriever, nextPageRetriever, arg_0, arg_1), true, () -> {
            SearchPagedResponse response = (SearchPagedResponse)((Object)((Object)firstPageRetriever.get()));
            return new SearchFirstPageResponseWrapper().setFirstPageResponse(response);
        });
    }

    private SearchPagedIterable(Supplier<PageRetrieverSync<String, SearchPagedResponse>> provider, boolean ignored, Supplier<SearchFirstPageResponseWrapper> metadataSupplier) {
        super(provider);
        this.pagedFlux = null;
        this.metadataSupplier = metadataSupplier;
    }

    public Double getCoverage() {
        return this.metadataSupplier != null ? this.metadataSupplier.get().getFirstPageResponse().getCoverage() : (Double)this.pagedFlux.getCoverage().block();
    }

    public Map<String, List<FacetResult>> getFacets() {
        return this.metadataSupplier != null ? this.metadataSupplier.get().getFirstPageResponse().getFacets() : (Map<String, List<FacetResult>>)this.pagedFlux.getFacets().block();
    }

    public Long getTotalCount() {
        return this.metadataSupplier != null ? this.metadataSupplier.get().getFirstPageResponse().getCount() : (Long)this.pagedFlux.getTotalCount().block();
    }

    public SemanticSearchResults getSemanticResults() {
        return this.metadataSupplier != null ? SemanticSearchResultsAccessHelper.create(this.metadataSupplier.get().getFirstPageResponse()) : (SemanticSearchResults)this.pagedFlux.getSemanticResults().block();
    }

    private static /* synthetic */ SearchPagedResponse lambda$new$0(Supplier firstPageRetriever, Function nextPageRetriever, String continuationToken, Integer pageSize) {
        return continuationToken == null ? (SearchPagedResponse)((Object)firstPageRetriever.get()) : (SearchPagedResponse)((Object)nextPageRetriever.apply(continuationToken));
    }
}

