/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.search.documents.implementation.util.SearchPagedResponseAccessHelper;
import com.azure.search.documents.implementation.util.SemanticSearchResultsAccessHelper;
import com.azure.search.documents.models.QueryAnswerResult;
import com.azure.search.documents.models.SemanticErrorReason;
import com.azure.search.documents.models.SemanticSearchResultsType;
import com.azure.search.documents.util.SearchPagedResponse;
import java.util.List;

public final class SemanticSearchResults {
    private final List<QueryAnswerResult> queryAnswers;
    private final SemanticErrorReason errorReason;
    private final SemanticSearchResultsType resultsType;

    private SemanticSearchResults(SearchPagedResponse pagedResponse) {
        this.queryAnswers = SearchPagedResponseAccessHelper.getQueryAnswers(pagedResponse);
        this.errorReason = SearchPagedResponseAccessHelper.getSemanticErrorReason(pagedResponse);
        this.resultsType = SearchPagedResponseAccessHelper.getSemanticSearchResultsType(pagedResponse);
    }

    public List<QueryAnswerResult> getQueryAnswers() {
        return this.queryAnswers;
    }

    public SemanticErrorReason getErrorReason() {
        return this.errorReason;
    }

    public SemanticSearchResultsType getResultsType() {
        return this.resultsType;
    }

    static {
        SemanticSearchResultsAccessHelper.setAccessor(SemanticSearchResults::new);
    }
}

