/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;

public final class ShingleTokenFilter
extends TokenFilter {
    private String odataType = "#Microsoft.Azure.Search.ShingleTokenFilter";
    private Integer maxShingleSize;
    private Integer minShingleSize;
    private Boolean outputUnigrams;
    private Boolean outputUnigramsIfNoShingles;
    private String tokenSeparator;
    private String filterToken;

    public ShingleTokenFilter(String name) {
        super(name);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public Integer getMaxShingleSize() {
        return this.maxShingleSize;
    }

    public ShingleTokenFilter setMaxShingleSize(Integer maxShingleSize) {
        this.maxShingleSize = maxShingleSize;
        return this;
    }

    public Integer getMinShingleSize() {
        return this.minShingleSize;
    }

    public ShingleTokenFilter setMinShingleSize(Integer minShingleSize) {
        this.minShingleSize = minShingleSize;
        return this;
    }

    public Boolean areOutputUnigrams() {
        return this.outputUnigrams;
    }

    public ShingleTokenFilter setOutputUnigrams(Boolean outputUnigrams) {
        this.outputUnigrams = outputUnigrams;
        return this;
    }

    public Boolean areOutputUnigramsIfNoShingles() {
        return this.outputUnigramsIfNoShingles;
    }

    public ShingleTokenFilter setOutputUnigramsIfNoShingles(Boolean outputUnigramsIfNoShingles) {
        this.outputUnigramsIfNoShingles = outputUnigramsIfNoShingles;
        return this;
    }

    public String getTokenSeparator() {
        return this.tokenSeparator;
    }

    public ShingleTokenFilter setTokenSeparator(String tokenSeparator) {
        this.tokenSeparator = tokenSeparator;
        return this;
    }

    public String getFilterToken() {
        return this.filterToken;
    }

    public ShingleTokenFilter setFilterToken(String filterToken) {
        this.filterToken = filterToken;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeNumberField("maxShingleSize", (Number)this.maxShingleSize);
        jsonWriter.writeNumberField("minShingleSize", (Number)this.minShingleSize);
        jsonWriter.writeBooleanField("outputUnigrams", this.outputUnigrams);
        jsonWriter.writeBooleanField("outputUnigramsIfNoShingles", this.outputUnigramsIfNoShingles);
        jsonWriter.writeStringField("tokenSeparator", this.tokenSeparator);
        jsonWriter.writeStringField("filterToken", this.filterToken);
        return jsonWriter.writeEndObject();
    }

    public static ShingleTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (ShingleTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.ShingleTokenFilter";
            Integer maxShingleSize = null;
            Integer minShingleSize = null;
            Boolean outputUnigrams = null;
            Boolean outputUnigramsIfNoShingles = null;
            String tokenSeparator = null;
            String filterToken = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("maxShingleSize".equals(fieldName)) {
                    maxShingleSize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("minShingleSize".equals(fieldName)) {
                    minShingleSize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("outputUnigrams".equals(fieldName)) {
                    outputUnigrams = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("outputUnigramsIfNoShingles".equals(fieldName)) {
                    outputUnigramsIfNoShingles = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("tokenSeparator".equals(fieldName)) {
                    tokenSeparator = reader.getString();
                    continue;
                }
                if ("filterToken".equals(fieldName)) {
                    filterToken = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                ShingleTokenFilter deserializedShingleTokenFilter = new ShingleTokenFilter(name);
                deserializedShingleTokenFilter.odataType = odataType;
                deserializedShingleTokenFilter.maxShingleSize = maxShingleSize;
                deserializedShingleTokenFilter.minShingleSize = minShingleSize;
                deserializedShingleTokenFilter.outputUnigrams = outputUnigrams;
                deserializedShingleTokenFilter.outputUnigramsIfNoShingles = outputUnigramsIfNoShingles;
                deserializedShingleTokenFilter.tokenSeparator = tokenSeparator;
                deserializedShingleTokenFilter.filterToken = filterToken;
                return deserializedShingleTokenFilter;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

