/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class StemmerOverrideTokenFilter
extends TokenFilter {
    private final List<String> rules;

    public StemmerOverrideTokenFilter(String name, List<String> rules) {
        super(name);
        this.rules = rules;
    }

    public List<String> getRules() {
        return this.rules;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.StemmerOverrideTokenFilter");
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static StemmerOverrideTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (StemmerOverrideTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean rulesFound = false;
            List rules = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Azure.Search.StemmerOverrideTokenFilter".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.StemmerOverrideTokenFilter'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("rules".equals(fieldName)) {
                    rules = reader.readArray(reader1 -> reader1.getString());
                    rulesFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && rulesFound) {
                StemmerOverrideTokenFilter deserializedStemmerOverrideTokenFilter = new StemmerOverrideTokenFilter(name, rules);
                return deserializedStemmerOverrideTokenFilter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!rulesFound) {
                missingProperties.add("rules");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

